/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.local;

import com.intellij.internal.statistic.local.LanguageUsageStatistics;
import com.intellij.internal.statistic.local.LanguageUsageStatisticsProvider;
import com.intellij.internal.statistic.local.LanguageUsageStatisticsProviderImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LanguageUsageStatistics", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")}, reportStatistic=false)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/local/LanguageUsageStatisticsProviderImpl;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/internal/statistic/local/LanguageUsageStatisticsProviderImpl$LanguageStatisticsState;", "Lcom/intellij/internal/statistic/local/LanguageUsageStatisticsProvider;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "()V", "state", "getMostRecentlyUsedLanguage", "", "getMostUsedLanguage", "getState", "getStatistics", "", "Lcom/intellij/internal/statistic/local/LanguageUsageStatistics;", "getStatisticsForLanguage", "language", "Lcom/intellij/lang/Language;", "loadState", "", "updateLanguageStatistics", "LanguageStatisticsState", "SimpleLanguageUsageStatistics", "intellij.platform.ml.impl"})
@SourceDebugExtension(value={"SMAP\nLanguageUsageStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageUsageStatistics.kt\ncom/intellij/internal/statistic/local/LanguageUsageStatisticsProviderImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n442#2:91\n392#2:92\n1238#3,4:93\n1#4:97\n*S KotlinDebug\n*F\n+ 1 LanguageUsageStatistics.kt\ncom/intellij/internal/statistic/local/LanguageUsageStatisticsProviderImpl\n*L\n48#1:91\n48#1:92\n48#1:93,4\n*E\n"})
public final class LanguageUsageStatisticsProviderImpl
extends SimpleModificationTracker
implements PersistentStateComponent<LanguageStatisticsState>,
LanguageUsageStatisticsProvider {
    @NotNull
    private volatile LanguageStatisticsState state = new LanguageStatisticsState(null, 1, null);

    @NotNull
    public LanguageStatisticsState getState() {
        return this.state;
    }

    public void loadState(@NotNull LanguageStatisticsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @Override
    @NotNull
    public LanguageUsageStatistics getStatisticsForLanguage(@NotNull Language language) {
        LanguageUsageStatistics languageUsageStatistics;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        SimpleLanguageUsageStatistics simpleLanguageUsageStatistics = this.state.getData().get(language.getID());
        if (simpleLanguageUsageStatistics != null) {
            SimpleLanguageUsageStatistics stats2 = simpleLanguageUsageStatistics;
            boolean bl = false;
            boolean isMostUsed = Intrinsics.areEqual((Object)language.getID(), (Object)this.getMostUsedLanguage());
            boolean isMostRecent = Intrinsics.areEqual((Object)language.getID(), (Object)this.getMostRecentlyUsedLanguage());
            languageUsageStatistics = new LanguageUsageStatistics(stats2.useCount, isMostUsed, stats2.lastUsed, isMostRecent);
        } else {
            languageUsageStatistics = LanguageUsageStatistics.Companion.getNEVER_USED();
        }
        return languageUsageStatistics;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, LanguageUsageStatistics> getStatistics() {
        void $this$mapValuesTo$iv$iv;
        String string2 = this.getMostUsedLanguage();
        if (string2 == null) {
            return MapsKt.emptyMap();
        }
        String mostUsedLanguage = string2;
        String string3 = this.getMostRecentlyUsedLanguage();
        if (string3 == null) {
            return MapsKt.emptyMap();
        }
        String mostRecentLanguage = string3;
        Map<String, SimpleLanguageUsageStatistics> $this$mapValues$iv = this.state.getData();
        boolean $i$f$mapValues = false;
        Map<String, SimpleLanguageUsageStatistics> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String language = (String)entry3.getKey();
            SimpleLanguageUsageStatistics stats2 = (SimpleLanguageUsageStatistics)entry3.getValue();
            boolean isMostUsed = Intrinsics.areEqual((Object)mostUsedLanguage, (Object)language);
            boolean isMostRecent = Intrinsics.areEqual((Object)mostRecentLanguage, (Object)language);
            LanguageUsageStatistics languageUsageStatistics = new LanguageUsageStatistics(stats2.useCount, isMostUsed, stats2.lastUsed, isMostRecent);
            map4.put(k, languageUsageStatistics);
        }
        return destination$iv$iv;
    }

    private final String getMostUsedLanguage() {
        Object v0;
        Iterable iterable = this.state.getData().entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                int n = ((SimpleLanguageUsageStatistics)it.getValue()).useCount;
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-LanguageUsageStatisticsProviderImpl$getMostUsedLanguage$1 = false;
                    int n2 = ((SimpleLanguageUsageStatistics)it2.getValue()).useCount;
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry2 = v0;
        return entry2 != null ? (String)entry2.getKey() : null;
    }

    private final String getMostRecentlyUsedLanguage() {
        Object v0;
        Iterable iterable = this.state.getData().entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                long l = ((SimpleLanguageUsageStatistics)it.getValue()).lastUsed;
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-LanguageUsageStatisticsProviderImpl$getMostRecentlyUsedLanguage$1 = false;
                    long l2 = ((SimpleLanguageUsageStatistics)it2.getValue()).lastUsed;
                    if (l >= l2) continue;
                    t = t2;
                    l = l2;
                } while (iterator.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry2 = v0;
        return entry2 != null ? (String)entry2.getKey() : null;
    }

    @Override
    public void updateLanguageStatistics(@NotNull Language language) {
        SimpleLanguageUsageStatistics stats2;
        SimpleLanguageUsageStatistics simpleLanguageUsageStatistics;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        SimpleLanguageUsageStatistics simpleLanguageUsageStatistics2 = this.state.getData().computeIfAbsent(language.getID(), arg_0 -> LanguageUsageStatisticsProviderImpl.updateLanguageStatistics$lambda$4(updateLanguageStatistics.stats.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)simpleLanguageUsageStatistics2, (String)"state.data.computeIfAbse\u2026nguageUsageStatistics() }");
        SimpleLanguageUsageStatistics $this$updateLanguageStatistics_u24lambda_u245 = simpleLanguageUsageStatistics = (stats2 = simpleLanguageUsageStatistics2);
        boolean bl = false;
        int n = $this$updateLanguageStatistics_u24lambda_u245.useCount;
        $this$updateLanguageStatistics_u24lambda_u245.useCount = n + 1;
        $this$updateLanguageStatistics_u24lambda_u245.lastUsed = System.currentTimeMillis();
        this.incModificationCount();
    }

    private static final SimpleLanguageUsageStatistics updateLanguageStatistics$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SimpleLanguageUsageStatistics)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001f\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/local/LanguageUsageStatisticsProviderImpl$LanguageStatisticsState;", "", "data", "", "", "Lcom/intellij/internal/statistic/local/LanguageUsageStatisticsProviderImpl$SimpleLanguageUsageStatistics;", "(Ljava/util/Map;)V", "getData", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ml.impl"})
    public static final class LanguageStatisticsState {
        @NotNull
        private final Map<String, SimpleLanguageUsageStatistics> data;

        public LanguageStatisticsState(@NotNull Map<String, SimpleLanguageUsageStatistics> data2) {
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            this.data = data2;
        }

        public /* synthetic */ LanguageStatisticsState(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = new HashMap();
            }
            this(map2);
        }

        @XMap(entryTagName="language", keyAttributeName="id")
        @Property(surroundWithTag=false)
        @NotNull
        public final Map<String, SimpleLanguageUsageStatistics> getData() {
            return this.data;
        }

        @NotNull
        public final Map<String, SimpleLanguageUsageStatistics> component1() {
            return this.data;
        }

        @NotNull
        public final LanguageStatisticsState copy(@NotNull Map<String, SimpleLanguageUsageStatistics> data2) {
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            return new LanguageStatisticsState(data2);
        }

        public static /* synthetic */ LanguageStatisticsState copy$default(LanguageStatisticsState languageStatisticsState, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = languageStatisticsState.data;
            }
            return languageStatisticsState.copy(map2);
        }

        @NotNull
        public String toString() {
            return "LanguageStatisticsState(data=" + this.data + ")";
        }

        public int hashCode() {
            return ((Object)this.data).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LanguageStatisticsState)) {
                return false;
            }
            LanguageStatisticsState languageStatisticsState = (LanguageStatisticsState)other;
            return Intrinsics.areEqual(this.data, languageStatisticsState.data);
        }

        public LanguageStatisticsState() {
            this(null, 1, null);
        }
    }

    @Tag(value="summary")
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/local/LanguageUsageStatisticsProviderImpl$SimpleLanguageUsageStatistics;", "", "()V", "useCount", "", "lastUsed", "", "(IJ)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ml.impl"})
    public static final class SimpleLanguageUsageStatistics {
        @Attribute(value="usageCount")
        @JvmField
        public int useCount;
        @Attribute(value="lastUsage")
        @JvmField
        public long lastUsed;

        public SimpleLanguageUsageStatistics(int useCount, long lastUsed) {
            this.useCount = useCount;
            this.lastUsed = lastUsed;
        }

        public SimpleLanguageUsageStatistics() {
            this(0, 0L);
        }

        public final int component1() {
            return this.useCount;
        }

        public final long component2() {
            return this.lastUsed;
        }

        @NotNull
        public final SimpleLanguageUsageStatistics copy(int useCount, long lastUsed) {
            return new SimpleLanguageUsageStatistics(useCount, lastUsed);
        }

        public static /* synthetic */ SimpleLanguageUsageStatistics copy$default(SimpleLanguageUsageStatistics simpleLanguageUsageStatistics, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = simpleLanguageUsageStatistics.useCount;
            }
            if ((n2 & 2) != 0) {
                l = simpleLanguageUsageStatistics.lastUsed;
            }
            return simpleLanguageUsageStatistics.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "SimpleLanguageUsageStatistics(useCount=" + this.useCount + ", lastUsed=" + this.lastUsed + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.useCount);
            result2 = result2 * 31 + Long.hashCode(this.lastUsed);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SimpleLanguageUsageStatistics)) {
                return false;
            }
            SimpleLanguageUsageStatistics simpleLanguageUsageStatistics = (SimpleLanguageUsageStatistics)other;
            if (this.useCount != simpleLanguageUsageStatistics.useCount) {
                return false;
            }
            return this.lastUsed == simpleLanguageUsageStatistics.lastUsed;
        }
    }
}

