/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VersionManagingFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaGateway {
    private static final Key<ContentAndTimestamps> SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY = Key.create((String)"LocalHistory.SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY");
    private static final ThreadLocal<VfsEventDispatchContext> ourCurrentEventDispatchContext = new ThreadLocal();

    public boolean isVersioned(@NotNull VirtualFile f) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(0);
        }
        return this.isVersioned(f, false);
    }

    public boolean isVersioned(@NotNull VirtualFile f, boolean shouldBeInContent) {
        CharSequence fileName;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(1);
        }
        if (VersionManagingFileSystem.isDisabled((VirtualFile)f)) {
            return false;
        }
        if (!f.isInLocalFileSystem()) {
            return VersionManagingFileSystem.isEnforcedNonLocal((VirtualFile)f);
        }
        if (!f.isDirectory() && (StringUtil.equals((CharSequence)(fileName = f.getNameSequence()), (CharSequence)"workspace.xml") || StringUtil.endsWith((CharSequence)fileName, (CharSequence)".iws") || StringUtil.endsWith((CharSequence)fileName, (CharSequence)".class"))) {
            return false;
        }
        VersionedFilterData versionedFilterData = IdeaGateway.getVersionedFilterData();
        int numberOfOpenProjects = versionedFilterData.myOpenedProjects.size();
        if (numberOfOpenProjects == 0) {
            if (shouldBeInContent) {
                return false;
            }
            return !FileTypeManager.getInstance().isFileIgnored(f);
        }
        boolean isExcludedFromAll = true;
        boolean isInContent = false;
        for (int i = 0; i < numberOfOpenProjects; ++i) {
            ProjectFileIndex index = versionedFilterData.myProjectFileIndices.get(i);
            if (index.isUnderIgnored(f)) {
                return false;
            }
            isInContent |= index.isInContent(f);
            isExcludedFromAll &= index.isExcluded(f);
        }
        if (isExcludedFromAll) {
            return false;
        }
        return !shouldBeInContent || isInContent;
    }

    public String getPathOrUrl(@NotNull VirtualFile file) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(2);
        }
        return file.isInLocalFileSystem() ? file.getPath() : file.getUrl();
    }

    @NotNull
    protected static VersionedFilterData getVersionedFilterData() {
        VersionedFilterData versionedFilterData;
        VfsEventDispatchContext vfsEventDispatchContext = ourCurrentEventDispatchContext.get();
        if (vfsEventDispatchContext != null) {
            versionedFilterData = vfsEventDispatchContext.myFilterData;
            if (versionedFilterData == null) {
                versionedFilterData = vfsEventDispatchContext.myFilterData = new VersionedFilterData();
            }
        } else {
            versionedFilterData = new VersionedFilterData();
        }
        VersionedFilterData versionedFilterData2 = versionedFilterData;
        if (versionedFilterData2 == null) {
            IdeaGateway.$$$reportNull$$$0(3);
        }
        return versionedFilterData2;
    }

    public void runWithVfsEventsDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents, Runnable action2) {
        try (VfsEventDispatchContext ignored = new VfsEventDispatchContext(events, beforeEvents);){
            action2.run();
        }
    }

    public boolean areContentChangesVersioned(@NotNull VirtualFile f) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(4);
        }
        return this.isVersioned(f) && !f.isDirectory() && (this.areContentChangesVersioned(f.getName()) || ScratchFileService.findRootType((VirtualFile)f) != null);
    }

    public boolean areContentChangesVersioned(@NotNull String fileName) {
        if (fileName == null) {
            IdeaGateway.$$$reportNull$$$0(5);
        }
        return !FileTypeManager.getInstance().getFileTypeByFileName(fileName).isBinary();
    }

    public boolean ensureFilesAreWritable(@NotNull Project p, @NotNull List<? extends VirtualFile> ff) {
        ReadonlyStatusHandler h;
        if (p == null) {
            IdeaGateway.$$$reportNull$$$0(6);
        }
        if (ff == null) {
            IdeaGateway.$$$reportNull$$$0(7);
        }
        return !(h = ReadonlyStatusHandler.getInstance((Project)p)).ensureFilesWritable(ff).hasReadonlyFiles();
    }

    @Nullable
    public VirtualFile findVirtualFile(@NotNull String path2) {
        if (path2 == null) {
            IdeaGateway.$$$reportNull$$$0(8);
        }
        if (path2.contains("://")) {
            return VirtualFileManager.getInstance().findFileByUrl(path2);
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path2);
        if (file == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(path2);
        }
        return file;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull VirtualFile parent, @NotNull String name, boolean isDirectory) throws IOException {
        VirtualFile f;
        if (parent == null) {
            IdeaGateway.$$$reportNull$$$0(9);
        }
        if (name == null) {
            IdeaGateway.$$$reportNull$$$0(10);
        }
        if ((f = parent.findChild(name)) != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f;
        if (virtualFile == null) {
            IdeaGateway.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull String path2, boolean isDirectory) throws IOException {
        VirtualFile f;
        if (path2 == null) {
            IdeaGateway.$$$reportNull$$$0(12);
        }
        if ((f = this.findVirtualFile(path2)) != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            VirtualFile parent = this.findOrCreateFileSafely(Paths.getParentOf(path2), true);
            String name = Paths.getNameOf(path2);
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f;
        if (virtualFile == null) {
            IdeaGateway.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    public List<VirtualFile> getAllFilesFrom(@NotNull String path2) {
        VirtualFile f;
        if (path2 == null) {
            IdeaGateway.$$$reportNull$$$0(14);
        }
        if ((f = this.findVirtualFile(path2)) == null) {
            return Collections.emptyList();
        }
        return IdeaGateway.collectFiles(f, new ArrayList<VirtualFile>());
    }

    @NotNull
    private static List<VirtualFile> collectFiles(@NotNull VirtualFile f, @NotNull List<VirtualFile> result2) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            IdeaGateway.$$$reportNull$$$0(16);
        }
        if (f.isDirectory()) {
            for (VirtualFile child : IdeaGateway.iterateDBChildren(f)) {
                IdeaGateway.collectFiles(child, result2);
            }
        } else {
            result2.add(f);
        }
        List<VirtualFile> list = result2;
        if (list == null) {
            IdeaGateway.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public static Iterable<VirtualFile> iterateDBChildren(VirtualFile f) {
        if (!(f instanceof NewVirtualFile)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                IdeaGateway.$$$reportNull$$$0(18);
            }
            return list;
        }
        NewVirtualFile nf = (NewVirtualFile)f;
        Iterable iterable = nf.iterInDbChildrenWithoutLoadingVfsFromOtherProjects();
        if (iterable == null) {
            IdeaGateway.$$$reportNull$$$0(19);
        }
        return iterable;
    }

    @NotNull
    public static Iterable<VirtualFile> loadAndIterateChildren(VirtualFile f) {
        if (!(f instanceof NewVirtualFile)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                IdeaGateway.$$$reportNull$$$0(20);
            }
            return list;
        }
        NewVirtualFile nf = (NewVirtualFile)f;
        List<VirtualFile> list = Arrays.asList(nf.getChildren());
        if (list == null) {
            IdeaGateway.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public RootEntry createTransientRootEntry() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildren(root, IdeaGateway.getLocalRoots(), false);
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            IdeaGateway.$$$reportNull$$$0(22);
        }
        return rootEntry;
    }

    @NotNull
    public RootEntry createTransientRootEntryForPathOnly(@NotNull String path2) {
        if (path2 == null) {
            IdeaGateway.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildrenForPathOnly(root, path2, IdeaGateway.getLocalRoots());
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            IdeaGateway.$$$reportNull$$$0(24);
        }
        return rootEntry;
    }

    private static List<VirtualFile> getLocalRoots() {
        SmartList roots = new SmartList();
        for (VirtualFile root : ManagingFS.getInstance().getRoots()) {
            if (!root.isInLocalFileSystem() && !VersionManagingFileSystem.isEnforcedNonLocal((VirtualFile)root) || root.getFileSystem() instanceof TempFileSystem) continue;
            roots.add(root);
        }
        return roots;
    }

    private void doCreateChildrenForPathOnly(@NotNull DirectoryEntry parent, @NotNull String path2, @NotNull Iterable<? extends VirtualFile> children) {
        if (parent == null) {
            IdeaGateway.$$$reportNull$$$0(25);
        }
        if (path2 == null) {
            IdeaGateway.$$$reportNull$$$0(26);
        }
        if (children == null) {
            IdeaGateway.$$$reportNull$$$0(27);
        }
        for (VirtualFile virtualFile : children) {
            Entry e;
            String rest;
            String name = StringUtil.trimStart((String)virtualFile.getName(), (String)"/");
            if (!path2.startsWith(name) || !(rest = path2.substring(name.length())).isEmpty() && rest.charAt(0) != '/') continue;
            if (!rest.isEmpty() && rest.charAt(0) == '/') {
                rest = rest.substring(1);
            }
            if ((e = this.doCreateEntryForPathOnly(virtualFile, rest)) == null) continue;
            parent.addChild(e);
        }
    }

    @Nullable
    private Entry doCreateEntryForPathOnly(@NotNull VirtualFile file, @NotNull String path2) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(28);
        }
        if (path2 == null) {
            IdeaGateway.$$$reportNull$$$0(29);
        }
        if (!file.isDirectory()) {
            if (!this.isVersioned(file)) {
                return null;
            }
            return this.doCreateFileEntry(file, IdeaGateway.getActualContentNoAcquire(file));
        }
        DirectoryEntry newDir = new DirectoryEntry(file.getName());
        this.doCreateChildrenForPathOnly(newDir, path2, IdeaGateway.iterateDBChildren(file));
        if (!this.isVersioned(file) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return newDir;
    }

    @Nullable
    public Entry createTransientEntry(@NotNull VirtualFile file) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(30);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file, false);
    }

    @Nullable
    public Entry createEntryForDeletion(@NotNull VirtualFile file) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file, true);
    }

    @Nullable
    private Entry doCreateEntry(@NotNull VirtualFile file, boolean forDeletion) {
        DirectoryEntry res;
        int nameId;
        boolean nonLocalRoot;
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(32);
        }
        if (!file.isDirectory()) {
            Pair<StoredContent, Long> contentAndStamps;
            if (!this.isVersioned(file)) {
                return null;
            }
            if (forDeletion) {
                FileDocumentManager m = FileDocumentManager.getInstance();
                Document d = m.isFileModified(file) ? m.getCachedDocument(file) : null;
                contentAndStamps = this.acquireAndClearCurrentContent(file, d);
            } else {
                contentAndStamps = IdeaGateway.getActualContentNoAcquire(file);
            }
            return this.doCreateFileEntry(file, contentAndStamps);
        }
        DirectoryEntry newDir = null;
        boolean bl = nonLocalRoot = !file.isInLocalFileSystem() && file.getParent() == null;
        if (file instanceof VirtualFileSystemEntry && !nonLocalRoot && (nameId = ((VirtualFileSystemEntry)file).getNameId()) > 0) {
            newDir = new DirectoryEntry(nameId);
        }
        if (newDir == null) {
            if (nonLocalRoot) {
                DirectoryEntry first = null;
                for (String item2 : Paths.split(file.getUrl())) {
                    DirectoryEntry cur = new DirectoryEntry(item2);
                    if (first == null) {
                        first = cur;
                    }
                    if (newDir != null) {
                        newDir.addChild(cur);
                    }
                    newDir = cur;
                }
                res = first;
            } else {
                res = newDir = new DirectoryEntry(file.getName());
            }
        } else {
            res = newDir;
        }
        this.doCreateChildren(newDir, IdeaGateway.iterateDBChildren(file), forDeletion);
        if (!this.isVersioned(file) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return res;
    }

    @NotNull
    private Entry doCreateFileEntry(@NotNull VirtualFile file, Pair<StoredContent, Long> contentAndStamps) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(33);
        }
        if (file instanceof VirtualFileSystemEntry) {
            return new FileEntry(((VirtualFileSystemEntry)file).getNameId(), (Content)contentAndStamps.first, (long)((Long)contentAndStamps.second), !file.isWritable());
        }
        return new FileEntry(file.getName(), (Content)contentAndStamps.first, (long)((Long)contentAndStamps.second), !file.isWritable());
    }

    private void doCreateChildren(@NotNull DirectoryEntry parent, Iterable<? extends VirtualFile> children, boolean forDeletion) {
        if (parent == null) {
            IdeaGateway.$$$reportNull$$$0(34);
        }
        List entries2 = ContainerUtil.mapNotNull(children, each -> this.doCreateEntry((VirtualFile)each, forDeletion));
        parent.addChildren(entries2);
    }

    public void registerUnsavedDocuments(@NotNull LocalHistoryFacade vcs) {
        if (vcs == null) {
            IdeaGateway.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            vcs.beginChangeSet();
            for (Document d : FileDocumentManager.getInstance().getUnsavedDocuments()) {
                VirtualFile f = IdeaGateway.getFile(d);
                if (!this.shouldRegisterDocument(f)) continue;
                this.registerDocumentContents(vcs, f, d);
            }
            vcs.endChangeSet(null);
        });
    }

    private boolean shouldRegisterDocument(@Nullable VirtualFile f) {
        return f != null && f.isValid() && this.areContentChangesVersioned(f);
    }

    private void registerDocumentContents(@NotNull LocalHistoryFacade vcs, @NotNull VirtualFile f, Document d) {
        Pair<StoredContent, Long> contentAndStamp;
        if (vcs == null) {
            IdeaGateway.$$$reportNull$$$0(36);
        }
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(37);
        }
        if ((contentAndStamp = this.acquireAndUpdateActualContent(f, d)) != null) {
            vcs.contentChanged(this.getPathOrUrl(f), (Content)contentAndStamp.first, (Long)contentAndStamp.second);
        }
    }

    @Nullable
    public Pair<StoredContent, Long> acquireAndUpdateActualContent(@NotNull VirtualFile f, @Nullable Document d) {
        ContentAndTimestamps contentAndStamp;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(38);
        }
        if ((contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY)) == null) {
            if (d != null) {
                IdeaGateway.saveDocumentContent(f, d);
            }
            return Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        }
        if (d == null) {
            f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
            return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
        }
        if (d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            return null;
        }
        IdeaGateway.saveDocumentContent(f, d);
        return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
    }

    private static void saveDocumentContent(@NotNull VirtualFile f, @NotNull Document d) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(39);
        }
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(40);
        }
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, (Object)new ContentAndTimestamps(Clock.getTime(), StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), d.getModificationStamp()));
    }

    @NotNull
    public Pair<StoredContent, Long> acquireAndClearCurrentContent(@NotNull VirtualFile f, @Nullable Document d) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(41);
        }
        ContentAndTimestamps contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
        if (d != null && contentAndStamp != null && d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            Pair pair = Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
            if (pair == null) {
                IdeaGateway.$$$reportNull$$$0(42);
            }
            return pair;
        }
        if (contentAndStamp != null) {
            contentAndStamp.content.release();
        }
        if (d != null) {
            Pair pair = Pair.create((Object)StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), (Object)Clock.getTime());
            if (pair == null) {
                IdeaGateway.$$$reportNull$$$0(43);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        if (pair == null) {
            IdeaGateway.$$$reportNull$$$0(44);
        }
        return pair;
    }

    @NotNull
    private static Pair<StoredContent, Long> getActualContentNoAcquire(@NotNull VirtualFile f) {
        ContentAndTimestamps result2;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(45);
        }
        if ((result2 = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY)) == null) {
            Pair pair = Pair.create((Object)StoredContent.transientContent(f), (Object)f.getTimeStamp());
            if (pair == null) {
                IdeaGateway.$$$reportNull$$$0(46);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)result2.content, (Object)result2.registeredTimestamp);
        if (pair == null) {
            IdeaGateway.$$$reportNull$$$0(47);
        }
        return pair;
    }

    private static byte[] bytesFromDocument(@NotNull Document d) {
        VirtualFile file;
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(48);
        }
        Charset charset = (file = IdeaGateway.getFile(d)) != null ? file.getCharset() : EncodingRegistry.getInstance().getDefaultCharset();
        return d.getText().getBytes(charset);
    }

    public String stringFromBytes(byte @NotNull [] bytes, @NotNull String path2) {
        VirtualFile file;
        if (path2 == null) {
            IdeaGateway.$$$reportNull$$$0(49);
        }
        if (bytes == null) {
            IdeaGateway.$$$reportNull$$$0(50);
        }
        Charset charset = (file = this.findVirtualFile(path2)) != null ? file.getCharset() : EncodingRegistry.getInstance().getDefaultCharset();
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
    }

    public void saveAllUnsavedDocuments() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Document d) {
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(51);
        }
        return FileDocumentManager.getInstance().getFile(d);
    }

    @Nullable
    public Document getDocument(@NotNull String path2) {
        if (path2 == null) {
            IdeaGateway.$$$reportNull$$$0(52);
        }
        return FileDocumentManager.getInstance().getDocument(this.findVirtualFile(path2));
    }

    @NotNull
    public FileType getFileType(@NotNull String fileName) {
        if (fileName == null) {
            IdeaGateway.$$$reportNull$$$0(53);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == null) {
            IdeaGateway.$$$reportNull$$$0(54);
        }
        return fileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11, 13, 17, 18, 19, 20, 21, 22, 24, 42, 43, 44, 46, 47, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 2: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/IdeaGateway";
                break;
            }
            case 5: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ff";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 23: 
            case 26: 
            case 29: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 40: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/IdeaGateway";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionedFilterData";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateFileSafely";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateDBChildren";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndIterateChildren";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTransientRootEntry";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createTransientRootEntryForPathOnly";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireAndClearCurrentContent";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualContentNoAcquire";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isVersioned";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathOrUrl";
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 54: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areContentChangesVersioned";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesAreWritable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateFileSafely";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllFilesFrom";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTransientRootEntryForPathOnly";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doCreateChildrenForPathOnly";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doCreateEntryForPathOnly";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createTransientEntry";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createEntryForDeletion";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doCreateEntry";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doCreateFileEntry";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doCreateChildren";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "registerUnsavedDocuments";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "registerDocumentContents";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "acquireAndUpdateActualContent";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentContent";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "acquireAndClearCurrentContent";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getActualContentNoAcquire";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "bytesFromDocument";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "stringFromBytes";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 11, 13, 17, 18, 19, 20, 21, 22, 24, 42, 43, 44, 46, 47, 54 -> new IllegalStateException(string2);
        };
    }

    private static class VersionedFilterData {
        final List<Project> myOpenedProjects = new ArrayList<Project>();
        final List<ProjectFileIndex> myProjectFileIndices = new ArrayList<ProjectFileIndex>();

        VersionedFilterData() {
            Project[] openProjects;
            for (Project each : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                if (each.isDefault() || !each.isInitialized()) continue;
                this.myOpenedProjects.add(each);
                this.myProjectFileIndices.add(ProjectRootManager.getInstance((Project)each).getFileIndex());
            }
        }
    }

    private static class VfsEventDispatchContext
    implements AutoCloseable {
        final List<? extends VFileEvent> myEvents;
        final boolean myBeforeEvents;
        final VfsEventDispatchContext myPreviousContext;
        VersionedFilterData myFilterData;

        VfsEventDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents) {
            this.myEvents = events;
            this.myBeforeEvents = beforeEvents;
            this.myPreviousContext = ourCurrentEventDispatchContext.get();
            if (this.myPreviousContext != null) {
                this.myFilterData = this.myPreviousContext.myFilterData;
            }
            ourCurrentEventDispatchContext.set(this);
        }

        @Override
        public void close() {
            ourCurrentEventDispatchContext.set(this.myPreviousContext);
            if (this.myPreviousContext != null && this.myPreviousContext.myFilterData == null && this.myFilterData != null) {
                this.myPreviousContext.myFilterData = this.myFilterData;
            }
        }
    }

    private static final class ContentAndTimestamps {
        long registeredTimestamp;
        StoredContent content;
        long documentModificationStamp;

        private ContentAndTimestamps(long registeredTimestamp, StoredContent content, long documentModificationStamp) {
            this.registeredTimestamp = registeredTimestamp;
            this.content = content;
            this.documentModificationStamp = documentModificationStamp;
        }
    }
}

