/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.internal.ml.ngram.NGramIncrementalModelRunner;
import com.intellij.internal.ml.ngram.NGramModelSerializer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryPersistence;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NGRAM_FILE_NAME_SUFFIX", "", "deleteLegacyFile", "", "project", "Lcom/intellij/openapi/project/Project;", "getPathToStorage", "Ljava/nio/file/Path;", "suffix", "loadNGrams", "Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;", "nGramLength", "", "saveNGramsAsync", "runner", "intellij.platform.ml.impl"})
public final class FileHistoryPersistence {
    @NotNull
    public static final FileHistoryPersistence INSTANCE = new FileHistoryPersistence();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String NGRAM_FILE_NAME_SUFFIX = "-ngram";

    private FileHistoryPersistence() {
    }

    public final void deleteLegacyFile(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        try {
            Path path2;
            if (!project2.isDisposed() && (path2 = this.getPathToStorage(project2, ".xml")) != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    PathKt.delete$default((Path)path2, (boolean)false, (int)1, null);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot deserialize file sequence ngrams", (Throwable)e);
        }
    }

    public final void saveNGramsAsync(@NotNull Project project2, @NotNull NGramIncrementalModelRunner runner) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        Path path2 = this.getPathToStorage(project2, NGRAM_FILE_NAME_SUFFIX);
        if (path2 == null) {
            return;
        }
        Path path3 = path2;
        CoroutineScope coroutineScope = ApplicationManager.getApplication().getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getApplication().coroutineScope");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(path3, runner, null){
            int label;
            final /* synthetic */ Path $path;
            final /* synthetic */ NGramIncrementalModelRunner $runner;
            {
                this.$path = $path;
                this.$runner = $runner;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            Files.createDirectories(this.$path.getParent(), new FileAttribute[0]);
                            NGramModelSerializer.INSTANCE.saveNGrams(this.$path, this.$runner);
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            FileHistoryPersistence.access$getLOG$p().warn("Cannot serialize file sequence ngrams", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final NGramIncrementalModelRunner loadNGrams(@NotNull Project project2, int nGramLength) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        try {
            if (!project2.isDisposed()) {
                Path path2 = this.getPathToStorage(project2, NGRAM_FILE_NAME_SUFFIX);
                return NGramModelSerializer.INSTANCE.loadNGrams(path2, nGramLength);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot deserialize file sequence ngrams", (Throwable)e);
        }
        return NGramModelSerializer.INSTANCE.loadNGrams(null, nGramLength);
    }

    private final Path getPathToStorage(Project project2, String suffix) {
        String string2 = project2.getPresentableUrl();
        if (string2 == null) {
            return null;
        }
        String url = string2;
        Path projectPath = Paths.get(VirtualFileManager.extractPath((String)url), new String[0]);
        Object object = projectPath.getFileName();
        if (object == null || (object = object.toString()) == null) {
            String string3 = ((Object)projectPath).toString().substring(0, 1);
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        Object dirName = object;
        String string4 = PathUtil.suggestFileName((String)((String)dirName + Integer.toHexString(((Object)projectPath).toString().hashCode())));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"suggestFileName(dirName \u2026h.toString().hashCode()))");
        String storageName = string4;
        String[] stringArray = new String[]{"fileHistory", storageName + suffix};
        return Path.of(PathManager.getSystemPath(), stringArray);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(FileHistoryPersistence.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(FileHistoryPersistence::class.java)");
        LOG = logger;
    }
}

