/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.CommitNodeUiRenderExtension;
import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.util.VcsUserUtil;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CommitNode
extends DefaultMutableTreeNode
implements CustomRenderedTreeNode,
TooltipNode {
    private static final ExtensionPointName<CommitNodeUiRenderExtension> COMMIT_NODE_RENDERER_EP = ExtensionPointName.create((String)"com.intellij.commitNodeUiRenderExtension");
    @NotNull
    private final Project myProject;

    public CommitNode(@NotNull Project project2, @NotNull VcsFullCommitDetails commit2) {
        if (project2 == null) {
            CommitNode.$$$reportNull$$$0(0);
        }
        if (commit2 == null) {
            CommitNode.$$$reportNull$$$0(1);
        }
        super(commit2, false);
        this.myProject = project2;
    }

    @Override
    public VcsFullCommitDetails getUserObject() {
        return (VcsFullCommitDetails)super.getUserObject();
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            CommitNode.$$$reportNull$$$0(2);
        }
        renderer.append("   ");
        COMMIT_NODE_RENDERER_EP.forEachExtensionSafe(it -> it.render(this.myProject, renderer, this));
        TreeNode parent = this.getParent();
        new IssueLinkRenderer(this.myProject, (SimpleColoredComponent)renderer).appendTextWithLinks(this.getUserObject().getSubject(), PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer, SimpleTextAttributes.REGULAR_ATTRIBUTES, !(parent instanceof RepositoryNode) || ((RepositoryNode)((Object)parent)).isChecked()));
    }

    @Override
    @Nls
    public String getTooltip() {
        String hash2 = DvcsUtil.getShortHash(((Hash)this.getUserObject().getId()).toString());
        String date = DvcsUtil.getDateString(this.getUserObject());
        String author = VcsUserUtil.getShortPresentation(this.getUserObject().getAuthor());
        String message2 = IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, this.getUserObject().getFullMessage());
        return DvcsBundle.message("push.commit.node.tooltip.0.hash.1.date.2.author.3.message", hash2, date, author, message2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/push/ui/CommitNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

