/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005H\u0002\u001a$\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005H\u0002\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0003H\u0007\u001a \u0010\u000b\u001a\u00020\u0001*\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005H\u0007\u00a8\u0006\f"}, d2={"refreshListOnToolwindowShow", "", "toolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "onSelection", "Lkotlin/Function1;", "Lcom/intellij/ui/content/Content;", "refreshReviewListOnTabSelection", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "dontHideOnEmptyContent", "refreshReviewListOnSelection", "intellij.platform.collaborationTools"})
public final class ToolwindowUtilsKt {
    @ApiStatus.Internal
    public static final void dontHideOnEmptyContent(@NotNull ToolWindow $this$dontHideOnEmptyContent) {
        Intrinsics.checkNotNullParameter((Object)$this$dontHideOnEmptyContent, (String)"<this>");
        $this$dontHideOnEmptyContent.setToHideOnEmptyContent(false);
        ToolWindowEx toolWindowEx = $this$dontHideOnEmptyContent instanceof ToolWindowEx ? (ToolWindowEx)$this$dontHideOnEmptyContent : null;
        Object object = toolWindowEx != null ? toolWindowEx.getEmptyText() : null;
        if (object != null) {
            object.setText("");
        }
    }

    @ApiStatus.Internal
    public static final void refreshReviewListOnSelection(@NotNull ToolWindow $this$refreshReviewListOnSelection, @NotNull Function1<? super Content, Unit> onSelection) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshReviewListOnSelection, (String)"<this>");
        Intrinsics.checkNotNullParameter(onSelection, (String)"onSelection");
        ContentManager contentManager = $this$refreshReviewListOnSelection.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"contentManager");
        ToolwindowUtilsKt.refreshReviewListOnTabSelection(contentManager, onSelection);
        ToolwindowUtilsKt.refreshListOnToolwindowShow($this$refreshReviewListOnSelection, onSelection);
    }

    private static final void refreshReviewListOnTabSelection(ContentManager contentManager, Function1<? super Content, Unit> onSelection) {
        contentManager.addContentManagerListener(new ContentManagerListener(onSelection){
            final /* synthetic */ Function1<Content, Unit> $onSelection;
            {
                this.$onSelection = $onSelection;
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    Content content = event.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)content, (String)"event.content");
                    this.$onSelection.invoke((Object)content);
                }
            }
        });
    }

    private static final void refreshListOnToolwindowShow(ToolWindow toolwindow, Function1<? super Content, Unit> onSelection) {
        MessageBus messageBus = toolwindow.getProject().getMessageBus();
        ContentManager contentManager = toolwindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolwindow.contentManager");
        MessageBusConnection bus = messageBus.connect((Disposable)contentManager);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        bus.subscribe(topic, (Object)new ToolWindowManagerListener(toolwindow, onSelection){
            final /* synthetic */ ToolWindow $toolwindow;
            final /* synthetic */ Function1<Content, Unit> $onSelection;
            {
                this.$toolwindow = $toolwindow;
                this.$onSelection = $onSelection;
            }

            public void toolWindowShown(@NotNull ToolWindow shownToolwindow) {
                Content selectedContent;
                Intrinsics.checkNotNullParameter((Object)shownToolwindow, (String)"shownToolwindow");
                if (Intrinsics.areEqual((Object)shownToolwindow.getId(), (Object)this.$toolwindow.getId()) && (selectedContent = shownToolwindow.getContentManager().getSelectedContent()) != null) {
                    this.$onSelection.invoke((Object)selectedContent);
                }
            }
        });
    }
}

