/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import java.net.ConnectException;
import java.nio.channels.UnresolvedAddressException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/collaboration/ui/ExceptionUtil;", "", "()V", "getPresentableMessage", "", "Lorg/jetbrains/annotations/Nls;", "exception", "", "intellij.platform.collaborationTools"})
public final class ExceptionUtil {
    @NotNull
    public static final ExceptionUtil INSTANCE = new ExceptionUtil();

    private ExceptionUtil() {
    }

    @NotNull
    public final String getPresentableMessage(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception.getLocalizedMessage() != null) {
            String string2 = exception.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"exception.localizedMessage");
            return string2;
        }
        if (exception instanceof ConnectException) {
            if (exception.getCause() instanceof UnresolvedAddressException) {
                String string3 = CollaborationToolsBundle.message("error.address.unresolved", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"error.address.unresolved\")");
                return string3;
            }
            String string4 = CollaborationToolsBundle.message("error.connection.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"error.connection.error\")");
            return string4;
        }
        String string5 = CollaborationToolsBundle.message("error.unknown", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"error.unknown\")");
        return string5;
    }
}

