/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.httpclient.response;

import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0011B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/collaboration/api/httpclient/response/CancellableWrappingBodyHandler;", "T", "Ljava/net/http/HttpResponse$BodyHandler;", "handler", "(Ljava/net/http/HttpResponse$BodyHandler;)V", "cancelled", "", "currentSubscription", "Ljava/util/concurrent/Flow$Subscription;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "apply", "Ljava/net/http/HttpResponse$BodySubscriber;", "responseInfo", "Ljava/net/http/HttpResponse$ResponseInfo;", "cancel", "", "SubscriberWrapper", "intellij.platform.collaborationTools"})
public final class CancellableWrappingBodyHandler<T>
implements HttpResponse.BodyHandler<T> {
    @NotNull
    private final HttpResponse.BodyHandler<T> handler;
    private volatile boolean cancelled;
    @Nullable
    private volatile Flow.Subscription currentSubscription;
    @NotNull
    private final ReentrantLock lock;

    public CancellableWrappingBodyHandler(@NotNull HttpResponse.BodyHandler<T> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.handler = handler2;
        this.lock = new ReentrantLock();
    }

    @Override
    @NotNull
    public HttpResponse.BodySubscriber<T> apply(@NotNull HttpResponse.ResponseInfo responseInfo) {
        Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"responseInfo");
        HttpResponse.BodySubscriber<T> bodySubscriber = this.handler.apply(responseInfo);
        Intrinsics.checkNotNullExpressionValue(bodySubscriber, (String)"handler.apply(responseInfo)");
        return new SubscriberWrapper<T>(bodySubscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            this.cancelled = true;
            Flow.Subscription subscription = this.currentSubscription;
            if (subscription != null) {
                subscription.cancel();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00018\u00018\u0001 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00018\u00018\u0001\u0018\u00010\u00060\u0006H\u0096\u0001J\t\u0010\b\u001a\u00020\tH\u0096\u0001J\u0019\u0010\n\u001a\u00020\t2\u000e\u0010\u000b\u001a\n \u0007*\u0004\u0018\u00010\f0\fH\u0096\u0001J5\u0010\r\u001a\u00020\t2*\u0010\u000b\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000f0\u000f \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00100\u000eH\u0096\u0001J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/collaboration/api/httpclient/response/CancellableWrappingBodyHandler$SubscriberWrapper;", "O", "Ljava/net/http/HttpResponse$BodySubscriber;", "subscriber", "(Lcom/intellij/collaboration/api/httpclient/response/CancellableWrappingBodyHandler;Ljava/net/http/HttpResponse$BodySubscriber;)V", "getBody", "Ljava/util/concurrent/CompletionStage;", "kotlin.jvm.PlatformType", "onComplete", "", "onError", "p0", "", "onNext", "", "Ljava/nio/ByteBuffer;", "", "onSubscribe", "subscription", "Ljava/util/concurrent/Flow$Subscription;", "intellij.platform.collaborationTools"})
    private final class SubscriberWrapper<O>
    implements HttpResponse.BodySubscriber<O> {
        @NotNull
        private final HttpResponse.BodySubscriber<O> subscriber;

        public SubscriberWrapper(HttpResponse.BodySubscriber<O> subscriber2) {
            Intrinsics.checkNotNullParameter(subscriber2, (String)"subscriber");
            this.subscriber = subscriber2;
        }

        @Override
        public CompletionStage<O> getBody() {
            return this.subscriber.getBody();
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }

        @Override
        public void onError(Throwable p0) {
            this.subscriber.onError(p0);
        }

        @Override
        public void onNext(List<ByteBuffer> p0) {
            this.subscriber.onNext(p0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribe(@NotNull Flow.Subscription subscription) {
            Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
            this.subscriber.onSubscribe(subscription);
            Lock lock = CancellableWrappingBodyHandler.this.lock;
            CancellableWrappingBodyHandler cancellableWrappingBodyHandler = CancellableWrappingBodyHandler.this;
            lock.lock();
            try {
                boolean bl = false;
                if (cancellableWrappingBodyHandler.cancelled) {
                    subscription.cancel();
                }
                cancellableWrappingBodyHandler.currentSubscription = subscription;
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

