/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hints.InlayHintsPassFactory;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsProviderExtension;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.ProviderInfo;
import com.intellij.codeInsight.hints.VcsCodeAuthorInlayHintsProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationsPreloader;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.ApplicationKt;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.CacheableAnnotationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\b\u0010\f\u001a\u00020\rH\u0002\u001a\b\u0010\u000e\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\b\u0010\u0011\u001a\u00020\rH\u0000\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"VCS_CODE_AUTHOR_ANNOTATION", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/vcs/annotate/FileAnnotation;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getAnnotation", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isCodeAuthorEnabledForApplication", "", "isCodeAuthorEnabledInSettings", "language", "Lcom/intellij/lang/Language;", "isCodeAuthorInlayHintsEnabled", "refreshCodeAuthorInlayHints", "", "registerAnnotation", "annotation", "unregisterAnnotation", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsCodeAuthorInlayHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsCodeAuthorInlayHintsProvider.kt\ncom/intellij/codeInsight/hints/VcsCodeAuthorInlayHintsProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,155:1\n766#2:156\n857#2,2:157\n1747#2,3:159\n1747#2,3:162\n766#2:165\n857#2,2:166\n1#3:168\n29#4,3:169\n*S KotlinDebug\n*F\n+ 1 VcsCodeAuthorInlayHintsProvider.kt\ncom/intellij/codeInsight/hints/VcsCodeAuthorInlayHintsProviderKt\n*L\n37#1:156\n37#1:157,2\n38#1:159,3\n41#1:162,3\n55#1:165\n55#1:166,2\n139#1:169,3\n*E\n"})
public final class VcsCodeAuthorInlayHintsProviderKt {
    @NotNull
    private static final Key<FileAnnotation> VCS_CODE_AUTHOR_ANNOTATION;

    private static final boolean isCodeAuthorEnabledForApplication() {
        return !ApplicationKt.getApplication().isUnitTestMode() && Registry.is((String)"vcs.code.author.inlay.hints");
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isCodeAuthorEnabledInSettings() {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = InlayHintsProviderExtension.INSTANCE.findProviders();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProviderInfo it = (ProviderInfo)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getProvider().getKey(), VcsCodeAuthorInlayHintsProvider.Companion.getKEY$intellij_platform_vcs_impl())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ProviderInfo it = (ProviderInfo)element$iv;
                    boolean bl3 = false;
                    if (!InlayHintsSettings.Companion.instance().hintsShouldBeShown(it.getProvider().getKey(), it.getLanguage())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isCodeAuthorEnabledInSettings(Language language) {
        boolean bl;
        block3: {
            List list = InlayHintsProviderExtension.INSTANCE.allForLanguage(language);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"InlayHintsProviderExtens\u2026.allForLanguage(language)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InlayHintsProvider it = (InlayHintsProvider)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getKey(), VcsCodeAuthorInlayHintsProvider.Companion.getKEY$intellij_platform_vcs_impl())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean hasProviderForLanguage = bl;
        return hasProviderForLanguage && InlayHintsSettings.Companion.instance().hintsShouldBeShown(VcsCodeAuthorInlayHintsProvider.Companion.getKEY$intellij_platform_vcs_impl(), language);
    }

    public static final boolean isCodeAuthorInlayHintsEnabled() {
        return VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledForApplication() && VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledInSettings();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static final void refreshCodeAuthorInlayHints(@NotNull Project project2, @NotNull VirtualFile file) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledForApplication()) {
            return;
        }
        PsiFile psiFile2 = PsiManagerEx.getInstanceEx((Project)project2).getFileManager().getCachedPsiFile(file);
        if (psiFile2 != null) {
            Language language = psiFile2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"psiFile.language");
            if (!VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledInSettings(language)) {
                return;
            }
        }
        List<Editor> list = VcsAnnotateUtil.getEditors(project2, file);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getEditors(project, file)");
        List<Editor> editors = list;
        Iterable $this$filter$iv = editors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Editor it = (Editor)element$iv$iv;
            boolean bl = false;
            if (!(it.getUserData(VCS_CODE_AUTHOR_ANNOTATION) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List noCodeAuthorEditors = (List)destination$iv$iv;
        if (noCodeAuthorEditors.isEmpty()) {
            return;
        }
        for (Editor editor : noCodeAuthorEditors) {
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor");
            InlayHintsPassFactory.Companion.clearModificationStamp(editor);
        }
        if (psiFile2 != null) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart(psiFile2);
        }
    }

    private static final FileAnnotation getAnnotation(Project project2, VirtualFile file, Editor editor) {
        FileAnnotation fileAnnotation = (FileAnnotation)editor.getUserData(VCS_CODE_AUTHOR_ANNOTATION);
        if (fileAnnotation != null) {
            FileAnnotation it = fileAnnotation;
            boolean bl = false;
            return it;
        }
        AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance(project2).getVcsFor(file);
        if (abstractVcs == null) {
            return null;
        }
        AbstractVcs vcs = abstractVcs;
        AnnotationProvider bl = vcs.getAnnotationProvider();
        CacheableAnnotationProvider cacheableAnnotationProvider = bl instanceof CacheableAnnotationProvider ? (CacheableAnnotationProvider)((Object)bl) : null;
        if (cacheableAnnotationProvider == null) {
            return null;
        }
        CacheableAnnotationProvider provider = cacheableAnnotationProvider;
        FileAnnotation fileAnnotation2 = provider.getFromCache(file);
        if (fileAnnotation2 == null) {
            return null;
        }
        FileAnnotation annotation = fileAnnotation2;
        Disposable annotationDisposable = () -> VcsCodeAuthorInlayHintsProviderKt.getAnnotation$lambda$5(annotation);
        annotation.setCloser(() -> VcsCodeAuthorInlayHintsProviderKt.getAnnotation$lambda$6(editor, annotationDisposable, project2, file));
        annotation.setReloader((Consumer<? super FileAnnotation>)((Consumer)arg_0 -> VcsCodeAuthorInlayHintsProviderKt.getAnnotation$lambda$7((Function1)new Function1<FileAnnotation, Unit>(annotation){
            final /* synthetic */ FileAnnotation $annotation;
            {
                this.$annotation = $annotation;
                super(1);
            }

            public final void invoke(FileAnnotation it) {
                this.$annotation.close();
            }
        }, arg_0)));
        editor.putUserData(VCS_CODE_AUTHOR_ANNOTATION, (Object)annotation);
        VcsCodeAuthorInlayHintsProviderKt.registerAnnotation(annotation);
        EditorUtil.disposeWithEditor((Editor)editor, (Disposable)annotationDisposable);
        return annotation;
    }

    private static final void registerAnnotation(FileAnnotation annotation) {
        ProjectLevelVcsManager.getInstance(annotation.getProject()).getAnnotationLocalChangesListener().registerAnnotation(annotation);
    }

    private static final void unregisterAnnotation(FileAnnotation annotation) {
        ProjectLevelVcsManager.getInstance(annotation.getProject()).getAnnotationLocalChangesListener().unregisterAnnotation(annotation);
    }

    private static final void getAnnotation$lambda$5(FileAnnotation $annotation) {
        Intrinsics.checkNotNullParameter((Object)$annotation, (String)"$annotation");
        VcsCodeAuthorInlayHintsProviderKt.unregisterAnnotation($annotation);
        $annotation.dispose();
    }

    private static final void getAnnotation$lambda$6(Editor $editor, Disposable $annotationDisposable, Project $project, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$annotationDisposable, (String)"$annotationDisposable");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        $editor.putUserData(VCS_CODE_AUTHOR_ANNOTATION, null);
        Disposer.dispose((Disposable)$annotationDisposable);
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<AnnotationsPreloader> serviceClass$iv = AnnotationsPreloader.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ((AnnotationsPreloader)object).schedulePreloading($file);
    }

    private static final void getAnnotation$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isCodeAuthorEnabledForApplication() {
        return VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledForApplication();
    }

    public static final /* synthetic */ FileAnnotation access$getAnnotation(Project project2, VirtualFile file, Editor editor) {
        return VcsCodeAuthorInlayHintsProviderKt.getAnnotation(project2, file, editor);
    }

    static {
        Key key2 = Key.create((String)"Vcs.CodeAuthor.Annotation");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create<FileAnnotation>(\"\u2026s.CodeAuthor.Annotation\")");
        VCS_CODE_AUTHOR_ANNOTATION = key2;
    }
}

