/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp.money;

import ai.grazie.utils.mpp.money.Currency;
import ai.grazie.utils.mpp.number.FixedPrecisionFloat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\fH\u00d6\u0001J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fH\u0086\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lai/grazie/utils/mpp/money/Money;", "", "amount", "Lai/grazie/utils/mpp/number/FixedPrecisionFloat;", "currency", "Lai/grazie/utils/mpp/money/Currency;", "(Lai/grazie/utils/mpp/number/FixedPrecisionFloat;Lai/grazie/utils/mpp/money/Currency;)V", "getAmount", "()Lai/grazie/utils/mpp/number/FixedPrecisionFloat;", "getCurrency", "()Lai/grazie/utils/mpp/money/Currency;", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "hashCode", "minus", "plus", "times", "toString", "", "toStringFraction", "toStringInteger", "Companion", "utils-common"})
@SourceDebugExtension(value={"SMAP\nMoney.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Money.kt\nai/grazie/utils/mpp/money/Money\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class Money {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FixedPrecisionFloat amount;
    @NotNull
    private final Currency currency;
    @NotNull
    private static final Money ZERO_DOLLARS = Companion.dollar(FixedPrecisionFloat.Companion.getZERO());

    public Money(@NotNull FixedPrecisionFloat amount, @NotNull Currency currency) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)currency), (String)"currency");
        this.amount = amount;
        this.currency = currency;
    }

    @NotNull
    public final FixedPrecisionFloat getAmount() {
        return this.amount;
    }

    @NotNull
    public final Currency getCurrency() {
        return this.currency;
    }

    @NotNull
    public final Money plus(@NotNull Money other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.currency == other.currency)) {
            boolean bl = false;
            String string2 = "Currencies must be the same";
            throw new IllegalArgumentException(string2.toString());
        }
        return new Money(this.amount.plus(other.amount), this.currency);
    }

    @NotNull
    public final Money minus(@NotNull Money other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.currency == other.currency)) {
            boolean bl = false;
            String string2 = "Currencies must be the same";
            throw new IllegalArgumentException(string2.toString());
        }
        return new Money(this.amount.minus(other.amount), this.currency);
    }

    @NotNull
    public final Money times(int other) {
        return new Money(this.amount.times(other), this.currency);
    }

    public final int compareTo(@NotNull Money other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.currency == other.currency)) {
            boolean bl = false;
            String string2 = "Currencies must be the same";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.amount.compareTo(other.amount);
    }

    @NotNull
    public String toString() {
        return this.currency.getSymbol() + " " + this.amount;
    }

    @NotNull
    public final String toStringInteger() {
        return this.amount.toStringInteger();
    }

    @NotNull
    public final String toStringFraction() {
        return this.amount.toStringFraction();
    }

    @NotNull
    public final FixedPrecisionFloat component1() {
        return this.amount;
    }

    @NotNull
    public final Currency component2() {
        return this.currency;
    }

    @NotNull
    public final Money copy(@NotNull FixedPrecisionFloat amount, @NotNull Currency currency) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)currency), (String)"currency");
        return new Money(amount, currency);
    }

    public static /* synthetic */ Money copy$default(Money money, FixedPrecisionFloat fixedPrecisionFloat, Currency currency, int n, Object object) {
        if ((n & 1) != 0) {
            fixedPrecisionFloat = money.amount;
        }
        if ((n & 2) != 0) {
            currency = money.currency;
        }
        return money.copy(fixedPrecisionFloat, currency);
    }

    public int hashCode() {
        int result2 = this.amount.hashCode();
        result2 = result2 * 31 + this.currency.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Money)) {
            return false;
        }
        Money money = (Money)other;
        if (!Intrinsics.areEqual((Object)this.amount, (Object)money.amount)) {
            return false;
        }
        return this.currency == money.currency;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lai/grazie/utils/mpp/money/Money$Companion;", "", "()V", "ZERO_DOLLARS", "Lai/grazie/utils/mpp/money/Money;", "getZERO_DOLLARS", "()Lai/grazie/utils/mpp/money/Money;", "dollar", "amount", "Lai/grazie/utils/mpp/number/FixedPrecisionFloat;", "utils-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Money dollar(@NotNull FixedPrecisionFloat amount) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            return new Money(amount, Currency.USD);
        }

        @NotNull
        public final Money getZERO_DOLLARS() {
            return ZERO_DOLLARS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

