/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp;

import ai.grazie.utils.mpp.DataLoader;
import ai.grazie.utils.mpp.PlatformKt;
import ai.grazie.utils.mpp.Resources;
import ai.grazie.utils.mpp.RootStreamDataLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0019\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lai/grazie/utils/mpp/FromServerResourcesDataLoader;", "Lai/grazie/utils/mpp/RootStreamDataLoader;", "()V", "absolute", "Lai/grazie/utils/mpp/DataLoader$Path;", "path", "bytes", "", "(Lai/grazie/utils/mpp/DataLoader$Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stream", "Ljava/io/InputStream;", "text", "", "utils-common"})
public final class FromServerResourcesDataLoader
implements RootStreamDataLoader {
    @NotNull
    public static final FromServerResourcesDataLoader INSTANCE = new FromServerResourcesDataLoader();

    private FromServerResourcesDataLoader() {
    }

    @Override
    @NotNull
    public InputStream stream(@NotNull DataLoader.Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        InputStream inputStream = Resources.INSTANCE.streamOrNull(path2.toAbsolutePath());
        if (inputStream == null) {
            inputStream = new FileInputStream(new File(this.absolute(path2).toAbsolutePath()));
        }
        return inputStream;
    }

    @Override
    @Nullable
    public Object bytes(@NotNull DataLoader.Path path2, @NotNull Continuation<? super byte[]> $completion) {
        byte[] byArray = Resources.INSTANCE.bytesOrNull(path2.toAbsolutePath());
        if (byArray == null) {
            byArray = FilesKt.readBytes((File)new File(this.absolute(path2).toAbsolutePath()));
        }
        return byArray;
    }

    @Override
    @Nullable
    public Object text(@NotNull DataLoader.Path path2, @NotNull Continuation<? super String> $completion) {
        String string2 = Resources.INSTANCE.textOrNull(path2.toAbsolutePath());
        if (string2 == null) {
            string2 = FilesKt.readText$default((File)new File(this.absolute(path2).toAbsolutePath()), null, (int)1, null);
        }
        return string2;
    }

    @Override
    @NotNull
    public DataLoader.Path absolute(@NotNull DataLoader.Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        DataLoader.Path server = new DataLoader.Path("/server/lib", path2);
        if (new File(server.toAbsolutePath()).exists()) {
            return server;
        }
        DataLoader.Path test = new DataLoader.Path("build/processedResources/" + PlatformKt.forPlatform("js", "jvm") + "/main", path2);
        if (new File(test.toRelativePath()).exists()) {
            String string2 = new File(test.toRelativePath()).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"File(test.toRelativePath()).absolutePath");
            return new DataLoader.Path(string2);
        }
        throw new IllegalStateException(("Can't find " + path2.toAbsolutePath() + " in test resources or in server/lib directory").toString());
    }
}

