/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.templates;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.completion.ml.templates.LiveTemplateUsageTracker;
import com.intellij.completion.ml.util.LookupElementExtensionsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/templates/LiveTemplateUsageFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "intellij.completionMlRanking"})
public final class LiveTemplateUsageFeatureProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "template";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
        Map result = new LinkedHashMap();
        if (LookupElementExtensionsKt.isLiveTemplate(element)) {
            LiveTemplateUsageTracker liveTemplateUsageTracker = LiveTemplateUsageTracker.Companion.getInstance();
            String string = element.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.lookupString");
            Integer it = liveTemplateUsageTracker.getRecentUseCount(string);
            boolean bl = false;
            result.put("previously_used", MLFeatureValue.Companion.binary(it != null));
            Integer n = it;
            result.put("recent_use_count", MLFeatureValue.Companion.float(n != null ? n : 0));
        }
        return result;
    }
}

