/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.completion.ml.ranker.ExperimentModelProvider;
import com.intellij.completion.ml.ranker.local.MLCompletionLocalModelsLoader;
import com.intellij.completion.ml.settings.CompletionMLRankingSettings;
import com.intellij.completion.ml.sorting.LanguageRankingModel;
import com.intellij.completion.ml.sorting.RankingModelWrapper;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.completion.DecoratingItemsPolicy;
import com.intellij.internal.ml.completion.RankingModelProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/completion/ml/sorting/RankingSupport;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "enabledInTests", "", "localDebugModelLoader", "Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsLoader;", "availableRankers", "", "Lcom/intellij/internal/ml/completion/RankingModelProvider;", "enableInTests", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "findProviderSafe", "language", "Lcom/intellij/lang/Language;", "getRankingModel", "Lcom/intellij/completion/ml/sorting/RankingModelWrapper;", "shouldSortByML", "provider", "tryGetModel", "tryLoadLocalDebugModel", "Lcom/intellij/completion/ml/sorting/LanguageRankingModel;", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nRankingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RankingSupport.kt\ncom/intellij/completion/ml/sorting/RankingSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n1#2:91\n766#3:92\n857#3:93\n1747#3,3:94\n858#3:97\n10#4:98\n*S KotlinDebug\n*F\n+ 1 RankingSupport.kt\ncom/intellij/completion/ml/sorting/RankingSupport\n*L\n34#1:92\n34#1:93\n35#1:94,3\n34#1:97\n19#1:98\n*E\n"})
public final class RankingSupport {
    @NotNull
    public static final RankingSupport INSTANCE = new RankingSupport();
    @NotNull
    private static final Logger LOG;
    private static boolean enabledInTests;
    @NotNull
    private static final MLCompletionLocalModelsLoader localDebugModelLoader;

    private RankingSupport() {
    }

    @Nullable
    public final RankingModelWrapper getRankingModel(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        LanguageRankingModel languageRankingModel = this.tryLoadLocalDebugModel(language);
        if (languageRankingModel != null) {
            LanguageRankingModel it = languageRankingModel;
            boolean bl = false;
            return it;
        }
        RankingModelProvider provider = this.findProviderSafe(language);
        return provider != null && this.shouldSortByML(language, provider) ? this.tryGetModel(provider) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RankingModelProvider> availableRankers() {
        void $this$filterTo$iv$iv;
        Collection collection = Language.getRegisteredLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages()");
        Collection registeredLanguages = collection;
        ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
        Iterable $this$filter$iv = ExperimentModelProvider.Companion.availableProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                RankingModelProvider provider = (RankingModelProvider)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = registeredLanguages;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Language it = (Language)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!ExperimentModelProvider.Companion.match(provider, it, experimentStatus.forLanguage(it).getVersion())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final RankingModelProvider findProviderSafe(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        ExperimentInfo experimentInfo = ExperimentStatus.Companion.getInstance().forLanguage(language);
        try {
            return ExperimentModelProvider.Companion.findProvider(language, experimentInfo.getVersion());
        }
        catch (IllegalStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private final RankingModelWrapper tryGetModel(RankingModelProvider provider) {
        try {
            DecisionFunction decisionFunction = provider.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)decisionFunction, (String)"provider.model");
            DecoratingItemsPolicy decoratingItemsPolicy = provider.getDecoratingPolicy();
            Intrinsics.checkNotNullExpressionValue((Object)decoratingItemsPolicy, (String)"provider.decoratingPolicy");
            return new LanguageRankingModel(decisionFunction, decoratingItemsPolicy);
        }
        catch (Exception e) {
            LOG.error("Could not create ranking model with id '" + provider.getId() + "' and name '" + provider.getDisplayNameInSettings() + "'", (Throwable)e);
            return null;
        }
    }

    private final boolean shouldSortByML(Language language, RankingModelProvider provider) {
        boolean shouldSort;
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return enabledInTests;
        }
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"getInstance()");
        CompletionMLRankingSettings settings = completionMLRankingSettings;
        ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
        ExperimentInfo experimentInfo = experimentStatus.forLanguage(language);
        boolean bl = shouldSort = settings.isRankingEnabled() && settings.isLanguageEnabled(provider.getId());
        if (application.isEAP() && experimentInfo.getInExperiment() && !experimentStatus.isDisabled()) {
            settings.updateShowDiffInExperiment(experimentInfo.getShouldShowArrows());
        }
        return shouldSort;
    }

    private final LanguageRankingModel tryLoadLocalDebugModel(Language language) {
        String string = language.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.id");
        DecisionFunction decisionFunction = localDebugModelLoader.getModel(string);
        if (decisionFunction != null) {
            DecisionFunction it = decisionFunction;
            boolean bl = false;
            return new LanguageRankingModel(it, DecoratingItemsPolicy.Companion.getDISABLED());
        }
        return null;
    }

    @TestOnly
    public final void enableInTests(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        enabledInTests = true;
        Disposer.register((Disposable)parentDisposable, RankingSupport::enableInTests$lambda$4);
    }

    private static final void enableInTests$lambda$4() {
        enabledInTests = false;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RankingSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        localDebugModelLoader = new MLCompletionLocalModelsLoader("completion.ml.path.to.zip.model");
    }
}

