/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.RepresentableAsByteArraySequence;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class UnsyncByteArrayOutputStream
extends OutputStream
implements RepresentableAsByteArraySequence {
    protected byte[] myBuffer;
    protected int myCount;
    private boolean myIsShared;
    @NotNull
    private final ByteArrayAllocator myAllocator;

    public UnsyncByteArrayOutputStream() {
        this(32);
    }

    public UnsyncByteArrayOutputStream(int size) {
        this(ArrayUtil.newByteArray(size));
    }

    public UnsyncByteArrayOutputStream(byte @NotNull [] buffer) {
        if (buffer == null) {
            UnsyncByteArrayOutputStream.$$$reportNull$$$0(0);
        }
        this.myAllocator = size -> ArrayUtil.newByteArray(size);
        this.myBuffer = buffer;
    }

    public UnsyncByteArrayOutputStream(@NotNull ByteArrayAllocator allocator, int initialSize) {
        if (allocator == null) {
            UnsyncByteArrayOutputStream.$$$reportNull$$$0(1);
        }
        this.myAllocator = allocator;
        this.myBuffer = allocator.allocate(initialSize);
    }

    @Override
    public void write(int b) {
        int newCount = this.myCount + 1;
        if (newCount > this.myBuffer.length || this.myIsShared) {
            this.grow(newCount);
            this.myIsShared = false;
        }
        this.myBuffer[this.myCount] = (byte)b;
        this.myCount = newCount;
    }

    private void grow(int newCount) {
        int newLength = newCount > this.myBuffer.length ? Math.max(this.myBuffer.length << 1, newCount) : this.myBuffer.length;
        byte[] newBuffer = this.myAllocator.allocate(newLength);
        System.arraycopy(this.myBuffer, 0, newBuffer, 0, this.myBuffer.length);
        this.myBuffer = newBuffer;
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) {
        if (b == null) {
            UnsyncByteArrayOutputStream.$$$reportNull$$$0(2);
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newCount = this.myCount + len;
        if (newCount > this.myBuffer.length || this.myIsShared) {
            this.grow(newCount);
            this.myIsShared = false;
        }
        System.arraycopy(b, off, this.myBuffer, this.myCount, len);
        this.myCount = newCount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.myBuffer, 0, this.myCount);
    }

    public void reset() {
        this.myCount = 0;
    }

    public byte @NotNull [] toNewByteArray() {
        byte[] byArray = Arrays.copyOf(this.myBuffer, this.myCount);
        if (byArray == null) {
            UnsyncByteArrayOutputStream.$$$reportNull$$$0(3);
        }
        return byArray;
    }

    public byte @NotNull [] toByteArray() {
        if (this.myBuffer.length == this.myCount) {
            this.myIsShared = true;
            if (this.myBuffer == null) {
                UnsyncByteArrayOutputStream.$$$reportNull$$$0(4);
            }
            return this.myBuffer;
        }
        byte[] byArray = this.toNewByteArray();
        if (byArray == null) {
            UnsyncByteArrayOutputStream.$$$reportNull$$$0(5);
        }
        return byArray;
    }

    public int size() {
        return this.myCount;
    }

    public String toString() {
        return new String(this.myBuffer, 0, this.myCount, StandardCharsets.UTF_8);
    }

    @NotNull
    public ByteArraySequence toByteArraySequence() {
        return this.myCount == 0 ? ByteArraySequence.EMPTY : new ByteArraySequence(this.myBuffer, 0, this.myCount);
    }

    @NotNull
    public InputStream toInputStream() {
        return new UnsyncByteArrayInputStream(this.myBuffer, 0, this.myCount);
    }

    @Override
    @NotNull
    public ByteArraySequence asByteArraySequence() {
        ByteArraySequence byteArraySequence = this.toByteArraySequence();
        if (byteArraySequence == null) {
            UnsyncByteArrayOutputStream.$$$reportNull$$$0(6);
        }
        return byteArraySequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/UnsyncByteArrayOutputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/UnsyncByteArrayOutputStream";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toNewByteArray";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toByteArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asByteArraySequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ByteArrayAllocator {
        public byte[] allocate(int var1);
    }
}

