/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SmartList;
import com.intellij.util.text.CharSequenceBackedByChars;
import java.io.Closeable;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"decodeBase64", "", "", "encodeUrlQueryParameter", "readCharSequence", "", "Ljava/io/Reader;", "length", "", "toByteArray", "Ljava/nio/ByteBuffer;", "isClear", "", "intellij.platform.util"})
public final class IoKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CharSequence readCharSequence(@NotNull Reader $this$readCharSequence, int length) {
        Intrinsics.checkNotNullParameter($this$readCharSequence, "<this>");
        Closeable closeable = $this$readCharSequence;
        Throwable throwable = null;
        try {
            int count2;
            int n;
            Reader it = (Reader)closeable;
            boolean bl = false;
            char[] chars = new char[length];
            for (count2 = 0; count2 < chars.length && (n = $this$readCharSequence.read(chars, count2, chars.length - count2)) > 0; count2 += n) {
            }
            CharSequence charSequence = new CharSequenceBackedByChars(chars, 0, count2);
            return charSequence;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @NotNull
    public static final CharSequence readCharSequence(@NotNull Reader $this$readCharSequence) {
        int n;
        Intrinsics.checkNotNullParameter($this$readCharSequence, "<this>");
        char[] chars = new char[8192];
        List buffers = null;
        int count2 = 0;
        int total = 0;
        while ((n = $this$readCharSequence.read(chars, count2, chars.length - count2)) > 0) {
            total += n;
            if ((count2 += n) != chars.length) continue;
            if (buffers == null) {
                buffers = new SmartList();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count2 = 0;
        }
        if (buffers == null) {
            return new CharSequenceBackedByChars(chars, 0, total);
        }
        char[] result2 = new char[total];
        for (char[] buffer : buffers) {
            System.arraycopy(buffer, 0, result2, result2.length - total, buffer.length);
            total -= buffer.length;
        }
        System.arraycopy(chars, 0, result2, result2.length - total, total);
        return new CharSequenceBackedByChars(result2);
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull ByteBuffer $this$toByteArray, boolean isClear) {
        Intrinsics.checkNotNullParameter($this$toByteArray, "<this>");
        if ($this$toByteArray.hasArray()) {
            int offset = $this$toByteArray.arrayOffset();
            byte[] array = $this$toByteArray.array();
            if (offset == 0 && array.length == $this$toByteArray.limit()) {
                Intrinsics.checkNotNullExpressionValue(array, "array");
                return array;
            }
            Intrinsics.checkNotNullExpressionValue(array, "array");
            byte[] byArray = array;
            int n = offset + $this$toByteArray.limit();
            byte[] result2 = ArraysKt.copyOfRange(byArray, offset, n);
            if (isClear) {
                ArraysKt.fill$default(array, (byte)0, 0, 0, 6, null);
            }
            return result2;
        }
        byte[] bytes = new byte[$this$toByteArray.limit() - $this$toByteArray.position()];
        $this$toByteArray.get(bytes);
        return bytes;
    }

    public static /* synthetic */ byte[] toByteArray$default(ByteBuffer byteBuffer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return IoKt.toByteArray(byteBuffer, bl);
    }

    @NotNull
    public static final String encodeUrlQueryParameter(@NotNull String $this$encodeUrlQueryParameter) {
        Intrinsics.checkNotNullParameter($this$encodeUrlQueryParameter, "<this>");
        String string2 = URLEncoder.encode($this$encodeUrlQueryParameter, Charsets.UTF_8.name());
        Intrinsics.checkNotNull(string2);
        return string2;
    }

    @NotNull
    public static final byte[] decodeBase64(@NotNull String $this$decodeBase64) {
        Intrinsics.checkNotNullParameter($this$decodeBase64, "<this>");
        byte[] byArray = Base64.getDecoder().decode($this$decodeBase64);
        Intrinsics.checkNotNullExpressionValue(byArray, "decodeBase64");
        return byArray;
    }
}

