/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.EDT;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SlowOperations {
    private static final Logger LOG = Logger.getInstance(SlowOperations.class);
    public static final String ERROR_MESSAGE = "Slow operations are prohibited on EDT. See SlowOperations.assertSlowOperationsAreAllowed javadoc.";
    public static final String ACTION_UPDATE = "action.update";
    public static final String ACTION_PERFORM = "action.perform";
    public static final String KNOWN_ISSUE = "known-issues";
    public static final String GENERIC = "generic";
    public static final String FORCE_ASSERT = "  force assert  ";
    public static final String FAST_TRACK = "  fast track  ";
    public static final String RESET = "  reset  ";
    public static final String IDEA_PLUGIN_SANDBOX_MODE = "idea.plugin.in.sandbox.mode";
    private static int ourAlwaysAllow = -1;
    @NotNull
    private static @NotNull FList<@NotNull String> ourStack = FList.emptyList();

    private SlowOperations() {
    }

    public static void assertSlowOperationsAreAllowed() {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        if (SlowOperations.isInSection(FAST_TRACK)) {
            if (Cancellation.isInNonCancelableSection()) {
                SlowOperations.reportNonCancellableSectionInFastTrack();
            } else {
                throw new ProcessCanceledException();
            }
        }
        if (SlowOperations.isAlwaysAllowed()) {
            return;
        }
        boolean forceAssert = SlowOperations.isInSection(FORCE_ASSERT);
        if (!forceAssert && !Registry.is("ide.slow.operations.assertion", true)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed() && !Registry.is("ide.slow.operations.assertion.write.action")) {
            return;
        }
        if (ourStack.isEmpty() && !Registry.is("ide.slow.operations.assertion.other", false)) {
            return;
        }
        for (String activity : ourStack) {
            if (RESET.equals(activity)) break;
            if (Registry.is("ide.slow.operations.assertion." + activity, true)) continue;
            return;
        }
        Throwable throwable = new Throwable();
        if (ThrowableInterner.intern(throwable) != throwable) {
            return;
        }
        LOG.error(ERROR_MESSAGE);
    }

    private static void reportNonCancellableSectionInFastTrack() {
        LOG.error("Non-cancellable section in FAST_TRACK");
    }

    @ApiStatus.Internal
    public static boolean isInSection(@NotNull String sectionName) {
        if (sectionName == null) {
            SlowOperations.$$$reportNull$$$0(0);
        }
        EDT.assertIsEdt();
        for (String activity : ourStack) {
            if (RESET.equals(activity)) break;
            if (!sectionName.equals(activity)) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean isAlwaysAllowed() {
        if (ourAlwaysAllow == 1) {
            return true;
        }
        if (ourAlwaysAllow == 0) {
            return false;
        }
        if (!LoadingState.APP_STARTED.isOccurred()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        boolean result2 = System.getenv("TEAMCITY_VERSION") != null || application.isUnitTestMode() || application.isCommandLine() || !application.isEAP() && !application.isInternal() && !SystemProperties.getBooleanProperty(IDEA_PLUGIN_SANDBOX_MODE, false);
        ourAlwaysAllow = result2 ? 1 : 0;
        return result2;
    }

    @Deprecated
    public static <T, E extends Throwable> T allowSlowOperations(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            SlowOperations.$$$reportNull$$$0(1);
        }
        try (AccessToken ignore = SlowOperations.startSection(GENERIC);){
            Object object = computable.compute();
            return (T)object;
        }
    }

    @Deprecated
    public static <E extends Throwable> void allowSlowOperations(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            SlowOperations.$$$reportNull$$$0(2);
        }
        try (AccessToken ignore = SlowOperations.startSection(GENERIC);){
            runnable.run();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static AccessToken knownIssue(@NotNull @NonNls String ytIssueId) {
        if (ytIssueId == null) {
            SlowOperations.$$$reportNull$$$0(3);
        }
        return SlowOperations.startSection(KNOWN_ISSUE);
    }

    @Deprecated
    @NotNull
    public static AccessToken allowSlowOperations(@NotNull @NonNls String activityName) {
        if (activityName == null) {
            SlowOperations.$$$reportNull$$$0(4);
        }
        return SlowOperations.startSection(activityName);
    }

    @ApiStatus.Internal
    @NotNull
    public static AccessToken startSection(@NotNull @NonNls String sectionName) {
        if (sectionName == null) {
            SlowOperations.$$$reportNull$$$0(5);
        }
        if (!EDT.isCurrentThreadEdt()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                SlowOperations.$$$reportNull$$$0(6);
            }
            return accessToken;
        }
        final FList<String> prev = ourStack;
        ourStack = prev.prepend(sectionName);
        return new AccessToken(){

            @Override
            public void finish() {
                ourStack = prev;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ytIssueId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SlowOperations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SlowOperations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startSection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInSection";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "allowSlowOperations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "knownIssue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startSection";
                break;
            }
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

