/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download.permanentToken;

import com.intellij.codeWithMe.ClientId;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenConnectionTestKt;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenEnsureParams;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenWrapper;
import com.intellij.indexing.shared.download.permanentToken.SharedIndexAuthPermanentNotifications;
import com.intellij.indexing.shared.download.permanentToken.TokenStatus;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u0006\u0010 \u001a\u00020\u0017J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenWrapper;", "Lcom/intellij/openapi/Disposable;", "tokenName", "", "urls", "", "(Ljava/lang/String;Ljava/util/Set;)V", "notifications", "Lcom/intellij/indexing/shared/download/permanentToken/SharedIndexAuthPermanentNotifications;", "refreshTokenStore", "Lcom/intellij/credentialStore/CredentialAttributes;", "getRefreshTokenStore", "()Lcom/intellij/credentialStore/CredentialAttributes;", "refreshTokenStore$delegate", "Lkotlin/Lazy;", "tokenCache", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/indexing/shared/download/permanentToken/TokenStatus;", "getTokenName", "()Ljava/lang/String;", "getUrls", "()Ljava/util/Set;", "dispose", "", "ensureToken", "", "request", "Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenEnsureParams;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readToken", "readTokenInternal", "resetToken", "setToken", "password", "intellij.indexing.shared"})
public final class PermanentTokenWrapper
implements Disposable {
    @NotNull
    private final String tokenName;
    @NotNull
    private final Set<String> urls;
    @NotNull
    private final SharedIndexAuthPermanentNotifications notifications;
    @NotNull
    private final AtomicReference<TokenStatus> tokenCache;
    @NotNull
    private final Lazy refreshTokenStore$delegate;

    public PermanentTokenWrapper(@NotNull String tokenName, @NotNull Set<String> urls) {
        Intrinsics.checkNotNullParameter((Object)tokenName, (String)"tokenName");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        this.tokenName = tokenName;
        this.urls = urls;
        this.notifications = new SharedIndexAuthPermanentNotifications(this);
        this.tokenCache = new AtomicReference<Object>(null);
        Disposer.register((Disposable)this, (Disposable)this.notifications);
        PluginDescriptor pluginDescriptor = PluginManager.getPluginByClass(this.getClass());
        PluginId pluginId = pluginDescriptor != null ? pluginDescriptor.getPluginId() : null;
        DumbAwareAction resetAction2 = new DumbAwareAction(this){
            final /* synthetic */ PermanentTokenWrapper this$0;
            {
                this.this$0 = $receiver;
                this.addSynonym(() -> resetAction.1._init_$lambda$0($receiver));
                this.addSynonym(() -> resetAction.1._init_$lambda$1($receiver));
                Object[] objectArray = new Object[]{$receiver.getTokenName()};
                this.getTemplatePresentation().setText(SharedIndexesBundle.message("action.text.permanent.reset", objectArray));
                objectArray = new Object[]{$receiver.getTokenName(), NlsMessages.formatNarrowAndList((Collection)$receiver.getUrls())};
                this.getTemplatePresentation().setDescription(SharedIndexesBundle.message("action.description.permanent.reset", objectArray));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.resetToken();
                    PermanentTokenWrapper.access$getNotifications$p(this.this$0).ensureNotificationPossible();
                    Project project = e.getProject();
                    if (project == null) break block1;
                    Project it = project;
                    boolean bl = false;
                    boolean $i$f$service = false;
                    Class<SharedIndexDownloadService> serviceClass$iv = SharedIndexDownloadService.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                    }
                    ((SharedIndexDownloadService)object).rescanNow(it);
                }
            }

            private static final String _init_$lambda$0(PermanentTokenWrapper this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Object[] objectArray = new Object[]{this$0.getTokenName()};
                return SharedIndexesBundle.message("action.text.synonym1.permanent.reset", objectArray);
            }

            private static final String _init_$lambda$1(PermanentTokenWrapper this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Object[] objectArray = new Object[]{this$0.getTokenName()};
                return SharedIndexesBundle.message("action.text.synonym2.permanent.reset", objectArray);
            }
        };
        String resetActionId = this.getClass().getName() + ":reset-" + DigestUtilKt.hashToHexString((String)this.tokenName, (MessageDigest)DigestUtil.sha256());
        ActionManager.getInstance().registerAction(resetActionId, (AnAction)resetAction2, pluginId);
        Disposer.register((Disposable)this, () -> PermanentTokenWrapper._init_$lambda$0(resetActionId));
        this.refreshTokenStore$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CredentialAttributes>(this){
            final /* synthetic */ PermanentTokenWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CredentialAttributes invoke() {
                return new CredentialAttributes("intellij-shared-indexes-token-" + this.this$0.getTokenName(), null, null, false, 14, null);
            }
        }));
    }

    @NotNull
    public final String getTokenName() {
        return this.tokenName;
    }

    @NotNull
    public final Set<String> getUrls() {
        return this.urls;
    }

    private final CredentialAttributes getRefreshTokenStore() {
        Lazy lazy = this.refreshTokenStore$delegate;
        return (CredentialAttributes)lazy.getValue();
    }

    public void dispose() {
    }

    public final void resetToken() {
        PasswordSafe.Companion.getInstance().set(this.getRefreshTokenStore(), null);
        this.tokenCache.set(TokenStatus.NO_TOKEN.INSTANCE);
    }

    public final void setToken(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Credentials credentials = new Credentials(CollectionsKt.joinToString$default((Iterable)this.urls, null, null, null, (int)0, null, null, (int)63, null), password);
        PasswordSafe.Companion.getInstance().set(this.getRefreshTokenStore(), credentials);
        this.tokenCache.set(new TokenStatus.Token(password));
    }

    @Nullable
    public final String readToken() {
        return this.tokenCache.updateAndGet(arg_0 -> PermanentTokenWrapper.readToken$lambda$1(this, arg_0)).getToken();
    }

    private final TokenStatus readTokenInternal() {
        Credentials credentials;
        Credentials credentials2;
        try {
            credentials2 = PasswordSafe.Companion.getInstance().get(this.getRefreshTokenStore());
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to access PasswordSafe for " + this.getRefreshTokenStore().getServiceName(), t);
            return TokenStatus.FAILED.INSTANCE;
        }
        Object object = credentials = credentials2;
        if (Intrinsics.areEqual((Object)object, (Object)CredentialAttributesKt.getACCESS_TO_KEY_CHAIN_DENIED())) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().info("Failed to access to credentials store for " + this.getRefreshTokenStore().getServiceName() + ". Access denied");
            return TokenStatus.FAILED.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)object, (Object)CredentialAttributesKt.getCANNOT_UNLOCK_KEYCHAIN())) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().info("Failed to access to credentials store " + this.getRefreshTokenStore().getServiceName() + ". Cannot unlock keychain");
            return TokenStatus.FAILED.INSTANCE;
        }
        if (object == null) {
            return TokenStatus.NO_TOKEN.INSTANCE;
        }
        String refreshToken = credentials.getPasswordAsString();
        object = refreshToken;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return TokenStatus.NO_TOKEN.INSTANCE;
        }
        return new TokenStatus.Token(refreshToken);
    }

    public final boolean ensureToken(@NotNull PermanentTokenEnsureParams request, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string = this.readToken();
        if (string != null) {
            String token = string;
            boolean bl = false;
            boolean hasConnection = PermanentTokenConnectionTestKt.testConnection(request, token, true, indicator);
            if (hasConnection) {
                return true;
            }
            this.resetToken();
        }
        if (Disposer.isDisposed((Disposable)request.getLifetime())) {
            return false;
        }
        this.notifications.showNotification(request);
        return false;
    }

    private static final void _init_$lambda$0(String $resetActionId) {
        Intrinsics.checkNotNullParameter((Object)$resetActionId, (String)"$resetActionId");
        ActionManager.getInstance().unregisterAction($resetActionId);
    }

    private static final TokenStatus readToken$lambda$1(PermanentTokenWrapper this$0, TokenStatus cache2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return cache2 == null || cache2 instanceof TokenStatus.FAILED ? this$0.readTokenInternal() : cache2;
    }

    public static final /* synthetic */ SharedIndexAuthPermanentNotifications access$getNotifications$p(PermanentTokenWrapper $this) {
        return $this.notifications;
    }
}

