/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.AccountManager;
import com.intellij.collaboration.auth.ui.AccountsListModel;
import com.intellij.collaboration.auth.ui.AccountsPanelActionsController;
import com.intellij.collaboration.auth.ui.AccountsPanelFactory;
import com.intellij.collaboration.auth.ui.LoadingAccountsDetailsProvider;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ModalTaskOwner;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TasksKt;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.google.GoogleAppCredentialsException;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountManager;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsDetailsProvider;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsListModel;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsPanelActionsController;
import org.intellij.plugins.markdown.google.accounts.GoogleUserInfoService;
import org.intellij.plugins.markdown.google.accounts.data.GoogleAccount;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthRequest;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthRequestKt;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.intellij.plugins.markdown.google.authorization.GoogleRefreshTokenRequest;
import org.intellij.plugins.markdown.google.authorization.GoogleRefreshTokenRequestKt;
import org.intellij.plugins.markdown.google.ui.GoogleChooseAccountDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J\"\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006#"}, d2={"Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "chooseAccount", "Lcom/google/api/client/auth/oauth2/Credential;", "project", "Lcom/intellij/openapi/project/Project;", "createCredentialsForGoogleApi", "credentials", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "createGoogleAccountPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "disposable", "Lcom/intellij/openapi/Disposable;", "accountsListModel", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;", "accountManager", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;", "getGoogleAppCredentials", "Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils$GoogleAppCredentials;", "getOrUpdateUserCredentials", "oAuthService", "Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService;", "account", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "getTokenResponse", "Lcom/google/api/client/auth/oauth2/TokenResponse;", "tryToReLogin", "GoogleAppCredentials", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nGoogleAccountsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleAccountsUtils.kt\norg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,225:1\n43#2,3:226\n43#2,3:229\n43#2,3:236\n43#2,3:239\n43#2,3:242\n15#3,4:232\n10#4:245\n*S KotlinDebug\n*F\n+ 1 GoogleAccountsUtils.kt\norg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils\n*L\n58#1:226,3\n59#1:229,3\n145#1:236,3\n146#1:239,3\n97#1:242,3\n132#1:232,4\n53#1:245\n*E\n"})
public final class GoogleAccountsUtils {
    @NotNull
    public static final GoogleAccountsUtils INSTANCE = new GoogleAccountsUtils();
    @NotNull
    private static final Logger LOG;

    private GoogleAccountsUtils() {
    }

    @NotNull
    public final ObjectMapper getJacksonMapper() {
        return ExtensionsKt.jacksonObjectMapper();
    }

    @RequiresEdt
    @Nullable
    public final Credential chooseAccount(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GoogleAccountsListModel accountsListModel = new GoogleAccountsListModel();
        boolean $i$f$service = false;
        Class<GoogleAccountManager> serviceClass$iv = GoogleAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GoogleAccountManager accountManager = (GoogleAccountManager)((Object)object);
        boolean $i$f$service2 = false;
        Class<GoogleOAuthService> serviceClass$iv2 = GoogleOAuthService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GoogleOAuthService oAuthService = (GoogleOAuthService)((Object)object2);
        if (!new GoogleChooseAccountDialog(project, accountsListModel, accountManager).showAndGet()) {
            return null;
        }
        Map newTokensMap = new LinkedHashMap();
        newTokensMap.putAll(accountsListModel.getNewCredentials());
        for (GoogleAccount account : accountsListModel.getAccounts()) {
            newTokensMap.putIfAbsent(account, null);
        }
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.project((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"project(project)");
        String string = CollaborationToolsBundle.message((String)"accounts.saving.credentials", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"accounts.saving.credentials\")");
        TasksKt.runBlockingModalWithRawProgressReporter$default((ModalTaskOwner)modalTaskOwner, (String)string, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(accountManager, (Map<GoogleAccount, GoogleCredentials>)newTokensMap, null){
            int label;
            final /* synthetic */ GoogleAccountManager $accountManager;
            final /* synthetic */ Map<GoogleAccount, GoogleCredentials> $newTokensMap;
            {
                this.$accountManager = $accountManager;
                this.$newTokensMap = $newTokensMap;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$accountManager.updateAccounts(this.$newTokensMap, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)4, null);
        accountsListModel.clearNewCredentials();
        try {
            GoogleAccount googleAccount = (GoogleAccount)accountsListModel.getSelectedAccount();
            if (googleAccount == null) {
                throw new IllegalStateException("The selected account cannot be null".toString());
            }
            GoogleAccount selectedAccount = googleAccount;
            GoogleCredentials googleCredentials = this.getOrUpdateUserCredentials(oAuthService, accountManager, selectedAccount);
            if (googleCredentials == null && (googleCredentials = this.tryToReLogin(project)) == null) {
                return null;
            }
            GoogleCredentials accountCredentials = googleCredentials;
            object = this.createCredentialsForGoogleApi(accountCredentials);
        }
        catch (TimeoutException e) {
            LOG.debug((Throwable)e);
            object = null;
        }
        catch (IllegalStateException e) {
            LOG.debug((Throwable)e);
            object = null;
        }
        return object;
    }

    @Nullable
    public final GoogleCredentials tryToReLogin(@NotNull Project project) {
        GoogleCredentials googleCredentials;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.ObjectRef credentialsFuture = new Ref.ObjectRef();
        credentialsFuture.element = new CompletableFuture();
        try {
            googleCredentials = (GoogleCredentials)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GoogleAccountsUtils.tryToReLogin$lambda$0(credentialsFuture), MarkdownBundle.message("markdown.google.account.login.progress.title", new Object[0]), true, project);
        }
        catch (Throwable t) {
            ((CompletableFuture)credentialsFuture.element).cancel(true);
            googleCredentials = null;
        }
        return googleCredentials;
    }

    @RequiresEdt
    @Nullable
    public final GoogleCredentials getOrUpdateUserCredentials(@NotNull GoogleOAuthService oAuthService, @NotNull GoogleAccountManager accountManager, @NotNull GoogleAccount account) {
        Intrinsics.checkNotNullParameter((Object)((Object)oAuthService), (String)"oAuthService");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        GoogleCredentials googleCredentials = (GoogleCredentials)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GoogleCredentials>, Object>(accountManager, account, null){
            int label;
            final /* synthetic */ GoogleAccountManager $accountManager;
            final /* synthetic */ GoogleAccount $account;
            {
                this.$accountManager = $accountManager;
                this.$account = $account;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$accountManager.findCredentials(this.$account, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GoogleCredentials> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (googleCredentials != null) {
            GoogleCredentials googleCredentials2;
            GoogleCredentials credentials = googleCredentials;
            boolean bl = false;
            if (credentials.isAccessTokenValid()) {
                return credentials;
            }
            GoogleRefreshTokenRequest refreshRequest = GoogleRefreshTokenRequestKt.getGoogleRefreshRequest(credentials.getRefreshToken());
            CompletableFuture<GoogleCredentials> credentialFuture = oAuthService.updateAccessToken(refreshRequest);
            try {
                googleCredentials2 = (GoogleCredentials)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GoogleAccountsUtils.getOrUpdateUserCredentials$lambda$3$lambda$1(credentialFuture, accountManager, account), MarkdownBundle.message("markdown.google.account.update.credentials.progress.title", new Object[0]), true, null);
            }
            catch (RuntimeException e) {
                Throwable throwable = e.getCause();
                String $this$alsoIfNull$iv = throwable != null && (throwable = throwable.getCause()) != null ? throwable.getLocalizedMessage() : null;
                boolean $i$f$alsoIfNull = false;
                if ($this$alsoIfNull$iv == null) {
                    boolean bl2 = false;
                    e.getLocalizedMessage();
                }
                String message = $this$alsoIfNull$iv;
                LOG.warn("Failed to update user credentials:\n" + message);
                googleCredentials2 = null;
            }
            return googleCredentials2;
        }
        return null;
    }

    @NotNull
    public final DialogPanel createGoogleAccountPanel(@NotNull Disposable disposable, @NotNull GoogleAccountsListModel accountsListModel, @NotNull GoogleAccountManager accountManager) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)((Object)accountsListModel), (String)"accountsListModel");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        boolean $i$f$service = false;
        Class<GoogleOAuthService> serviceClass$iv = GoogleOAuthService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GoogleOAuthService oAuthService = (GoogleOAuthService)((Object)object);
        boolean $i$f$service2 = false;
        Class<GoogleUserInfoService> serviceClass$iv2 = GoogleUserInfoService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        GoogleUserInfoService userInfoService = (GoogleUserInfoService)object2;
        CoroutineScope coroutineScope = CoroutineUtilKt.DisposingMainScope((Disposable)disposable);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any()");
        CoroutineScope scope = CoroutineScopeKt.plus((CoroutineScope)coroutineScope, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState));
        GoogleAccountsDetailsProvider detailsProvider = new GoogleAccountsDetailsProvider(scope, accountManager, accountsListModel, oAuthService, userInfoService);
        AccountsPanelFactory panelFactory = new AccountsPanelFactory(scope, (AccountManager)accountManager, (AccountsListModel)accountsListModel);
        GoogleAccountsPanelActionsController actionsController = new GoogleAccountsPanelActionsController(accountsListModel);
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>((AccountsPanelFactory<GoogleAccount, GoogleCredentials>)panelFactory, detailsProvider, actionsController){
            final /* synthetic */ AccountsPanelFactory<GoogleAccount, GoogleCredentials> $panelFactory;
            final /* synthetic */ GoogleAccountsDetailsProvider $detailsProvider;
            final /* synthetic */ GoogleAccountsPanelActionsController $actionsController;
            {
                this.$panelFactory = $panelFactory;
                this.$detailsProvider = $detailsProvider;
                this.$actionsController = $actionsController;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$panelFactory, this.$detailsProvider, this.$actionsController){
                    final /* synthetic */ AccountsPanelFactory<GoogleAccount, GoogleCredentials> $panelFactory;
                    final /* synthetic */ GoogleAccountsDetailsProvider $detailsProvider;
                    final /* synthetic */ GoogleAccountsPanelActionsController $actionsController;
                    {
                        this.$panelFactory = $panelFactory;
                        this.$detailsProvider = $detailsProvider;
                        this.$actionsController = $actionsController;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        this.$panelFactory.accountsPanelCell($this$row, (LoadingAccountsDetailsProvider)this.$detailsProvider, (AccountsPanelActionsController)this.$actionsController).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
    }

    @RequiresBackgroundThread
    @Nullable
    public final GoogleAppCredentials getGoogleAppCredentials() {
        String googleAppCredUrl = "https://www.jetbrains.com/config/markdown.json";
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(googleAppCredUrl)).header("Content-Type", "application/json").GET().build();
            Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"newBuilder()\n        .ur\u2026  .GET()\n        .build()");
            HttpRequest httpRequest2 = httpRequest;
            HttpResponse<String> response = client.send(httpRequest2, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                ObjectMapper $this$getGoogleAppCredentials_u24lambda_u244 = this.getJacksonMapper();
                boolean bl = false;
                JsonNode credentials = $this$getGoogleAppCredentials_u24lambda_u244.readTree(response.body()).get("google").get("auth");
                String clientId = credentials.get("secret-id").asText();
                String clientSecret = credentials.get("client-secret").asText();
                Intrinsics.checkNotNullExpressionValue((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullExpressionValue((Object)clientSecret, (String)"clientSecret");
                return new GoogleAppCredentials(clientId, clientSecret);
            }
            LOG.info("Status code: " + response.statusCode() + "\n" + response.body());
            return null;
        }
        catch (ConnectException e) {
            LOG.info((Throwable)new GoogleAppCredentialsException());
            return null;
        }
    }

    @NotNull
    public final Credential createCredentialsForGoogleApi(@NotNull GoogleCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        TokenResponse tokenResponse = this.getTokenResponse(credentials);
        GoogleCredential googleCredential = new GoogleCredential().setFromTokenResponse(tokenResponse);
        Intrinsics.checkNotNullExpressionValue((Object)googleCredential, (String)"GoogleCredential().setFr\u2026enResponse(tokenResponse)");
        return googleCredential;
    }

    private final TokenResponse getTokenResponse(GoogleCredentials credentials) {
        TokenResponse tokenResponse;
        TokenResponse $this$getTokenResponse_u24lambda_u245 = tokenResponse = new TokenResponse();
        boolean bl = false;
        $this$getTokenResponse_u24lambda_u245.setAccessToken(credentials.getAccessToken());
        $this$getTokenResponse_u24lambda_u245.setTokenType(credentials.getTokenType());
        $this$getTokenResponse_u24lambda_u245.setScope(credentials.getScope());
        $this$getTokenResponse_u24lambda_u245.setExpiresInSeconds(credentials.getExpiresIn());
        return tokenResponse;
    }

    private static final GoogleCredentials tryToReLogin$lambda$0(Ref.ObjectRef $credentialsFuture) {
        Intrinsics.checkNotNullParameter((Object)$credentialsFuture, (String)"$credentialsFuture");
        GoogleOAuthRequest request = GoogleOAuthRequestKt.getGoogleAuthRequest();
        boolean $i$f$service = false;
        Class<GoogleOAuthService> serviceClass$iv = GoogleOAuthService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        $credentialsFuture.element = ((GoogleOAuthService)((Object)object)).authorize(request);
        return (GoogleCredentials)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((Future)$credentialsFuture.element));
    }

    private static final GoogleCredentials getOrUpdateUserCredentials$lambda$3$lambda$1(CompletableFuture $credentialFuture, GoogleAccountManager $accountManager, GoogleAccount $account) {
        Intrinsics.checkNotNullParameter((Object)$credentialFuture, (String)"$credentialFuture");
        Intrinsics.checkNotNullParameter((Object)((Object)$accountManager), (String)"$accountManager");
        Intrinsics.checkNotNullParameter((Object)((Object)$account), (String)"$account");
        GoogleCredentials newCred = (GoogleCredentials)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)$credentialFuture);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($accountManager, $account, newCred, null){
            int label;
            final /* synthetic */ GoogleAccountManager $accountManager;
            final /* synthetic */ GoogleAccount $account;
            final /* synthetic */ GoogleCredentials $newCred;
            {
                this.$accountManager = $accountManager;
                this.$account = $account;
                this.$newCred = $newCred;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Account account = this.$account;
                        GoogleCredentials googleCredentials = this.$newCred;
                        Intrinsics.checkNotNullExpressionValue((Object)googleCredentials, (String)"newCred");
                        this.label = 1;
                        Object object3 = this.$accountManager.updateAccount(account, googleCredentials, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return newCred;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GoogleOAuthService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/google/utils/GoogleAccountsUtils$GoogleAppCredentials;", "", "clientId", "", "clientSecret", "(Ljava/lang/String;Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "getClientSecret", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown.core"})
    public static final class GoogleAppCredentials {
        @NotNull
        private final String clientId;
        @NotNull
        private final String clientSecret;

        public GoogleAppCredentials(@NotNull String clientId, @NotNull String clientSecret) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String getClientSecret() {
            return this.clientSecret;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final String component2() {
            return this.clientSecret;
        }

        @NotNull
        public final GoogleAppCredentials copy(@NotNull String clientId, @NotNull String clientSecret) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            return new GoogleAppCredentials(clientId, clientSecret);
        }

        public static /* synthetic */ GoogleAppCredentials copy$default(GoogleAppCredentials googleAppCredentials, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = googleAppCredentials.clientId;
            }
            if ((n & 2) != 0) {
                string2 = googleAppCredentials.clientSecret;
            }
            return googleAppCredentials.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "GoogleAppCredentials(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ")";
        }

        public int hashCode() {
            int result2 = this.clientId.hashCode();
            result2 = result2 * 31 + this.clientSecret.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GoogleAppCredentials)) {
                return false;
            }
            GoogleAppCredentials googleAppCredentials = (GoogleAppCredentials)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)googleAppCredentials.clientId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.clientSecret, (Object)googleAppCredentials.clientSecret);
        }
    }
}

