/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.UnloadedUtil;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinInlineFilter;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.rt.coverage.util.ReportSectionsUtil;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageReport {
    private final File myDataFile;
    private File mySourceMapFile;
    private final boolean myAppendUnloaded;
    private final ClassFinder myClassFinder;
    private final boolean myMergeFile;

    public CoverageReport(File dataFile, boolean appendUnloaded, ClassFinder classFinder, boolean mergeFile) {
        this.myDataFile = dataFile;
        this.myAppendUnloaded = appendUnloaded;
        this.myClassFinder = classFinder;
        this.myMergeFile = mergeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save(ProjectData projectData) {
        projectData.stop();
        CoverageIOUtil.FileLock lock = null;
        try {
            CoverageReport.finalizeCoverage(projectData, this.myAppendUnloaded, this.myClassFinder, this.mySourceMapFile != null);
            lock = CoverageIOUtil.FileLock.lock(this.myDataFile);
            if (this.myMergeFile) {
                ProjectData load = ProjectDataLoader.load(this.myDataFile);
                projectData.merge(load);
            }
            CoverageReport.save(projectData, this.myDataFile, this.mySourceMapFile);
            CoverageIOUtil.FileLock.unlock(lock);
        }
        catch (OutOfMemoryError e) {
            ErrorReporter.reportError("Out of memory error occurred, try to increase memory available for the JVM, or make include / exclude patterns more specific", e);
        }
        catch (Throwable e2) {
            ErrorReporter.reportError("Unexpected error", e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            CoverageIOUtil.FileLock.unlock(lock);
        }
        finally {
            CoverageIOUtil.FileLock.unlock(lock);
        }
    }

    public void setSourceMapFile(File sourceMapFile) {
        this.mySourceMapFile = sourceMapFile;
    }

    private static void finalizeCoverage(ProjectData projectData, boolean appendUnloaded, ClassFinder cf, boolean calculateSource) {
        projectData.applyHits();
        if (appendUnloaded) {
            UnloadedUtil.appendUnloaded(projectData, cf, calculateSource, projectData.isBranchCoverage());
        }
        projectData.applyLineMappings();
        projectData.dropIgnoredLines();
        KotlinInlineFilter.checkLineSignatures(projectData, cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(ProjectData projectData, File dataFile, File sourceMapFile) {
        DataOutputStream os = null;
        try {
            os = CoverageIOUtil.openWriteFile(dataFile);
            TObjectIntHashMap<String> dict = new TObjectIntHashMap<String>();
            HashMap<String, ClassData> classes = new HashMap<String, ClassData>(projectData.getClasses());
            CoverageIOUtil.writeINT(os, classes.size());
            CoverageReport.saveDictionary(os, dict, classes);
            CoverageReport.saveData(os, dict, classes);
            CoverageIOUtil.writeINT(os, 1);
            CoverageIOUtil.writeUTF(os, CoverageReport.getExtraInfoString());
            ReportSectionsUtil.saveSections(projectData, os, dict);
            CoverageReport.saveSourceMap(classes, sourceMapFile);
        }
        catch (IOException e) {
            ErrorReporter.reportError("Error writing file " + dataFile.getPath(), e);
        }
        finally {
            CoverageIOUtil.close(os);
        }
    }

    private static String getExtraInfoString() {
        return "";
    }

    public static void saveSourceMap(Map<String, ClassData> classes, File sourceMapFile) {
        if (sourceMapFile == null) {
            return;
        }
        Map<String, String> readNames = Collections.emptyMap();
        try {
            if (sourceMapFile.exists() && sourceMapFile.length() > 0L) {
                readNames = CoverageReport.loadSourceMapFromFile(classes, sourceMapFile);
            }
        }
        catch (IOException e) {
            ErrorReporter.reportError("Error loading source map from " + sourceMapFile.getPath(), e);
        }
        try {
            CoverageReport.doSaveSourceMap(readNames, sourceMapFile, classes);
        }
        catch (IOException e) {
            ErrorReporter.reportError("Error writing source map " + sourceMapFile.getPath(), e);
        }
    }

    public static void loadAndApplySourceMap(ProjectData projectData, File sourceMapFile) throws IOException {
        Map<String, String> map = CoverageReport.loadSourceMapFromFile(new HashMap<String, ClassData>(), sourceMapFile);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String source = entry.getValue();
            ClassData data = projectData.getClassData(className);
            if (data == null) continue;
            data.setSource(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadSourceMapFromFile(Map<String, ClassData> classes, File sourceMapFile) throws IOException {
        HashMap<String, String> hashMap;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(sourceMapFile));
            int classNumber = CoverageIOUtil.readINT(in);
            HashMap<String, String> readNames = new HashMap<String, String>(classNumber);
            for (int i = 0; i < classNumber; ++i) {
                ClassData data;
                String className = CoverageIOUtil.readUTFFast(in);
                String classSource = CoverageIOUtil.readUTFFast(in);
                if ("".equals(classSource) || (data = classes.get(className)) != null && data.getSource() != null && data.getSource().equals(classSource)) continue;
                readNames.put(className, classSource);
            }
            hashMap = readNames;
        }
        catch (Throwable throwable) {
            CoverageIOUtil.close(in);
            throw throwable;
        }
        CoverageIOUtil.close(in);
        return hashMap;
    }

    private static void saveData(DataOutputStream os, final TObjectIntHashMap<String> dict, Map<String, ClassData> classes) throws IOException {
        for (ClassData o : classes.values()) {
            o.save(os, new DictionaryLookup(){

                public int getDictionaryIndex(String className) {
                    return dict.containsKey(className) ? dict.get(className) : -1;
                }
            });
        }
    }

    private static void saveDictionary(DataOutputStream os, TObjectIntHashMap<String> dict, Map<String, ClassData> classes) throws IOException {
        int i = 0;
        for (String className : classes.keySet()) {
            dict.put(className, i++);
            CoverageIOUtil.writeUTF(os, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSaveSourceMap(Map<String, String> classNameToFile, File sourceMapFile, Map<String, ClassData> classes) throws IOException {
        HashMap<String, String> sources = new HashMap<String, String>(classNameToFile);
        for (ClassData classData : classes.values()) {
            if (sources.containsKey(classData.getName())) continue;
            sources.put(classData.getName(), classData.getSource());
        }
        DataOutputStream out = null;
        try {
            out = CoverageIOUtil.openWriteFile(sourceMapFile);
            CoverageIOUtil.writeINT(out, sources.size());
            for (Map.Entry<String, String> entry : sources.entrySet()) {
                CoverageIOUtil.writeUTF(out, entry.getKey());
                String value = entry.getValue();
                CoverageIOUtil.writeUTF(out, value != null ? value : "");
            }
        }
        finally {
            CoverageIOUtil.close(out);
        }
    }
}

