/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinUnsafeCastFilter
extends BranchesFilter {
    private int myState = 0;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context);
    }

    public void initFilter(MethodVisitor mv, Instrumenter context, BranchDataContainer branchData) {
        super.initFilter(mv, context, branchData);
        this.myState = 0;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (this.myState == 1 && opcode == 87) {
            return;
        }
        if (this.myState == 2 && opcode == 89) {
            ++this.myState;
        } else if (this.myState == 5 && opcode == 191) {
            this.myBranchData.removeLastJump();
            this.myState = 0;
        } else {
            this.myState = 0;
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.myState = this.myState == 0 && opcode == 199 ? ++this.myState : 0;
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        this.myState = this.myState == 1 && opcode == 187 && "java/lang/NullPointerException".equals(type) ? ++this.myState : 0;
    }

    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(value);
        this.myState = this.myState == 3 && value instanceof String && ((String)value).startsWith("null cannot be cast to non-null type ") ? ++this.myState : 0;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        this.myState = this.myState == 4 && opcode == 183 && "java/lang/NullPointerException".equals(owner) && "<init>".equals(name) && "(Ljava/lang/String;)V".equals(descriptor) ? ++this.myState : 0;
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.myState = 0;
    }
}

