/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.codereview.timeline.StatusMessageType;
import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHGitRefName;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRAssignedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRBaseRefChangedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRBaseRefForcePushedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRConnectedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRConvertToDraftEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRCrossReferencedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRDisconnectedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRHeadRefDeletedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRHeadRefForcePushedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRHeadRefRestoredEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRLabeledEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRMergedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReadyForReviewEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReferencedSubject;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRRenamedTitleEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewDismissedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewRequestedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewUnrequestedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRUnassignedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRUnlabeledEvent;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemUIUtil;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedSimpleEvents;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedStateEvents;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u001a\u001b\u001c\u001d\u001e\u001fB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0002R\u0018\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "htmlImageLoader", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "branchEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$BranchEventComponentFactory;", "complexEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$ComplexEventComponentFactory;", "simpleEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$SimpleEventComponentFactory;", "stateEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory;", "createComponent", "Ljavax/swing/JComponent;", "event", "throwUnknownType", "", "item", "BranchEventComponentFactory", "Companion", "ComplexEventComponentFactory", "EventComponentFactory", "SimpleEventComponentFactory", "StateEventComponentFactory", "intellij.vcs.github"})
public final class GHPRTimelineEventComponentFactoryImpl
implements GHPRTimelineEventComponentFactory<GHPRTimelineEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AsyncHtmlImageLoader htmlImageLoader;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final GHUser ghostUser;
    @NotNull
    private final SimpleEventComponentFactory simpleEventDelegate;
    @NotNull
    private final StateEventComponentFactory stateEventDelegate;
    @NotNull
    private final BranchEventComponentFactory branchEventDelegate;
    @NotNull
    private final ComplexEventComponentFactory complexEventDelegate;

    public GHPRTimelineEventComponentFactoryImpl(@NotNull AsyncHtmlImageLoader htmlImageLoader, @NotNull IconsProvider<String> avatarIconsProvider, @NotNull GHUser ghostUser) {
        Intrinsics.checkNotNullParameter((Object)htmlImageLoader, (String)"htmlImageLoader");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)ghostUser, (String)"ghostUser");
        this.htmlImageLoader = htmlImageLoader;
        this.avatarIconsProvider = avatarIconsProvider;
        this.ghostUser = ghostUser;
        this.simpleEventDelegate = new SimpleEventComponentFactory();
        this.stateEventDelegate = new StateEventComponentFactory();
        this.branchEventDelegate = new BranchEventComponentFactory();
        this.complexEventDelegate = new ComplexEventComponentFactory();
    }

    @Override
    @NotNull
    public JComponent createComponent(@NotNull GHPRTimelineEvent event) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GHPRTimelineEvent gHPRTimelineEvent = event;
        if (gHPRTimelineEvent instanceof GHPRTimelineEvent.Simple) {
            jComponent = this.simpleEventDelegate.createComponent((GHPRTimelineEvent.Simple)event);
        } else if (gHPRTimelineEvent instanceof GHPRTimelineEvent.State) {
            jComponent = this.stateEventDelegate.createComponent((GHPRTimelineEvent.State)event);
        } else if (gHPRTimelineEvent instanceof GHPRTimelineEvent.Branch) {
            jComponent = this.branchEventDelegate.createComponent((GHPRTimelineEvent.Branch)event);
        } else if (gHPRTimelineEvent instanceof GHPRTimelineEvent.Complex) {
            jComponent = this.complexEventDelegate.createComponent((GHPRTimelineEvent.Complex)event);
        } else {
            this.throwUnknownType(event);
            throw new KotlinNothingValueException();
        }
        return jComponent;
    }

    private final Void throwUnknownType(GHPRTimelineEvent item) {
        throw new IllegalStateException("Unknown event type \"" + item.getClass().getCanonicalName() + "\"");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$BranchEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Branch;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "branchHTML", "Lcom/intellij/openapi/util/text/HtmlChunk;", "ref", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHGitRefName;", "createComponent", "Ljavax/swing/JComponent;", "event", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGHPRTimelineEventComponentFactoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineEventComponentFactoryImpl.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$BranchEventComponentFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n1#2:293\n*E\n"})
    private final class BranchEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.Branch> {
        @Override
        @NotNull
        public JComponent createComponent(@NotNull GHPRTimelineEvent.Branch event) {
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            GHPRTimelineEvent.Branch branch = event;
            if (branch instanceof GHPRBaseRefChangedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.changed.base.branch", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.ti\u2026ine.changed.base.branch\")");
                jComponent = this.eventItem(gHPRTimelineEvent, string);
            } else if (branch instanceof GHPRBaseRefForcePushedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                Object[] objectArray = new Object[1];
                Object object = this.branchHTML(((GHPRBaseRefForcePushedEvent)event).getRef());
                if (object == null) {
                    object = "base";
                }
                objectArray[0] = object;
                String string = GithubBundle.message("pull.request.timeline.branch.force.pushed", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.ti\u2026TML(event.ref) ?: \"base\")");
                jComponent = this.eventItem(gHPRTimelineEvent, string);
            } else if (branch instanceof GHPRHeadRefForcePushedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                Object[] objectArray = new Object[1];
                Object object = this.branchHTML(((GHPRHeadRefForcePushedEvent)event).getRef());
                if (object == null) {
                    object = "head";
                }
                objectArray[0] = object;
                String string = GithubBundle.message("pull.request.timeline.branch.force.pushed", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.ti\u2026TML(event.ref) ?: \"head\")");
                jComponent = this.eventItem(gHPRTimelineEvent, string);
            } else if (branch instanceof GHPRHeadRefDeletedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                Object[] objectArray = new Object[]{Companion.branchHTML(((GHPRHeadRefDeletedEvent)event).getHeadRefName())};
                String string = GithubBundle.message("pull.request.timeline.branch.deleted", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.ti\u2026hHTML(event.headRefName))");
                jComponent = this.eventItem(gHPRTimelineEvent, string);
            } else if (branch instanceof GHPRHeadRefRestoredEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.branch.head.restored", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.ti\u2026ne.branch.head.restored\")");
                jComponent = this.eventItem(gHPRTimelineEvent, string);
            } else {
                GHPRTimelineEventComponentFactoryImpl.this.throwUnknownType(event);
                throw new KotlinNothingValueException();
            }
            return jComponent;
        }

        private final HtmlChunk branchHTML(GHGitRefName ref) {
            HtmlChunk htmlChunk;
            Object object = ref;
            if (object != null && (object = ((GHGitRefName)object).getName()) != null) {
                Object it = object;
                boolean bl = false;
                htmlChunk = Companion.branchHTML((String)it);
            } else {
                htmlChunk = null;
            }
            return htmlChunk;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0015\u0010\u0007\u001a\u00020\u00042\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0019\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u000b\u0010\u0013\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0002J\u0011\u0010\u0014\u001a\u00070\t\u00a2\u0006\u0002\b\u0015*\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$Companion;", "", "()V", "actorHTML", "Lcom/intellij/openapi/util/text/HtmlChunk;", "actor", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "branchHTML", "name", "", "Lorg/jetbrains/annotations/Nls;", "labelHTML", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "reviewerHTML", "reviewer", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "appendParagraph", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "text", "asReferenceLink", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRReferencedSubject;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final HtmlChunk branchHTML(String name) {
            JBColor foreground = CurrentBranchComponent.TEXT_COLOR;
            Color color2 = UIUtil.getListBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getListBackground()");
            Color background = CurrentBranchComponent.Companion.getBranchPresentationBackground(color2);
            HtmlChunk.Element element = HtmlChunk.tag((String)"icon-inline").attr("src", "icons.CollaborationToolsIcons.Review.Branch");
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tag(\"icon-inline\")\n     \u2026oolsIcons.Review.Branch\")");
            HtmlChunk.Element iconChunk = element;
            HtmlChunk.Element element2 = HtmlChunk.span((String)("color: #" + ColorUtil.toHex((Color)((Color)foreground)) + "; background: #" + ColorUtil.toHex((Color)background))).child(HtmlChunk.nbsp()).child((HtmlChunk)iconChunk).addText(name).child(HtmlChunk.nbsp());
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"span(\"color: #${ColorUti\u2026 .child(HtmlChunk.nbsp())");
            return (HtmlChunk)element2;
        }

        private final HtmlChunk labelHTML(GHLabel label) {
            JBColor background = CollaborationToolsUIUtil.INSTANCE.getLabelBackground(label.getColor());
            Color foreground = CollaborationToolsUIUtil.INSTANCE.getLabelForeground((Color)background);
            HtmlChunk.Element element = HtmlChunk.span((String)("color: #" + ColorUtil.toHex((Color)foreground) + "; background: #" + ColorUtil.toHex((Color)((Color)background)))).child(HtmlChunk.nbsp()).addText(label.getName()).child(HtmlChunk.nbsp());
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"span(\"color: #${ColorUti\u2026 .child(HtmlChunk.nbsp())");
            return (HtmlChunk)element;
        }

        private final HtmlChunk actorHTML(GHActor actor) {
            HtmlChunk.Element element = HtmlChunk.link((String)actor.getUrl(), (String)actor.getPresentableName());
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(actor.url, actor.getPresentableName())");
            return (HtmlChunk)element;
        }

        private final HtmlChunk reviewerHTML(GHPullRequestRequestedReviewer reviewer) {
            HtmlChunk.Element element = HtmlChunk.link((String)reviewer.getUrl(), (String)reviewer.getPresentableName());
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"link(reviewer.url, reviewer.getPresentableName())");
            return (HtmlChunk)element;
        }

        private final HtmlBuilder appendParagraph(HtmlBuilder $this$appendParagraph, String text) {
            HtmlBuilder htmlBuilder;
            HtmlBuilder $this$appendParagraph_u24lambda_u240 = htmlBuilder = $this$appendParagraph;
            boolean bl = false;
            if (((CharSequence)text).length() > 0) {
                $this$appendParagraph_u24lambda_u240.append((HtmlChunk)HtmlChunk.p().addRaw(text));
            }
            return htmlBuilder;
        }

        private final String asReferenceLink(GHPRReferencedSubject $this$asReferenceLink) {
            return $this$asReferenceLink.getTitle() + "&nbsp<a href='" + $this$asReferenceLink.getUrl() + "'>#" + $this$asReferenceLink.getNumber() + "</a>";
        }

        public static final /* synthetic */ HtmlChunk access$actorHTML(Companion $this, GHActor actor) {
            return $this.actorHTML(actor);
        }

        public static final /* synthetic */ HtmlChunk access$reviewerHTML(Companion $this, GHPullRequestRequestedReviewer reviewer) {
            return $this.reviewerHTML(reviewer);
        }

        public static final /* synthetic */ HtmlChunk access$labelHTML(Companion $this, GHLabel label) {
            return $this.labelHTML(label);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$ComplexEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Complex;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "createComponent", "Ljavax/swing/JComponent;", "event", "intellij.vcs.github"})
    private final class ComplexEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.Complex> {
        @Override
        @NotNull
        public JComponent createComponent(@NotNull GHPRTimelineEvent.Complex event) {
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            GHPRTimelineEvent.Complex complex = event;
            if (complex instanceof GHPRReviewDismissedEvent) {
                GHActor gHActor = ((GHPRReviewDismissedEvent)event).getReviewAuthor();
                if (gHActor == null) {
                    gHActor = GHPRTimelineEventComponentFactoryImpl.this.ghostUser;
                }
                String author = gHActor.getLogin();
                Object[] objectArray = new Object[]{author};
                Object[] $this$createComponent_u24lambda_u240 = objectArray = new HtmlBuilder().append(GithubBundle.message("pull.request.timeline.stale.review.dismissed", objectArray));
                boolean bl = false;
                String msg = ((GHPRReviewDismissedEvent)event).getDismissalMessageHTML();
                if (msg != null) {
                    $this$createComponent_u24lambda_u240.append((HtmlChunk)HtmlChunk.br()).appendRaw(msg);
                }
                String string = objectArray.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder()\n          \u2026\n            }.toString()");
                String text = string;
                jComponent = this.eventItem(event, text);
            } else if (complex instanceof GHPRReadyForReviewEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.marked.as.ready", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.timeline.marked.as.ready\")");
                jComponent = this.eventItem(gHPRTimelineEvent, string);
            } else if (complex instanceof GHPRConvertToDraftEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.marked.as.draft", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.timeline.marked.as.draft\")");
                jComponent = this.eventItem(gHPRTimelineEvent, string);
            } else if (complex instanceof GHPRCrossReferencedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.mentioned", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.timeline.mentioned\")");
                jComponent = this.eventItem(gHPRTimelineEvent, string, Companion.asReferenceLink(((GHPRCrossReferencedEvent)event).getSource()));
            } else if (complex instanceof GHPRConnectedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.connected", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.timeline.connected\")");
                jComponent = this.eventItem(gHPRTimelineEvent, string, Companion.asReferenceLink(((GHPRConnectedEvent)event).getSubject()));
            } else if (complex instanceof GHPRDisconnectedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.disconnected", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.timeline.disconnected\")");
                jComponent = this.eventItem(gHPRTimelineEvent, string, Companion.asReferenceLink(((GHPRDisconnectedEvent)event).getSubject()));
            } else {
                GHPRTimelineEventComponentFactoryImpl.this.throwUnknownType(event);
                throw new KotlinNothingValueException();
            }
            return jComponent;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0004J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u000b\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u000f\b\u0002\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nH\u0004J%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0004\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "T", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "eventItem", "Ljavax/swing/JComponent;", "event", "detailsText", "", "Lorg/jetbrains/annotations/Nls;", "titleText", "type", "Lcom/intellij/collaboration/ui/codereview/timeline/StatusMessageType;", "intellij.vcs.github"})
    private abstract class EventComponentFactory<T extends GHPRTimelineEvent>
    implements GHPRTimelineEventComponentFactory<T> {
        @NotNull
        protected final JComponent eventItem(@NotNull GHPRTimelineEvent event, @NotNull String detailsText) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)detailsText, (String)"detailsText");
            JComponent content2 = GHPRTimelineItemUIUtil.createDescriptionComponent$default(GHPRTimelineItemUIUtil.INSTANCE, detailsText, null, 2, null);
            IconsProvider iconsProvider = GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider;
            GHActor gHActor = event.getActor();
            if (gHActor == null) {
                gHActor = GHPRTimelineEventComponentFactoryImpl.this.ghostUser;
            }
            return GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, iconsProvider, gHActor, event.getCreatedAt(), content2, null, 16, null);
        }

        @NotNull
        protected final JComponent eventItem(@NotNull GHPRTimelineEvent event, @NotNull StatusMessageType type, @NotNull String detailsText) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)detailsText, (String)"detailsText");
            JComponent content2 = GHPRTimelineItemUIUtil.INSTANCE.createDescriptionComponent(detailsText, type);
            IconsProvider iconsProvider = GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider;
            GHActor gHActor = event.getActor();
            if (gHActor == null) {
                gHActor = GHPRTimelineEventComponentFactoryImpl.this.ghostUser;
            }
            return GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, iconsProvider, gHActor, event.getCreatedAt(), content2, null, 16, null);
        }

        @NotNull
        protected final JComponent eventItem(@NotNull GHPRTimelineEvent event, @NotNull String titleText, @Nullable String detailsText) {
            JComponent jComponent;
            JEditorPane jEditorPane;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)titleText, (String)"titleText");
            JEditorPane $this$eventItem_u24lambda_u240 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, (AsyncHtmlImageLoader)GHPRTimelineEventComponentFactoryImpl.this.htmlImageLoader, null, (int)11, null);
            boolean bl = false;
            HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)$this$eventItem_u24lambda_u240, (String)titleText);
            JEditorPane titlePane = jEditorPane;
            if (detailsText == null) {
                jComponent = titlePane;
            } else {
                JPanel jPanel;
                JPanel $this$eventItem_u24lambda_u241 = jPanel = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
                boolean bl2 = false;
                $this$eventItem_u24lambda_u241.add(titlePane);
                $this$eventItem_u24lambda_u241.add(GHPRTimelineItemUIUtil.createDescriptionComponent$default(GHPRTimelineItemUIUtil.INSTANCE, detailsText, null, 2, null));
                jComponent = jPanel;
            }
            JEditorPane content2 = jComponent;
            IconsProvider iconsProvider = GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider;
            GHActor gHActor = event.getActor();
            if (gHActor == null) {
                gHActor = GHPRTimelineEventComponentFactoryImpl.this.ghostUser;
            }
            return GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, iconsProvider, gHActor, event.getCreatedAt(), content2, null, 16, null);
        }

        public static /* synthetic */ JComponent eventItem$default(EventComponentFactory eventComponentFactory, GHPRTimelineEvent gHPRTimelineEvent, String string, String string2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: eventItem");
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            return eventComponentFactory.eventItem(gHPRTimelineEvent, string, string2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J-\u0010\u000f\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0002J\u001d\u0010\u0013\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J1\u0010\u0016\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00172\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\t2\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\tH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$SimpleEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "assigneesText", "", "Lorg/jetbrains/annotations/Nls;", "assigned", "", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "unassigned", "createComponent", "Ljavax/swing/JComponent;", "event", "labelsText", "added", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "removed", "renameText", "oldName", "newName", "reviewersText", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGHPRTimelineEventComponentFactoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineEventComponentFactoryImpl.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$SimpleEventComponentFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n1#2:293\n*E\n"})
    private final class SimpleEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.Simple> {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public JComponent createComponent(@NotNull GHPRTimelineEvent.Simple event) {
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            GHPRTimelineEvent.Simple simple = event;
            if (simple instanceof GHPRAssignedEvent) {
                jComponent = this.eventItem(event, SimpleEventComponentFactory.assigneesText$default(this, CollectionsKt.listOf((Object)((GHPRAssignedEvent)event).getUser()), null, 2, null));
            } else if (simple instanceof GHPRUnassignedEvent) {
                jComponent = this.eventItem(event, SimpleEventComponentFactory.assigneesText$default(this, null, CollectionsKt.listOf((Object)((GHPRUnassignedEvent)event).getUser()), 1, null));
            } else if (simple instanceof GHPRReviewRequestedEvent) {
                jComponent = this.eventItem(event, SimpleEventComponentFactory.reviewersText$default(this, CollectionsKt.listOf((Object)((GHPRReviewRequestedEvent)event).getRequestedReviewer()), null, 2, null));
            } else if (simple instanceof GHPRReviewUnrequestedEvent) {
                jComponent = this.eventItem(event, SimpleEventComponentFactory.reviewersText$default(this, null, CollectionsKt.listOf((Object)((GHPRReviewUnrequestedEvent)event).getRequestedReviewer()), 1, null));
            } else if (simple instanceof GHPRLabeledEvent) {
                jComponent = this.eventItem(event, SimpleEventComponentFactory.labelsText$default(this, CollectionsKt.listOf((Object)((GHPRLabeledEvent)event).getLabel()), null, 2, null));
            } else if (simple instanceof GHPRUnlabeledEvent) {
                jComponent = this.eventItem(event, SimpleEventComponentFactory.labelsText$default(this, null, CollectionsKt.listOf((Object)((GHPRUnlabeledEvent)event).getLabel()), 1, null));
            } else if (simple instanceof GHPRRenamedTitleEvent) {
                jComponent = this.eventItem(event, this.renameText(((GHPRRenamedTitleEvent)event).getPreviousTitle(), ((GHPRRenamedTitleEvent)event).getCurrentTitle()));
            } else if (simple instanceof GHPRTimelineMergedSimpleEvents) {
                String string;
                String string2;
                Companion companion = Companion;
                HtmlBuilder htmlBuilder = Companion.appendParagraph(Companion.appendParagraph(Companion.appendParagraph(new HtmlBuilder(), this.labelsText((Collection<GHLabel>)((GHPRTimelineMergedSimpleEvents)event).getAddedLabels(), (Collection<GHLabel>)((GHPRTimelineMergedSimpleEvents)event).getRemovedLabels())), this.assigneesText((Collection<GHUser>)((GHPRTimelineMergedSimpleEvents)event).getAssignedPeople(), (Collection<GHUser>)((GHPRTimelineMergedSimpleEvents)event).getUnassignedPeople())), this.reviewersText((Collection<? extends GHPullRequestRequestedReviewer>)((GHPRTimelineMergedSimpleEvents)event).getAddedReviewers(), (Collection<? extends GHPullRequestRequestedReviewer>)((GHPRTimelineMergedSimpleEvents)event).getRemovedReviewers()));
                Pair<String, String> pair = ((GHPRTimelineMergedSimpleEvents)event).getRename();
                if (pair != null) {
                    void it;
                    Pair<String, String> pair2 = pair;
                    HtmlBuilder htmlBuilder2 = htmlBuilder;
                    Companion companion2 = companion;
                    boolean bl = false;
                    String string3 = this.renameText((String)it.getFirst(), (String)it.getSecond());
                    companion = companion2;
                    htmlBuilder = htmlBuilder2;
                    string2 = string3;
                } else {
                    string2 = string = null;
                }
                if (string2 == null) {
                    string = "";
                }
                HtmlBuilder builder = companion.appendParagraph(htmlBuilder, string);
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string4 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"builder.toString()");
                jComponent = this.eventItem(gHPRTimelineEvent, string4);
            } else {
                GHPRTimelineEventComponentFactoryImpl.this.throwUnknownType(event);
                throw new KotlinNothingValueException();
            }
            return jComponent;
        }

        private final String assigneesText(Collection<GHUser> assigned, Collection<GHUser> unassigned) {
            String string;
            Object[] objectArray;
            Collection<GHUser> collection;
            Collection<GHUser> it = collection = assigned;
            boolean bl = false;
            Collection<GHUser> collection2 = !it.isEmpty() ? collection : null;
            String assignedNames2 = collection2 != null ? CollectionsKt.joinToString$default((Iterable)collection2, null, null, null, (int)0, null, (Function1)assigneesText.assignedNames.2.INSTANCE, (int)31, null) : null;
            Object[] it2 = objectArray = unassigned;
            boolean bl2 = false;
            Object object = !it2.isEmpty() ? objectArray : null;
            String unassignedNames2 = object != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), null, null, null, (int)0, null, (Function1)assigneesText.unassignedNames.2.INSTANCE, (int)31, null) : null;
            if (assignedNames2 != null && unassignedNames2 != null) {
                objectArray = new Object[]{assignedNames2, unassignedNames2};
                String string2 = GithubBundle.message("pull.request.timeline.event.assigned.and.unassigned", objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"pull.request.ti\u2026edNames, unassignedNames)");
            } else if (assignedNames2 != null) {
                objectArray = new Object[]{assignedNames2};
                String string3 = GithubBundle.message("pull.request.timeline.event.assigned", objectArray);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"pull.request.ti\u2026assigned\", assignedNames)");
            } else if (unassignedNames2 != null) {
                objectArray = new Object[]{unassignedNames2};
                String string4 = GithubBundle.message("pull.request.timeline.event.unassigned", objectArray);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"pull.request.ti\u2026signed\", unassignedNames)");
            } else {
                string = "";
            }
            return string;
        }

        static /* synthetic */ String assigneesText$default(SimpleEventComponentFactory simpleEventComponentFactory, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            return simpleEventComponentFactory.assigneesText(collection, collection2);
        }

        private final String reviewersText(Collection<? extends GHPullRequestRequestedReviewer> added, Collection<? extends GHPullRequestRequestedReviewer> removed) {
            String string;
            Object[] objectArray;
            Collection<? extends GHPullRequestRequestedReviewer> collection;
            Collection<? extends GHPullRequestRequestedReviewer> it = collection = added;
            boolean bl = false;
            Collection<? extends GHPullRequestRequestedReviewer> collection2 = !it.isEmpty() ? collection : null;
            String addedLogins2 = collection2 != null ? CollectionsKt.joinToString$default((Iterable)collection2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<GHPullRequestRequestedReviewer, CharSequence>(GHPRTimelineEventComponentFactoryImpl.this){
                final /* synthetic */ GHPRTimelineEventComponentFactoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@Nullable GHPullRequestRequestedReviewer it) {
                    GHPullRequestRequestedReviewer gHPullRequestRequestedReviewer = it;
                    if (gHPullRequestRequestedReviewer == null) {
                        gHPullRequestRequestedReviewer = GHPRTimelineEventComponentFactoryImpl.access$getGhostUser$p(this.this$0);
                    }
                    String string = org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl$Companion.access$reviewerHTML(GHPRTimelineEventComponentFactoryImpl.Companion, gHPullRequestRequestedReviewer).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reviewerHTML(it ?: ghostUser).toString()");
                    return string;
                }
            }), (int)31, null) : null;
            Object[] it2 = objectArray = removed;
            boolean bl2 = false;
            Object object = !it2.isEmpty() ? objectArray : null;
            String removedLogins2 = object != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), null, null, null, (int)0, null, (Function1)((Function1)new Function1<GHPullRequestRequestedReviewer, CharSequence>(GHPRTimelineEventComponentFactoryImpl.this){
                final /* synthetic */ GHPRTimelineEventComponentFactoryImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@Nullable GHPullRequestRequestedReviewer it) {
                    GHPullRequestRequestedReviewer gHPullRequestRequestedReviewer = it;
                    if (gHPullRequestRequestedReviewer == null) {
                        gHPullRequestRequestedReviewer = GHPRTimelineEventComponentFactoryImpl.access$getGhostUser$p(this.this$0);
                    }
                    String string = org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl$Companion.access$reviewerHTML(GHPRTimelineEventComponentFactoryImpl.Companion, gHPullRequestRequestedReviewer).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reviewerHTML(it ?: ghostUser).toString()");
                    return string;
                }
            }), (int)31, null) : null;
            if (addedLogins2 != null && removedLogins2 != null) {
                objectArray = new Object[]{addedLogins2, removedLogins2};
                String string2 = GithubBundle.message("pull.request.timeline.event.requested.review.and.removed.review.request", objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"pull.request.ti\u2026dedLogins, removedLogins)");
            } else if (addedLogins2 != null) {
                objectArray = new Object[]{addedLogins2};
                String string3 = GithubBundle.message("pull.request.timeline.event.requested.review", objectArray);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"pull.request.ti\u2026ted.review\", addedLogins)");
            } else if (removedLogins2 != null) {
                objectArray = new Object[]{removedLogins2};
                String string4 = GithubBundle.message("pull.request.timeline.event.removed.review.request", objectArray);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"pull.request.ti\u2026.request\", removedLogins)");
            } else {
                string = "";
            }
            return string;
        }

        static /* synthetic */ String reviewersText$default(SimpleEventComponentFactory simpleEventComponentFactory, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            return simpleEventComponentFactory.reviewersText(collection, collection2);
        }

        private final String labelsText(Collection<GHLabel> added, Collection<GHLabel> removed) {
            String string;
            Object[] objectArray;
            Collection<GHLabel> collection;
            Collection<GHLabel> it = collection = added;
            boolean bl = false;
            Collection<GHLabel> collection2 = !it.isEmpty() ? collection : null;
            String addedLabels2 = collection2 != null ? CollectionsKt.joinToString$default((Iterable)collection2, null, null, null, (int)0, null, (Function1)labelsText.addedLabels.2.INSTANCE, (int)31, null) : null;
            Object[] it2 = objectArray = removed;
            boolean bl2 = false;
            Object object = !it2.isEmpty() ? objectArray : null;
            String removedLabels2 = object != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), null, null, null, (int)0, null, (Function1)labelsText.removedLabels.2.INSTANCE, (int)31, null) : null;
            if (addedLabels2 != null && removedLabels2 != null) {
                objectArray = new Object[]{addedLabels2, removedLabels2};
                String string2 = GithubBundle.message("pull.request.timeline.event.labels.added.and.removed", objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"pull.request.ti\u2026dedLabels, removedLabels)");
            } else if (addedLabels2 != null) {
                objectArray = new Object[]{addedLabels2};
                String string3 = GithubBundle.message("pull.request.timeline.event.labels.added", objectArray);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"pull.request.ti\u2026bels.added\", addedLabels)");
            } else if (removedLabels2 != null) {
                objectArray = new Object[]{removedLabels2};
                String string4 = GithubBundle.message("pull.request.timeline.event.labels.removed", objectArray);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"pull.request.ti\u2026.removed\", removedLabels)");
            } else {
                string = "";
            }
            return string;
        }

        static /* synthetic */ String labelsText$default(SimpleEventComponentFactory simpleEventComponentFactory, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            return simpleEventComponentFactory.labelsText(collection, collection2);
        }

        private final String renameText(String oldName, String newName) {
            Object[] objectArray = new Object[]{oldName, newName};
            String string = GithubBundle.message("pull.request.timeline.renamed", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.ti\u2026named\", oldName, newName)");
            return string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$State;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "createComponent", "Ljavax/swing/JComponent;", "event", "intellij.vcs.github"})
    private final class StateEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.State> {
        @Override
        @NotNull
        public JComponent createComponent(@NotNull GHPRTimelineEvent.State event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return switch (WhenMappings.$EnumSwitchMapping$0[event.getNewState().ordinal()]) {
                case 1 -> {
                    GHPRTimelineEvent v0 = event;
                    String v1 = GithubBundle.message("pull.request.timeline.closed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"message(\"pull.request.timeline.closed\")");
                    yield this.eventItem(v0, StatusMessageType.SECONDARY_INFO, v1);
                }
                case 2 -> {
                    String v5;
                    GHPRTimelineEvent.State v3 = event instanceof GHPRTimelineMergedStateEvents ? ((GHPRTimelineMergedStateEvents)event).getLastStateEvent() : event;
                    Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRMergedEvent");
                    GHPRMergedEvent mergeEvent = (GHPRMergedEvent)v3;
                    if (mergeEvent.getCommit() != null) {
                        String v4 = HtmlChunk.link((String)mergeEvent.getCommit().getUrl(), (String)mergeEvent.getCommit().getAbbreviatedOid()).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"link(mergeEvent.commit.u\u2026bbreviatedOid).toString()");
                        String commitText = v4;
                        HtmlChunk ref = Companion.branchHTML(mergeEvent.getMergeRefName());
                        Object[] var7_5 = new Object[]{commitText, ref};
                        v5 = GithubBundle.message("pull.request.timeline.merged.commit", var7_5);
                    } else {
                        v5 = GithubBundle.message("pull.request.timeline.merged", new Object[0]);
                    }
                    String var4_6 = v5;
                    Intrinsics.checkNotNullExpressionValue((Object)var4_6, (String)"if (mergeEvent.commit !=\u2026request.timeline.merged\")");
                    String text = var4_6;
                    yield this.eventItem((GHPRTimelineEvent)event, StatusMessageType.SUCCESS, text);
                }
                case 3 -> {
                    GHPRTimelineEvent v6 = event;
                    String v7 = GithubBundle.message("pull.request.timeline.reopened", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"message(\"pull.request.timeline.reopened\")");
                    yield this.eventItem(v6, v7);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GHPullRequestState.values().length];
                try {
                    nArray[GHPullRequestState.CLOSED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GHPullRequestState.MERGED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GHPullRequestState.OPEN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

