/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.openapi.Disposable;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import git4idea.remote.GitRemoteUrlCoordinates;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010(\u001a\u00020)H'R\u001e\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u001e\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u001e\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001e\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000bR\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006*\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "Lcom/intellij/openapi/Disposable;", "collaborators", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "getCollaborators", "()Ljava/util/concurrent/CompletableFuture;", "defaultBranchName", "", "getDefaultBranchName", "()Ljava/lang/String;", "isFork", "", "()Z", "issuesAssignees", "getIssuesAssignees", "labels", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "getLabels", "potentialReviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "getPotentialReviewers", "remoteCoordinates", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "getRemoteCoordinates", "()Lgit4idea/remote/GitRemoteUrlCoordinates;", "repositoryCoordinates", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getRepositoryCoordinates", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "repositoryId", "getRepositoryId", "repositoryMapping", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "getRepositoryMapping", "()Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "teams", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "getTeams", "resetData", "", "intellij.vcs.github"})
public interface GHPRRepositoryDataService
extends Disposable {
    @NotNull
    public GitRemoteUrlCoordinates getRemoteCoordinates();

    @NotNull
    public GHRepositoryCoordinates getRepositoryCoordinates();

    @NotNull
    default public GHGitRepositoryMapping getRepositoryMapping() {
        return new GHGitRepositoryMapping(this.getRepositoryCoordinates(), this.getRemoteCoordinates());
    }

    @NotNull
    public String getRepositoryId();

    @Nullable
    public String getDefaultBranchName();

    public boolean isFork();

    @NotNull
    public CompletableFuture<List<GHUser>> getCollaborators();

    @NotNull
    public CompletableFuture<List<GHTeam>> getTeams();

    @NotNull
    public CompletableFuture<List<GHPullRequestRequestedReviewer>> getPotentialReviewers();

    @NotNull
    public CompletableFuture<List<GHUser>> getIssuesAssignees();

    @NotNull
    public CompletableFuture<List<GHLabel>> getLabels();

    @RequiresEdt
    public void resetData();
}

