/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.text.StringKt;
import git4idea.GitRemoteBranch;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCreationService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJF\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J*\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;)V", "baseRepo", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "repositoryId", "", "createPullRequest", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "baseBranch", "Lgit4idea/GitRemoteBranch;", "headRepo", "headBranch", "title", "description", "draft", "", "findPullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "getHeadRepoPrefix", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRCreationServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRCreationServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n288#2,2:63\n*S KotlinDebug\n*F\n+ 1 GHPRCreationServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationServiceImpl\n*L\n55#1:63,2\n*E\n"})
public final class GHPRCreationServiceImpl
implements GHPRCreationService {
    @NotNull
    private final ProgressManager progressManager;
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GHGitRepositoryMapping baseRepo;
    @NotNull
    private final String repositoryId;

    public GHPRCreationServiceImpl(@NotNull ProgressManager progressManager, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GHPRRepositoryDataService repositoryDataService) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        this.progressManager = progressManager;
        this.requestExecutor = requestExecutor;
        this.baseRepo = repositoryDataService.getRepositoryMapping();
        this.repositoryId = repositoryDataService.getRepositoryId();
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestShort> createPullRequest(@NotNull ProgressIndicator progressIndicator, @NotNull GitRemoteBranch baseBranch, @NotNull GHGitRepositoryMapping headRepo, @NotNull GitRemoteBranch headBranch, @NotNull String title, @NotNull String description, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)baseBranch, (String)"baseBranch");
        Intrinsics.checkNotNullParameter((Object)headRepo, (String)"headRepo");
        Intrinsics.checkNotNullParameter((Object)headBranch, (String)"headBranch");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestShort>(this, headRepo, title, headBranch, description, baseBranch, draft){
            final /* synthetic */ GHPRCreationServiceImpl this$0;
            final /* synthetic */ GHGitRepositoryMapping $headRepo;
            final /* synthetic */ String $title;
            final /* synthetic */ GitRemoteBranch $headBranch;
            final /* synthetic */ String $description;
            final /* synthetic */ GitRemoteBranch $baseBranch;
            final /* synthetic */ boolean $draft;
            {
                this.this$0 = $receiver;
                this.$headRepo = $headRepo;
                this.$title = $title;
                this.$headBranch = $headBranch;
                this.$description = $description;
                this.$baseBranch = $baseBranch;
                this.$draft = $draft;
                super(1);
            }

            @NotNull
            public final GHPullRequestShort invoke(@NotNull ProgressIndicator it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setText(GithubBundle.message("pull.request.create.process.title", new Object[0]));
                String headRepositoryPrefix = GHPRCreationServiceImpl.access$getHeadRepoPrefix(this.this$0, this.$headRepo);
                String p0 = string = this.$title;
                boolean bl = false;
                String string2 = !StringsKt.isBlank((CharSequence)p0) ? string : null;
                if (string2 == null) {
                    String string3 = this.$headBranch.getNameForRemoteOperations();
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"headBranch.nameForRemoteOperations");
                }
                String actualTitle = string2;
                String body2 = StringKt.nullize((String)this.$description, (boolean)true);
                GithubApiRequestExecutor githubApiRequestExecutor = GHPRCreationServiceImpl.access$getRequestExecutor$p(this.this$0);
                GHRepositoryCoordinates gHRepositoryCoordinates = GHPRCreationServiceImpl.access$getBaseRepo$p(this.this$0).getRepository();
                String string4 = GHPRCreationServiceImpl.access$getRepositoryId$p(this.this$0);
                String string5 = this.$baseBranch.getNameForRemoteOperations();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"baseBranch.nameForRemoteOperations");
                return (GHPullRequestShort)githubApiRequestExecutor.execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.INSTANCE.create(gHRepositoryCoordinates, string4, string5, headRepositoryPrefix + this.$headBranch.getNameForRemoteOperations(), actualTitle, body2, this.$draft));
            }
        });
    }

    @Override
    @Nullable
    public GHPRIdentifier findPullRequest(@NotNull ProgressIndicator progressIndicator, @NotNull GitRemoteBranch baseBranch, @NotNull GHGitRepositoryMapping headRepo, @NotNull GitRemoteBranch headBranch) {
        Object v4;
        block1: {
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            Intrinsics.checkNotNullParameter((Object)baseBranch, (String)"baseBranch");
            Intrinsics.checkNotNullParameter((Object)headRepo, (String)"headRepo");
            Intrinsics.checkNotNullParameter((Object)headBranch, (String)"headBranch");
            progressIndicator.setText(GithubBundle.message("pull.request.existing.process.title", new Object[0]));
            GHRepositoryCoordinates gHRepositoryCoordinates = this.baseRepo.getRepository();
            String string = baseBranch.getNameForRemoteOperations();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"baseBranch.nameForRemoteOperations");
            String string2 = headBranch.getNameForRemoteOperations();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"headBranch.nameForRemoteOperations");
            Iterable $this$firstOrNull$iv = ((GraphQLPagedResponseDataDTO)this.requestExecutor.execute(progressIndicator, (GithubApiRequest)GHGQLRequests.PullRequest.INSTANCE.findByBranches(gHRepositoryCoordinates, string, string2))).getNodes();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GHPullRequest it = (GHPullRequest)element$iv;
                boolean bl = false;
                Object object = it.getHeadRepository();
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((GHPullRequest.Repository)object).getOwner()) != null ? ((GHPullRequest.Owner)object).getLogin() : null), (Object)headRepo.getRepository().getRepositoryPath().getOwner())) continue;
                v4 = element$iv;
                break block1;
            }
            v4 = null;
        }
        return v4;
    }

    private final String getHeadRepoPrefix(GHGitRepositoryMapping headRepo) {
        return Intrinsics.areEqual((Object)this.baseRepo.getRepository(), (Object)headRepo.getRepository()) ? "" : headRepo.getRepository().getRepositoryPath().getOwner() + ":";
    }

    public static final /* synthetic */ String access$getHeadRepoPrefix(GHPRCreationServiceImpl $this, GHGitRepositoryMapping headRepo) {
        return $this.getHeadRepoPrefix(headRepo);
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRCreationServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GHGitRepositoryMapping access$getBaseRepo$p(GHPRCreationServiceImpl $this) {
        return $this.baseRepo;
    }

    public static final /* synthetic */ String access$getRepositoryId$p(GHPRCreationServiceImpl $this) {
        return $this.repositoryId;
    }
}

