/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.provider;

import com.google.common.graph.Graph;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.progress.ProgressIndicator;
import git4idea.changes.GitBranchComparisonResult;
import git4idea.changes.GitBranchComparisonResultImplKt;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesService;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bH\u0016J\u001e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\u001b\u0010\u001e\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u001f\u00a2\u0006\u0002\b H\u0016J\u0013\u0010!\u001a\r\u0012\u0004\u0012\u00020\u00100\u001f\u00a2\u0006\u0002\b H\u0016J\u001b\u0010\"\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00130\u00130\u001f\u00a2\u0006\u0002\b H\u0016J\u0014\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0$0\u001fH\u0016J(\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0016H\u0016J\b\u0010+\u001a\u00020\u0010H\u0016R&\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00130\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRChangesDataProviderImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRChangesDataProvider;", "Lcom/intellij/openapi/Disposable;", "changesService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "detailsData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProviderImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProviderImpl;)V", "apiCommitsRequestValue", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "Lcom/google/common/graph/Graph;", "baseBranchFetchRequestValue", "", "kotlin.jvm.PlatformType", "changesProviderValue", "Lgit4idea/changes/GitBranchComparisonResult;", "headBranchFetchRequestValue", "lastKnownBaseSha", "", "lastKnownHeadSha", "addChangesListener", "disposable", "listener", "Lkotlin/Function0;", "addCommitsListener", "dispose", "fetchBaseBranch", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/annotations/NotNull;", "fetchHeadBranch", "loadChanges", "loadCommitsFromApi", "", "loadPatchFromMergeBase", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "commitSha", "filePath", "reloadChanges", "intellij.vcs.github"})
public final class GHPRChangesDataProviderImpl
implements GHPRChangesDataProvider,
Disposable {
    @NotNull
    private final GHPRChangesService changesService;
    @NotNull
    private final GHPRIdentifier pullRequestId;
    @NotNull
    private final GHPRDetailsDataProviderImpl detailsData;
    @Nullable
    private String lastKnownBaseSha;
    @Nullable
    private String lastKnownHeadSha;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<Unit> baseBranchFetchRequestValue;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<Unit> headBranchFetchRequestValue;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<Pair<GHCommit, Graph<GHCommit>>> apiCommitsRequestValue;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<GitBranchComparisonResult> changesProviderValue;

    public GHPRChangesDataProviderImpl(@NotNull GHPRChangesService changesService, @NotNull GHPRIdentifier pullRequestId, @NotNull GHPRDetailsDataProviderImpl detailsData2) {
        Intrinsics.checkNotNullParameter((Object)changesService, (String)"changesService");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)detailsData2, (String)"detailsData");
        this.changesService = changesService;
        this.pullRequestId = pullRequestId;
        this.detailsData = detailsData2;
        this.detailsData.addDetailsLoadedListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                GHPullRequest gHPullRequest = detailsData.getLoadedDetails();
                if (gHPullRequest == null) {
                    return;
                }
                GHPullRequest details2 = gHPullRequest;
                if (!Intrinsics.areEqual((Object)details2.getBaseRefOid(), (Object)lastKnownBaseSha) || !Intrinsics.areEqual((Object)details2.getHeadRefOid(), (Object)lastKnownHeadSha)) {
                    lastKnownBaseSha = details2.getBaseRefOid();
                    lastKnownHeadSha = details2.getHeadRefOid();
                    this.reloadChanges();
                } else {
                    lastKnownBaseSha = details2.getBaseRefOid();
                    lastKnownHeadSha = details2.getHeadRefOid();
                }
            }
        }));
        this.baseBranchFetchRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<Unit>>(this){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<Unit> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CompletionStage completionStage = GHPRChangesDataProviderImpl.access$getDetailsData$p(this.this$0).loadDetails().thenCompose(arg_0 -> baseBranchFetchRequestValue.1.invoke$lambda$0((Function1)new Function1<GHPullRequest, CompletionStage<Unit>>(this.this$0, indicator){
                    final /* synthetic */ GHPRChangesDataProviderImpl this$0;
                    final /* synthetic */ ProgressIndicator $indicator;
                    {
                        this.this$0 = $receiver;
                        this.$indicator = $indicator;
                        super(1);
                    }

                    public final CompletionStage<Unit> invoke(GHPullRequest it) {
                        return GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0).fetchBranch(this.$indicator, it.getBaseRefName());
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"invoke");
                return completionStage;
            }

            private static final CompletionStage invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (CompletionStage)$tmp0.invoke(p0);
            }
        });
        this.headBranchFetchRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<Unit>>(this){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<Unit> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0).fetch(it, "refs/pull/" + GHPRChangesDataProviderImpl.access$getPullRequestId$p(this.this$0).getNumber() + "/head:");
            }
        });
        this.apiCommitsRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<Pair<? extends GHCommit, ? extends Graph<GHCommit>>>>(this){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<Pair<GHCommit, Graph<GHCommit>>> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0).loadCommitsFromApi(it, GHPRChangesDataProviderImpl.access$getPullRequestId$p(this.this$0));
            }
        });
        this.changesProviderValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<GitBranchComparisonResult>>(this){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<GitBranchComparisonResult> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Object object = GHPRChangesDataProviderImpl.access$getApiCommitsRequestValue$p(this.this$0).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apiCommitsRequestValue.value");
                CompletableFuture commitsRequest = (CompletableFuture)object;
                CompletionStage completionStage = GHPRChangesDataProviderImpl.access$getDetailsData$p(this.this$0).loadDetails().thenCompose(arg_0 -> changesProviderValue.1.invoke$lambda$0((Function1)new Function1<GHPullRequest, CompletionStage<GitBranchComparisonResult>>(this.this$0, indicator, (CompletableFuture<Pair<GHCommit, Graph<GHCommit>>>)commitsRequest){
                    final /* synthetic */ GHPRChangesDataProviderImpl this$0;
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ CompletableFuture<Pair<GHCommit, Graph<GHCommit>>> $commitsRequest;
                    {
                        this.this$0 = $receiver;
                        this.$indicator = $indicator;
                        this.$commitsRequest = $commitsRequest;
                        super(1);
                    }

                    public final CompletionStage<GitBranchComparisonResult> invoke(GHPullRequest it) {
                        return ((CompletableFuture)GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0).loadMergeBaseOid(this.$indicator, it.getBaseRefOid(), it.getHeadRefOid()).thenCombine(this.$commitsRequest, (arg_0, arg_1) -> changesProviderValue.1.invoke$lambda$0(changesProviderValue.1.INSTANCE, arg_0, arg_1))).thenCompose(arg_0 -> changesProviderValue.1.invoke$lambda$1((Function1)new Function1<Pair<? extends String, ? extends Pair<? extends GHCommit, ? extends Graph<GHCommit>>>, CompletionStage<GitBranchComparisonResult>>(this.this$0, this.$indicator, it){
                            final /* synthetic */ GHPRChangesDataProviderImpl this$0;
                            final /* synthetic */ ProgressIndicator $indicator;
                            final /* synthetic */ GHPullRequest $it;
                            {
                                this.this$0 = $receiver;
                                this.$indicator = $indicator;
                                this.$it = $it;
                                super(1);
                            }

                            public final CompletionStage<GitBranchComparisonResult> invoke(Pair<String, ? extends Pair<GHCommit, ? extends Graph<GHCommit>>> pair) {
                                String mergeBaseRef = (String)pair.component1();
                                Pair commits = (Pair)pair.component2();
                                GHPRChangesService gHPRChangesService = GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0);
                                String string = this.$it.getBaseRefOid();
                                Intrinsics.checkNotNullExpressionValue((Object)mergeBaseRef, (String)"mergeBaseRef");
                                String string2 = this.$it.getHeadRefOid();
                                Intrinsics.checkNotNullExpressionValue((Object)commits, (String)"commits");
                                return gHPRChangesService.createChangesProvider(this.$indicator, string, mergeBaseRef, string2, (Pair<GHCommit, ? extends Graph<GHCommit>>)commits);
                            }
                        }, arg_0));
                    }

                    private static final Pair invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Pair)$tmp0.invoke(p0, p1);
                    }

                    private static final CompletionStage invoke$lambda$1(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (CompletionStage)$tmp0.invoke(p0);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"invoke");
                return completionStage;
            }

            private static final CompletionStage invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (CompletionStage)$tmp0.invoke(p0);
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<GitBranchComparisonResult> loadChanges() {
        Object object = this.changesProviderValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"changesProviderValue.value");
        return (CompletableFuture)object;
    }

    @Override
    @NotNull
    public CompletableFuture<FilePatch> loadPatchFromMergeBase(@NotNull ProgressIndicator progressIndicator, @NotNull String commitSha, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)this.detailsData.loadDetails().thenCompose(arg_0 -> GHPRChangesDataProviderImpl.loadPatchFromMergeBase$lambda$0((Function1)new Function1<GHPullRequest, CompletionStage<String>>(this, progressIndicator){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                super(1);
            }

            public final CompletionStage<String> invoke(GHPullRequest it) {
                return GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0).loadMergeBaseOid(this.$progressIndicator, it.getBaseRefOid(), it.getHeadRefOid());
            }
        }, arg_0))).thenCompose(arg_0 -> GHPRChangesDataProviderImpl.loadPatchFromMergeBase$lambda$1((Function1)new Function1<String, CompletionStage<List<? extends FilePatch>>>(this, commitSha){
            final /* synthetic */ GHPRChangesDataProviderImpl this$0;
            final /* synthetic */ String $commitSha;
            {
                this.this$0 = $receiver;
                this.$commitSha = $commitSha;
                super(1);
            }

            public final CompletionStage<List<FilePatch>> invoke(String it) {
                GHPRChangesService gHPRChangesService = GHPRChangesDataProviderImpl.access$getChangesService$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return gHPRChangesService.loadPatch(it, this.$commitSha);
            }
        }, arg_0))).thenApplyAsync(arg_0 -> GHPRChangesDataProviderImpl.loadPatchFromMergeBase$lambda$2((Function1)new Function1<List<? extends FilePatch>, FilePatch>(filePath){
            final /* synthetic */ String $filePath;
            {
                this.$filePath = $filePath;
                super(1);
            }

            @Nullable
            public final FilePatch invoke(List<? extends FilePatch> it) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                    Iterable iterable = it;
                    String string = this.$filePath;
                    Iterable iterable2 = iterable;
                    for (T t : iterable2) {
                        FilePatch it2 = (FilePatch)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)GitBranchComparisonResultImplKt.getFilePath((FilePatch)it2), (Object)string)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
        }, arg_0), (Executor)ProcessIOExecutorService.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun loadPatchFr\u2026utorService.INSTANCE)\n  }");
        return completionStage;
    }

    @Override
    public void reloadChanges() {
        this.baseBranchFetchRequestValue.drop();
        this.headBranchFetchRequestValue.drop();
        this.apiCommitsRequestValue.drop();
        this.changesProviderValue.drop();
    }

    @Override
    public void addChangesListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.changesProviderValue.addDropEventListener(disposable, listener2);
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHCommit>> loadCommitsFromApi() {
        CompletionStage completionStage = ((CompletableFuture)this.apiCommitsRequestValue.getValue()).thenApply(arg_0 -> GHPRChangesDataProviderImpl.loadCommitsFromApi$lambda$3(loadCommitsFromApi.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"apiCommitsRequestValue.v\u2026(lastCommit).toList()\n  }");
        return completionStage;
    }

    @Override
    public void addCommitsListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.apiCommitsRequestValue.addDropEventListener(disposable, listener2);
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> fetchBaseBranch() {
        Object object = this.baseBranchFetchRequestValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"baseBranchFetchRequestValue.value");
        return (CompletableFuture)object;
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> fetchHeadBranch() {
        Object object = this.headBranchFetchRequestValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"headBranchFetchRequestValue.value");
        return (CompletableFuture)object;
    }

    public void dispose() {
    }

    private static final CompletionStage loadPatchFromMergeBase$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletionStage loadPatchFromMergeBase$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final FilePatch loadPatchFromMergeBase$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FilePatch)$tmp0.invoke(p0);
    }

    private static final List loadCommitsFromApi$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ GHPRChangesService access$getChangesService$p(GHPRChangesDataProviderImpl $this) {
        return $this.changesService;
    }

    public static final /* synthetic */ GHPRIdentifier access$getPullRequestId$p(GHPRChangesDataProviderImpl $this) {
        return $this.pullRequestId;
    }

    public static final /* synthetic */ LazyCancellableBackgroundProcessValue access$getApiCommitsRequestValue$p(GHPRChangesDataProviderImpl $this) {
        return $this.apiCommitsRequestValue;
    }
}

