/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.ui;

import com.intellij.collaboration.ui.codereview.diff.EditorComponentInlaysManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.SortedList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRDiffEditorReviewComponentsFactory;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPREditorReviewThreadsModel;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPREditorReviewThreadsController;", "", "threadMap", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPREditorReviewThreadsModel;", "componentFactory", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRDiffEditorReviewComponentsFactory;", "inlaysManager", "Lcom/intellij/collaboration/ui/codereview/diff/EditorComponentInlaysManager;", "(Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPREditorReviewThreadsModel;Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRDiffEditorReviewComponentsFactory;Lcom/intellij/collaboration/ui/codereview/diff/EditorComponentInlaysManager;)V", "inlayByThread", "", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "Lcom/intellij/openapi/Disposable;", "insertThread", "", "line", "", "thread", "intellij.vcs.github"})
public final class GHPREditorReviewThreadsController {
    @NotNull
    private final GHPRDiffEditorReviewComponentsFactory componentFactory;
    @NotNull
    private final EditorComponentInlaysManager inlaysManager;
    @NotNull
    private final Map<GHPRReviewThreadModel, Disposable> inlayByThread;

    public GHPREditorReviewThreadsController(@NotNull GHPREditorReviewThreadsModel threadMap, @NotNull GHPRDiffEditorReviewComponentsFactory componentFactory, @NotNull EditorComponentInlaysManager inlaysManager) {
        Intrinsics.checkNotNullParameter((Object)threadMap, (String)"threadMap");
        Intrinsics.checkNotNullParameter((Object)componentFactory, (String)"componentFactory");
        Intrinsics.checkNotNullParameter((Object)inlaysManager, (String)"inlaysManager");
        this.componentFactory = componentFactory;
        this.inlaysManager = inlaysManager;
        this.inlayByThread = new LinkedHashMap();
        block0: for (Map.Entry<Integer, SortedList<GHPRReviewThreadModel>> entry : threadMap.getModelsByLine().entrySet()) {
            int line = ((Number)entry.getKey()).intValue();
            SortedList<GHPRReviewThreadModel> threads = entry.getValue();
            for (GHPRReviewThreadModel thread : threads) {
                Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
                if (!this.insertThread(line, thread)) continue;
                continue block0;
            }
        }
        threadMap.addChangesListener(new GHPREditorReviewThreadsModel.ChangesListener(){

            @Override
            public void threadsAdded(int line, @NotNull List<? extends GHPRReviewThreadModel> threads) {
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                for (GHPRReviewThreadModel gHPRReviewThreadModel : threads) {
                    this.insertThread(line, gHPRReviewThreadModel);
                }
            }

            @Override
            public void threadsRemoved(int line, @NotNull List<? extends GHPRReviewThreadModel> threads) {
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                for (GHPRReviewThreadModel gHPRReviewThreadModel : threads) {
                    Disposable inlay;
                    if ((Disposable)inlayByThread.remove(gHPRReviewThreadModel) == null) continue;
                    Disposer.dispose((Disposable)inlay);
                }
            }
        });
    }

    private final boolean insertThread(int line, GHPRReviewThreadModel thread) {
        JComponent component2 = this.componentFactory.createThreadComponent(thread);
        Inlay inlay = EditorComponentInlaysManager.insertAfter$default((EditorComponentInlaysManager)this.inlaysManager, (int)line, (JComponent)component2, (int)0, null, (int)12, null);
        if (inlay == null) {
            return true;
        }
        Inlay inlay2 = inlay;
        this.inlayByThread.put(thread, (Disposable)inlay2);
        return false;
    }
}

