/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.vcs.changes.DiffPreview;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.action.GHPRShowDiffActionProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffPreview;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "prId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "filesManager", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;)V", "sourceId", "", "getSourceId", "()Ljava/lang/String;", "closePreview", "", "openPreview", "", "requestFocus", "updateDiffAction", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.github"})
public final class GHPRDiffPreview
implements DiffPreview {
    @Nullable
    private final GHPRIdentifier prId;
    @NotNull
    private final GHPRFilesManager filesManager;
    @NotNull
    private final String sourceId;

    public GHPRDiffPreview(@Nullable GHPRIdentifier prId, @NotNull GHPRFilesManager filesManager) {
        Intrinsics.checkNotNullParameter((Object)filesManager, (String)"filesManager");
        this.prId = prId;
        this.filesManager = filesManager;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.sourceId = string;
    }

    @NotNull
    public final String getSourceId() {
        return this.sourceId;
    }

    public void updateDiffAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GHPRShowDiffActionProvider.Companion.updateAvailability(event);
    }

    public boolean openPreview(boolean requestFocus) {
        if (this.prId == null) {
            this.filesManager.createAndOpenNewPRDiffPreviewFile(this.sourceId, false, requestFocus);
        } else {
            this.filesManager.createAndOpenDiffFile(this.prId, requestFocus);
        }
        return true;
    }

    public void closePreview() {
    }
}

