/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.AccountManagerBase;
import com.intellij.collaboration.auth.AccountsRepository;
import com.intellij.collaboration.auth.PasswordSafeCredentialsRepository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.accounts.GHPersistentAccounts;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0014J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "Lcom/intellij/collaboration/auth/AccountManagerBase;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "Lcom/intellij/openapi/Disposable;", "()V", "accountsRepository", "Lcom/intellij/collaboration/auth/AccountsRepository;", "credentialsRepository", "Lcom/intellij/collaboration/auth/PasswordSafeCredentialsRepository;", "dispose", "", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHAccountManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHAccountManager.kt\norg/jetbrains/plugins/github/authentication/accounts/GHAccountManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,33:1\n10#2:34\n43#3,3:35\n*S KotlinDebug\n*F\n+ 1 GHAccountManager.kt\norg/jetbrains/plugins/github/authentication/accounts/GHAccountManager\n*L\n20#1:34\n22#1:35,3\n*E\n"})
public final class GHAccountManager
extends AccountManagerBase<GithubAccount, String>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public GHAccountManager() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHAccountManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        super(logger);
    }

    @NotNull
    protected AccountsRepository<GithubAccount> accountsRepository() {
        boolean $i$f$service = false;
        Class<GHPersistentAccounts> serviceClass$iv = GHPersistentAccounts.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (AccountsRepository)object;
    }

    @NotNull
    protected PasswordSafeCredentialsRepository<GithubAccount, String> credentialsRepository() {
        return new PasswordSafeCredentialsRepository("GitHub", (PasswordSafeCredentialsRepository.CredentialsMapper)PasswordSafeCredentialsRepository.CredentialsMapper.Simple.INSTANCE);
    }

    public void dispose() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager$Companion;", "", "()V", "createAccount", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "name", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GithubAccount createAccount(@NotNull String name, @NotNull GithubServerPath server) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return new GithubAccount(name, server, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

