/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as b,html as u}from"lit";import{property as l,customElement as y,state as g}from"lit/decorators.js";import{classMap as v}from"lit/directives/class-map.js";import{ifDefined as w}from"lit/directives/if-defined.js";import{SeverityEnum as s}from"@typo3/backend/enum/severity.js";import C from"@typo3/backend/severity.js";import"@typo3/backend/element/icon-element.js";import{lll as A}from"@typo3/core/lit-helper.js";var c=function(h,i,t,n){var e=arguments.length,a=e<3?i:n===null?n=Object.getOwnPropertyDescriptor(i,t):n,o;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")a=Reflect.decorate(h,i,t,n);else for(var m=h.length-1;m>=0;m--)(o=h[m])&&(a=(e<3?o(a):e>3?o(i,t,a):o(i,t))||a);return e>3&&a&&Object.defineProperty(i,t,a),a};class d{static{this.duration=5}static{this.showClearAllButtonCount=2}static{this.totalNotifications=0}static{this.messageContainer=null}static{this.notificationList=null}static{this.clearAllButton=null}static notice(i,t,n,e){d.showMessage(i,t,s.notice,n,e)}static info(i,t,n,e){d.showMessage(i,t,s.info,n,e)}static success(i,t,n,e){d.showMessage(i,t,s.ok,n,e)}static warning(i,t,n,e){d.showMessage(i,t,s.warning,n,e)}static error(i,t,n=0,e){d.showMessage(i,t,s.error,n,e)}static showMessage(i,t,n=s.info,e,a=[]){typeof e>"u"&&(e=n===s.error?0:this.duration),(this.messageContainer===null||document.getElementById("alert-container")===null)&&(this.messageContainer=document.createElement("div"),this.messageContainer.setAttribute("id","alert-container"),this.notificationList=document.createElement("div"),this.notificationList.setAttribute("class","alert-list"),this.notificationList.setAttribute("tabindex","0"),this.messageContainer.appendChild(this.notificationList),this.clearAllButton=document.createElement("typo3-notification-clear-all"),this.containerItemVisibility(),this.messageContainer.prepend(this.clearAllButton),document.body.appendChild(this.messageContainer),document.addEventListener("typo3-notification-open",()=>{this.totalNotifications++,this.containerItemVisibility()}),document.addEventListener("typo3-notification-clear",()=>{this.totalNotifications>0&&this.totalNotifications--,this.containerItemVisibility()}));const o=document.createElement("typo3-notification-message");o.setAttribute("notification-id","notification-"+Math.random().toString(36).substring(2,6)),o.setAttribute("notification-title",i),t&&o.setAttribute("notification-message",t),o.setAttribute("notification-severity",n.toString()),o.setAttribute("notification-duration",e.toString()),o.actions=a,setTimeout(()=>{this.notificationList.querySelector("typo3-notification-message:last-child").scrollIntoView()},Number(e)),this.notificationList.appendChild(o)}static containerItemVisibility(){this.clearAllButton.hidden=this.totalNotifications<this.showClearAllButtonCount,this.messageContainer.hidden=this.totalNotifications===0}}let p=class extends b{async clearAll(){this.dispatchEvent(new CustomEvent("typo3-notification-clear-all",{bubbles:!0,composed:!0})),this.hidden=!0}createRenderRoot(){return this}render(){return u`<div><button @click=${()=>this.clearAll()} class="btn btn-default"><typo3-backend-icon identifier=actions-close size=small></typo3-backend-icon>${A("button.clearAll")||"Clear all"}</button></div>`}};c([l({type:String,attribute:"notification-container"})],p.prototype,"notificationId",void 0),p=c([y("typo3-notification-clear-all")],p);let r=class extends b{constructor(){super(...arguments),this.notificationSeverity=s.info,this.notificationDuration=0,this.actions=[],this.executingAction=-1}async firstUpdated(){document.addEventListener("typo3-notification-clear-all",async()=>{this.clear()});const i=new CustomEvent("typo3-notification-open",{bubbles:!0,composed:!0});this.dispatchEvent(i),await new Promise(t=>window.setTimeout(t,200)),await this.requestUpdate(),this.notificationDuration>0&&(await new Promise(t=>window.setTimeout(t,this.notificationDuration*1e3)),this.clear())}async clear(){this.dispatchEvent(new CustomEvent("typo3-notification-clear",{bubbles:!0,composed:!0})),this.addEventListener("typo3-notification-clear-finish",()=>{this.parentNode?.removeChild(this)});const i=()=>{this.dispatchEvent(new CustomEvent("typo3-notification-clear-finish"))};!window.matchMedia("(prefers-reduced-motion: reduce)").matches&&"animate"in this?(this.style.overflow="hidden",this.style.display="block",this.animate([{height:this.getBoundingClientRect().height+"px"},{height:0,opacity:0,marginTop:0}],{duration:400,easing:"cubic-bezier(.02, .01, .47, 1)"}).onfinish=i):i()}createRenderRoot(){return this}render(){const i=C.getCssClass(this.notificationSeverity);let t="";switch(this.notificationSeverity){case s.notice:t="actions-lightbulb";break;case s.ok:t="actions-check";break;case s.warning:t="actions-exclamation";break;case s.error:t="actions-close";break;case s.info:default:t="actions-info"}const n=(Math.random()+1).toString(36).substring(2);return u`<div id=${w(this.notificationId||void 0)} class="alert alert-${i} alert-dismissible" role=alertdialog aria-labelledby=alert-title-${n} aria-describedby=alert-message-${n}><button type=button class=close @click=${async()=>this.clear()}><span aria-hidden=true><typo3-backend-icon identifier=actions-close size=small></typo3-backend-icon></span> <span class=visually-hidden>Close</span></button><div class=alert-inner><div class=alert-icon><span class=icon-emphasized> <typo3-backend-icon identifier=${t} size=small></typo3-backend-icon> </span></div><div class=alert-content><div class=alert-title id=alert-title-${n}>${this.notificationTitle}</div><p class=alert-message id=alert-message-${n}>${this.notificationMessage?this.notificationMessage:""}</p></div></div>${this.actions.length===0?"":u`<div class=alert-actions>${this.actions.map((e,a)=>u`<a href=# title=${e.label} @click=${async o=>{o.preventDefault(),this.executingAction=a,await this.updateComplete,"action"in e&&await e.action.execute(o.currentTarget),this.clear()}} class=${v({executing:this.executingAction===a,disabled:this.executingAction>=0&&this.executingAction!==a})}>${e.label}</a>`)}</div>`}</div>`}};c([l({type:String,attribute:"notification-id"})],r.prototype,"notificationId",void 0),c([l({type:String,attribute:"notification-title"})],r.prototype,"notificationTitle",void 0),c([l({type:String,attribute:"notification-message"})],r.prototype,"notificationMessage",void 0),c([l({type:Number,attribute:"notification-severity"})],r.prototype,"notificationSeverity",void 0),c([l({type:Number,attribute:"notification-duration"})],r.prototype,"notificationDuration",void 0),c([l({type:Array,attribute:!1})],r.prototype,"actions",void 0),c([g()],r.prototype,"executingAction",void 0),r=c([y("typo3-notification-message")],r);let f;try{parent&&parent.window.TYPO3&&parent.window.TYPO3.Notification&&(f=parent.window.TYPO3.Notification),top&&top.TYPO3.Notification&&(f=top.TYPO3.Notification)}catch{}f||(f=d,typeof TYPO3<"u"&&(TYPO3.Notification=f));var E=f;export{p as ClearNotificationMessages,r as NotificationMessage,E as default};
