# Terminal.pm
#    - user interface
#
#  Copyright (C) 2000 Frank J. Tobin <ftobin@uiuc.edu>
#
#  This file is part of pgpenvelope
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, visit the following URL:
#  http://www.gnu.org/copyleft/gpl.html
#
#  $Id: Terminal.pm,v 1.3 2000/07/13 08:46:51 ftobin Exp $
#

package PGPEnvelope::Terminal;

use strict;
use English;
use Carp;
use Term::ReadKey;
use Term::ReadLine;

use Class::MakeMethods::Emulator::MethodMaker
  get_set         => [ qw( input_file     input_handle
			   output_file    output_handle
			   clear_string
			 ) ],
  object          => [ 'Term::ReadLine' =>  { slot      => 'readline_term',
					      comp_mthds => 'readline' } ],
  new_with_init   => 'new',
  new_hash_init   => 'hash_init';


sub init
{
    my ( $self, %args ) = @_;
    
    $self->hash_init( input_file   => '/dev/tty',
		      output_file  => '/dev/tty' );
    
    $self->hash_init( %args );
}


sub setup
{
    my ( $self ) = @_;
    
    my $input_file  = $self->input_file();
    my $output_file = $self->output_file();
    
    my $input_handle = IO::File->new( "<$input_file" )
      or die "error: cannot open $input_file for reading: $ERRNO";
    
    my $output_handle = IO::File->new( ">$output_file" )
      or die "error: cannot open $output_file for writing: $ERRNO";
    
    $self->hash_init( input_handle  => $input_handle,
		      output_handle => $output_handle,
		      clear_string  => scalar `clear` );
    
    $self->readline_term( Term::ReadLine->new( 'pgpenvelope' ) );
}



sub readkey
{
    my ( $self ) = @_;
    ReadMode 'cbreak',   $self->input_handle();
    my $key = ReadKey 0, $self->input_handle();
    ReadMode 'restore',  $self->input_handle();
    return $key;
}



sub wait_for_key
{
    my ( $self ) = @_;
    print "Press any key to continue.\n";
    $self->readkey();
}



sub cleanup
{
    my ( $self ) = @_;
    ReadMode 'normal', $self->input_handle();
}



sub clear_screen
{
    my ( $self ) = @_;
    print $self->clear_string();
}



1;
