/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.flexdock.dockbar.Dockbar;
import org.flexdock.dockbar.DockbarLabel;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.docking.Dockable;
import org.flexdock.plaf.common.border.SlideoutBorder;

public class StatusDockbar
extends Dockbar {
    private JPanel labelPanel = new JPanel();
    private JComponent statusBarComponent;

    public StatusDockbar(DockbarManager manager, int orientation) {
        super(manager, orientation);
        this.setOrientation(orientation);
        this.setLayout(new BorderLayout());
        super.add(this.labelPanel);
    }

    public void setStatusBarComponent(JComponent c) {
        this.statusBarComponent = c;
        this.add((Component)this.statusBarComponent, "South");
    }

    public JComponent getStatusBarComponent() {
        return this.statusBarComponent;
    }

    public Component add(Component c) {
        return this.labelPanel.add(c);
    }

    void undock(Dockable dockable) {
        DockbarLabel label = this.getLabel(dockable);
        this.labelPanel.remove(label);
        this.mDocks.remove(label);
        this.getParent().validate();
        this.repaint();
    }

    private void setOrientation(int orientation) {
        this.orientation = orientation = StatusDockbar.getValidOrientation(orientation);
        Border border = this.labelPanel.getBorder();
        if (border instanceof SlideoutBorder) {
            ((SlideoutBorder)border).setOrientation(orientation);
        }
        int boxConstraint = orientation == 1 || orientation == 3 ? 2 : 3;
        this.labelPanel.setLayout(new BoxLayout(this.labelPanel, boxConstraint));
    }

    public Dimension getPreferredSize() {
        if (this.statusBarComponent == null || this.statusBarComponent.getComponentCount() == 0) {
            if (this.mDocks.size() == 0) {
                return new Dimension(0, 0);
            }
            return this.labelPanel.getComponent(0).getPreferredSize();
        }
        if (this.labelPanel.getComponentCount() == 0) {
            return this.statusBarComponent.getPreferredSize();
        }
        DockbarLabel label = (DockbarLabel)this.labelPanel.getComponent(0);
        return new Dimension(label.getPreferredSize().width + this.statusBarComponent.getPreferredSize().width, label.getPreferredSize().height + this.statusBarComponent.getPreferredSize().height);
    }
}

