/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.io.util.AbstractDataInput;
import org.apache.cassandra.io.util.Memory;

public class MemoryInputStream
extends AbstractDataInput
implements DataInput {
    private final Memory mem;
    private int position = 0;

    public MemoryInputStream(Memory mem) {
        this.mem = mem;
    }

    @Override
    public int read() throws IOException {
        return this.mem.getByte(this.position++) & 0xFF;
    }

    @Override
    public void readFully(byte[] buffer, int offset, int count) throws IOException {
        this.mem.getBytes(this.position, buffer, offset, count);
        this.position += count;
    }

    @Override
    public void seek(long pos) {
        this.position = (int)pos;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long getPositionLimit() {
        return this.mem.size();
    }

    protected long length() {
        return this.mem.size();
    }

    @Override
    public void close() {
    }
}

