/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.fife.ui.FileExplorerTableModel;
import org.fife.ui.rtextfilechooser.FileChooserViewRendererFactory;
import org.fife.ui.rtextfilechooser.FileChooserViewTransferHandler;
import org.fife.ui.rtextfilechooser.MouseListener;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.RTextFileChooserView;
import org.fife.ui.rtextfilechooser.SelectionListener;
import org.fife.ui.rtextfilechooser.Utilities;

class DetailsView
extends JTable
implements RTextFileChooserView {
    private RTextFileChooser chooser;
    private MouseListener mouseListener;
    private ViewKeyListener keyListener;
    private SelectionListener selectionListener;
    private String readStr;
    private String writeStr;
    private String readWriteStr;
    private transient int displayCount;
    private transient Thread attributeThread;
    private static final int MAX_NAME_COLUMN_SIZE = 150;
    private static final Object ATTRIBUTES_LOCK = new Object();

    public DetailsView(RTextFileChooser chooser, String nameString, String sizeString, String typeString, String statusString, String lastModifiedString) {
        this.chooser = chooser;
        this.readStr = chooser.getString("Read");
        this.writeStr = chooser.getString("Write");
        this.readWriteStr = chooser.getString("ReadWrite");
        DetailsViewModel dvm = new DetailsViewModel(nameString, typeString, statusString, sizeString, lastModifiedString);
        FileExplorerTableModel sorter = new FileExplorerTableModel(dvm);
        this.setModel(sorter);
        sorter.setTable(this);
        this.fixKeyboardShortcuts();
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        int columnCount = this.getColumnCount();
        TableColumnModel columnModel = this.getColumnModel();
        TableCellRenderer renderer = FileChooserViewRendererFactory.createTableFileNameRenderer(chooser);
        this.getColumnModel().getColumn(0).setCellRenderer(renderer);
        for (int i = 1; i < columnCount; ++i) {
            renderer = FileChooserViewRendererFactory.createDefaultTableRenderer();
            columnModel.getColumn(i).setCellRenderer(renderer);
        }
        sorter.setColumnComparator(File.class, new FileComparator());
        ComponentOrientation orientation = chooser.getComponentOrientation();
        this.applyComponentOrientation(orientation);
        for (int i = 0; i < columnCount; ++i) {
            Component c = (Component)((Object)columnModel.getColumn(i).getCellRenderer());
            c.applyComponentOrientation(orientation);
        }
        this.mouseListener = new MouseListener(chooser);
        this.addMouseListener(this.mouseListener);
        this.keyListener = new ViewKeyListener();
        this.addKeyListener(this.keyListener);
        this.selectionListener = new SelectionListener(chooser);
        this.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.setTransferHandler(new FileChooserViewTransferHandler(this));
        this.setDragEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileAttributes(AttributeBatch batch) {
        Object object = ATTRIBUTES_LOCK;
        synchronized (object) {
            if (batch.getDisplayCount() != this.displayCount) {
                return;
            }
            FileExplorerTableModel tevm = (FileExplorerTableModel)this.getModel();
            DetailsViewModel model = (DetailsViewModel)tevm.getTableModel();
            for (int i = 0; i < batch.getSize(); ++i) {
                int row = batch.getStart() + i;
                FileAttributes attrs = batch.getAttributes(i);
                model.setValueAt(attrs.status, row, 2);
                FileSizeWrapper sizeWrapper = new FileSizeWrapper(attrs.size);
                model.setValueAt(sizeWrapper, row, 3);
                FileModifiedWrapper modWrapper = new FileModifiedWrapper(attrs.modified);
                model.setValueAt(modWrapper, row, 4);
            }
        }
    }

    public void clearDisplayedFiles() {
        ((DefaultTableModel)this.getModel()).setRowCount(0);
    }

    public void ensureFileIsVisible(File file) {
        int row = this.getRowFor(file);
        if (row != -1) {
            this.scrollRectToVisible(this.getCellRect(row, 0, true));
        }
    }

    private void fixKeyboardShortcuts() {
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0, false), "none");
        im.put(KeyStroke.getKeyStroke(113, 0), "none");
        im.put(KeyStroke.getKeyStroke("shift DELETE"), "none");
    }

    public Color getDefaultFileColor() {
        return this.getForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDisplayCount() {
        Object object = ATTRIBUTES_LOCK;
        synchronized (object) {
            return this.displayCount;
        }
    }

    public int getDisplayedFileCount() {
        return this.getRowCount();
    }

    public File getFileAtPoint(Point p) {
        int row = this.rowAtPoint(p);
        return row == -1 ? null : (File)this.getValueAt(row, 0);
    }

    public Dimension getPreferredScrollableViewportSize() {
        int rowHeight = this.getRowHeight();
        Dimension d = super.getPreferredScrollableViewportSize();
        if (d == null) {
            d = new Dimension(480, rowHeight * 8);
        } else {
            d.height = rowHeight * 8;
        }
        return d;
    }

    private final int getRowFor(File file) {
        TableColumnModel columnModel = this.getColumnModel();
        int column = columnModel.getColumn(0).getModelIndex();
        TableModel tableModel = this.getModel();
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            File temp = (File)tableModel.getValueAt(i, column);
            if (!file.equals(temp)) continue;
            return i;
        }
        return -1;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        return parent instanceof JViewport ? parent.getHeight() > this.getPreferredSize().height : false;
    }

    public File getSelectedFile() {
        int index = this.getSelectedRow();
        return index == -1 ? null : (File)this.getValueAt(index, 0);
    }

    public File[] getSelectedFiles() {
        int[] selectedRows = this.getSelectedRows();
        int num = selectedRows.length;
        Object[] objArray = new Object[num];
        int column = this.convertColumnIndexToView(0);
        for (int i = 0; i < num; ++i) {
            objArray[i] = this.getValueAt(selectedRows[i], column);
        }
        int length = objArray.length;
        File[] fileArray = new File[length];
        System.arraycopy(objArray, 0, fileArray, 0, length);
        return fileArray;
    }

    public String getToolTipText(MouseEvent e) {
        String tip = null;
        int row = this.rowAtPoint(e.getPoint());
        if (row == -1) {
            return null;
        }
        File file = (File)this.getModel().getValueAt(row, 0);
        if (file == null || file.isDirectory()) {
            return null;
        }
        tip = this.chooser.getToolTipFor(file);
        return tip;
    }

    private void initFileNameColumnSize() {
        TableModel model = this.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int maxWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
        int col = this.convertColumnIndexToView(0);
        column = this.getColumnModel().getColumn(col);
        comp = headerRenderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
        headerWidth = comp.getPreferredSize().width;
        TableCellRenderer renderer = this.getDefaultRenderer(model.getColumnClass(0));
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            comp = renderer.getTableCellRendererComponent(this, this.getValueAt(i, col), false, false, i, col);
            cellWidth = comp.getPreferredSize().width;
            if (maxWidth >= cellWidth) continue;
            maxWidth = cellWidth;
        }
        int width = Math.min(Math.max(headerWidth, maxWidth), 150);
        column.setPreferredWidth(width);
        column.setWidth(width);
    }

    public void removeAllListeners() {
        this.removeMouseListener(this.mouseListener);
        this.removeKeyListener(this.keyListener);
        this.getSelectionModel().removeListSelectionListener(this.selectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartAttributeThread(Vector files) {
        Object object = ATTRIBUTES_LOCK;
        synchronized (object) {
            ++this.displayCount;
            if (this.attributeThread != null) {
                this.attributeThread.interrupt();
            }
            this.attributeThread = new Thread(new AttributeRunnable(this.displayCount, files));
            this.attributeThread.start();
        }
    }

    public void selectFileAtPoint(Point p) {
        int row = this.rowAtPoint(p);
        this.setRowSelectionInterval(row, row);
    }

    public void setDisplayedFiles(Vector files) {
        DetailsViewModel tableModel = (DetailsViewModel)((FileExplorerTableModel)this.getModel()).getTableModel();
        tableModel.setContents(files);
        this.initFileNameColumnSize();
        this.restartAttributeThread(files);
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this.getSelectionModel().setSelectionMode(enabled ? 2 : 0);
    }

    public void setSelectedFiles(File[] files) {
        int num = files.length;
        if (num > 0) {
            int[] rows = new int[num];
            for (int i = 0; i < num; ++i) {
                rows[i] = this.getRowFor(files[i]);
                if (rows[i] == -1) continue;
                this.addRowSelectionInterval(rows[i], rows[i]);
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableCellRenderer r = tcm.getColumn(i).getCellRenderer();
            if (!(r instanceof JComponent)) continue;
            ((JComponent)((Object)r)).updateUI();
        }
    }

    private class ViewKeyListener
    extends KeyAdapter {
        private String typed;
        private long lastTime;

        private ViewKeyListener() {
        }

        private int getNextMatch(String text, int fromRow) {
            String fileName;
            Object value;
            int row;
            text = text.toUpperCase();
            FileExplorerTableModel model = (FileExplorerTableModel)DetailsView.this.getModel();
            for (row = fromRow; row < DetailsView.this.getRowCount(); ++row) {
                value = model.getValueAt(row, 0);
                fileName = value instanceof File ? ((File)value).getName() : value.toString();
                if (!(fileName = fileName.toUpperCase()).startsWith(text)) continue;
                return row;
            }
            for (row = 0; row < fromRow; ++row) {
                value = model.getValueAt(row, 0);
                fileName = value instanceof File ? ((File)value).getName() : value.toString();
                if (!(fileName = fileName.toUpperCase()).startsWith(text)) continue;
                return row;
            }
            return -1;
        }

        public void keyTyped(KeyEvent e) {
            int matchRow;
            FileExplorerTableModel model = (FileExplorerTableModel)DetailsView.this.getModel();
            if (model == null || model.getRowCount() == 0) {
                return;
            }
            long time = e.getWhen();
            this.typed = time < this.lastTime + 1000L ? (this.typed == null ? String.valueOf(e.getKeyChar()) : this.typed + e.getKeyChar()) : String.valueOf(e.getKeyChar());
            this.lastTime = time;
            int startRow = DetailsView.this.getSelectedRow();
            if (startRow == -1) {
                startRow = 0;
            }
            if ((matchRow = this.getNextMatch(this.typed, startRow)) != -1) {
                DetailsView.this.getSelectionModel().setSelectionInterval(matchRow, matchRow);
                DetailsView.this.ensureFileIsVisible(DetailsView.this.getSelectedFile());
            }
        }
    }

    private static class FileSizeWrapper
    implements Comparable {
        private long size;

        public FileSizeWrapper(long size) {
            this.size = size;
        }

        public int compareTo(Object o) {
            FileSizeWrapper w2 = (FileSizeWrapper)o;
            if (this.size == w2.size) {
                return 0;
            }
            return this.size < w2.size ? -1 : 1;
        }

        public String toString() {
            return this.size == -1L ? "" : Utilities.getFileSizeStringFor(this.size, true);
        }
    }

    private static class FileModifiedWrapper
    implements Comparable {
        private long modified;

        public FileModifiedWrapper(long modified) {
            this.modified = modified;
        }

        public int compareTo(Object o) {
            FileModifiedWrapper w2 = (FileModifiedWrapper)o;
            if (this.modified == w2.modified) {
                return 0;
            }
            return this.modified < w2.modified ? -1 : 1;
        }

        public String toString() {
            return this.modified == -1L ? "" : Utilities.getLastModifiedString(this.modified);
        }
    }

    private static class FileComparator
    implements Comparator {
        private FileComparator() {
        }

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            boolean f1IsDir = f1.isDirectory();
            boolean f2IsDir = f2.isDirectory();
            if (f1IsDir) {
                if (!f2IsDir) {
                    return -1;
                }
                return f1.compareTo(f2);
            }
            if (f2IsDir) {
                return 1;
            }
            return f1.compareTo(f2);
        }
    }

    private class FileAttributes {
        public String status;
        public long size;
        public long modified;

        public FileAttributes(File file) {
            this.size = file.isDirectory() ? -1L : file.length();
            boolean canRead = file.canRead();
            boolean canWrite = file.canWrite();
            this.status = canRead ? (canWrite ? DetailsView.this.readWriteStr : DetailsView.this.readStr) : (canWrite ? DetailsView.this.writeStr : null);
            this.modified = file.lastModified();
        }
    }

    class DetailsViewModel
    extends DefaultTableModel {
        Vector tempVector;

        public DetailsViewModel(String nameHeader, String typeHeader, String statusHeader, String sizeHeader, String lastModifiedHeader) {
            Object[] columnNames = new String[]{nameHeader, typeHeader, statusHeader, sizeHeader, lastModifiedHeader};
            this.setColumnIdentifiers(columnNames);
        }

        public void setContents(Vector data) {
            this.setRowCount(0);
            int dataSize = data.size();
            if (dataSize == 0) {
                return;
            }
            for (int i = 0; i < dataSize; ++i) {
                this.dataVector.add(this.getTableObjectVectorForFile((File)data.get(i)));
            }
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return File.class;
                }
                case 3: {
                    return FileSizeWrapper.class;
                }
                case 4: {
                    return FileModifiedWrapper.class;
                }
            }
            return Object.class;
        }

        private final Vector getTableObjectVectorForFile(File file) {
            String description = DetailsView.this.chooser.getDescription(file);
            Vector<Object> tempVector = new Vector<Object>(5);
            tempVector.add(0, file);
            tempVector.add(1, description);
            tempVector.add(2, null);
            tempVector.add(3, null);
            tempVector.add(4, null);
            return tempVector;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private class AttributeRunnable
    implements Runnable {
        private int displayCount;
        private Vector files;
        private static final int BATCH_SIZE = 15;

        public AttributeRunnable(int displayCount, Vector files) {
            this.displayCount = displayCount;
            this.files = files;
        }

        public void run() {
            int i = 0;
            while (i < this.files.size()) {
                if (this.shouldStop()) {
                    return;
                }
                int max = Math.min(i + 15, this.files.size());
                final AttributeBatch batch = new AttributeBatch(this.displayCount, i);
                for (int j = i; j < max; ++j) {
                    File file = (File)this.files.get(j);
                    batch.addAttributes(new FileAttributes(file));
                }
                if (this.shouldStop()) {
                    return;
                }
                i = max;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DetailsView.this.addFileAttributes(batch);
                    }
                });
            }
        }

        private boolean shouldStop() {
            return Thread.currentThread().isInterrupted() || this.displayCount != DetailsView.this.getDisplayCount();
        }
    }

    private class AttributeBatch {
        private int displayCount;
        private int start;
        private List fileAttrs;

        public AttributeBatch(int displayCount, int start) {
            this.displayCount = displayCount;
            this.start = start;
            this.fileAttrs = new ArrayList();
        }

        public void addAttributes(FileAttributes attrs) {
            this.fileAttrs.add(attrs);
        }

        public FileAttributes getAttributes(int index) {
            return (FileAttributes)this.fileAttrs.get(index);
        }

        public int getDisplayCount() {
            return this.displayCount;
        }

        public int getSize() {
            return this.fileAttrs.size();
        }

        public int getStart() {
            return this.start;
        }
    }
}

