/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class CopyObjectNameCommand
implements ICommand {
    private IObjectTreeAPI _api;
    private int _copyType;

    public CopyObjectNameCommand(IObjectTreeAPI api, int copyType) {
        if (api == null) {
            throw new IllegalArgumentException("IObjectTreeAPI == null");
        }
        if (copyType < 0 || copyType > 1) {
            throw new IllegalArgumentException("Invalid copyType of : " + copyType + " passed");
        }
        this._api = api;
        this._copyType = copyType;
    }

    @Override
    public void execute() {
        StringBuffer buf = new StringBuffer(100);
        IDatabaseObjectInfo[] dbObjs = this._api.getSelectedDatabaseObjects();
        for (int i = 0; i < dbObjs.length; ++i) {
            IDatabaseObjectInfo doi = dbObjs[i];
            String name = this._copyType == 0 ? doi.getSimpleName() : doi.getQualifiedName();
            buf.append(name).append(", ");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 2);
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection data = new StringSelection(buf.toString());
            clip.setContents(data, data);
        }
    }

    public static interface ICopyTypes {
        public static final int SIMPLE_NAME = 0;
        public static final int QUALIFIED_NAME = 1;
    }
}

