/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.persistence;

import java.io.File;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.KeyStoreType;
import org.wiztools.restclient.bean.SSLHostnameVerifier;
import org.wiztools.restclient.bean.SSLKeyStoreBean;
import org.wiztools.restclient.bean.SSLReq;
import org.wiztools.restclient.bean.SSLReqBean;
import org.wiztools.restclient.util.Util;

class XmlSslUtil {
    private XmlSslUtil() {
    }

    static Element getSslReq(SSLReq req) {
        Element e;
        Element eSsl = new Element("ssl");
        if (req.isTrustAllCerts()) {
            e = new Element("ignore-cert-errs");
            eSsl.appendChild(e);
        }
        e = new Element("hostname-verifier");
        e.appendChild(req.getHostNameVerifier().name());
        eSsl.appendChild(e);
        if (req.getKeyStore() != null) {
            e = new Element("keystore");
            e.addAttribute(new Attribute("type", req.getKeyStore().getType().name()));
            e.addAttribute(new Attribute("file", req.getKeyStore().getFile().getAbsolutePath()));
            e.addAttribute(new Attribute("password", Util.base64encode(new String(req.getKeyStore().getPassword()))));
            eSsl.appendChild(e);
        }
        if (req.getTrustStore() != null) {
            e = new Element("truststore");
            e.addAttribute(new Attribute("type", req.getTrustStore().getType().name()));
            e.addAttribute(new Attribute("file", req.getTrustStore().getFile().getAbsolutePath()));
            e.addAttribute(new Attribute("password", Util.base64encode(new String(req.getTrustStore().getPassword()))));
            eSsl.appendChild(e);
        }
        return eSsl;
    }

    static SSLReq getSslReq(Element eSsl) {
        SSLReqBean out = new SSLReqBean();
        Elements eChildren = eSsl.getChildElements();
        block13: for (int i = 0; i < eChildren.size(); ++i) {
            Element e = eChildren.get(i);
            String name = e.getLocalName();
            if (null == name) continue;
            switch (name) {
                case "trust-self-signed-cert": 
                case "ignore-cert-errs": {
                    out.setTrustAllCerts(true);
                    continue block13;
                }
                case "hostname-verifier": {
                    out.setHostNameVerifier(SSLHostnameVerifier.valueOf(e.getValue()));
                    continue block13;
                }
                case "keystore": {
                    SSLKeyStoreBean keyStore = new SSLKeyStoreBean();
                    String typeStr = e.getAttributeValue("type");
                    if (StringUtil.isNotEmpty(typeStr)) {
                        keyStore.setType(KeyStoreType.valueOf(typeStr));
                    }
                    keyStore.setFile(new File(e.getAttributeValue("file")));
                    keyStore.setPassword(Util.base64decode(e.getAttributeValue("password")).toCharArray());
                    out.setKeyStore(keyStore);
                    continue block13;
                }
                case "truststore": {
                    SSLKeyStoreBean trustStore = new SSLKeyStoreBean();
                    String typeStr = e.getAttributeValue("type");
                    if (StringUtil.isNotEmpty(typeStr)) {
                        trustStore.setType(KeyStoreType.valueOf(typeStr));
                    }
                    trustStore.setFile(new File(e.getAttributeValue("file")));
                    trustStore.setPassword(Util.base64decode(e.getAttributeValue("password")).toCharArray());
                    out.setTrustStore(trustStore);
                }
            }
        }
        return out;
    }
}

