/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import"bootstrap";import{AbstractInteractableModule as T}from"@typo3/install/module/abstract-interactable-module.js";import z from"@typo3/backend/notification.js";import g from"@typo3/core/ajax/ajax-request.js";import k from"@typo3/core/security-utility.js";import{FlashMessage as f}from"@typo3/install/renderable/flash-message.js";import{InfoBox as m}from"@typo3/install/renderable/info-box.js";import C from"@typo3/install/renderable/severity.js";import u from"@typo3/install/router.js";import w from"@typo3/core/event/regular-event.js";var t;(function(d){d.outputWizardsContainer=".t3js-upgradeWizards-wizards-output",d.outputMessagesContainer=".t3js-upgradeWizards-wizards-messages-output",d.outputDoneContainer=".t3js-upgradeWizards-done-output",d.wizardsBlockingAddsTemplate="#t3js-upgradeWizards-blocking-adds-template",d.wizardsBlockingAddsRows=".t3js-upgradeWizards-blocking-adds-rows",d.wizardsBlockingAddsExecute=".t3js-upgradeWizards-blocking-adds-execute",d.wizardsBlockingCharsetTemplate="#t3js-upgradeWizards-blocking-charset-template",d.wizardsBlockingCharsetFix=".t3js-upgradeWizards-blocking-charset-fix",d.wizardsDoneBodyTemplate="#t3js-upgradeWizards-done-body-template",d.wizardsDoneRows=".t3js-upgradeWizards-done-rows",d.wizardsDoneRowTemplate="#t3js-upgradeWizards-done-row-template",d.wizardsDoneRowMarkUndone=".t3js-upgradeWizards-done-markUndone",d.wizardsDoneRowTitle=".t3js-upgradeWizards-done-title",d.wizardsListTemplate="#t3js-upgradeWizards-list-template",d.wizardsListRows=".t3js-upgradeWizards-list-rows",d.wizardsListRowTemplate="#t3js-upgradeWizards-list-row-template",d.wizardsListRowTitle=".t3js-upgradeWizards-list-row-title",d.wizardsListRowExplanation=".t3js-upgradeWizards-list-row-explanation",d.wizardsListRowExecute=".t3js-upgradeWizards-list-row-execute",d.wizardsInputTemplate="#t3js-upgradeWizards-input",d.wizardsInputTitle=".t3js-upgradeWizards-input-title",d.wizardsInputDescription=".t3js-upgradeWizards-input-description",d.wizardsInputHtml=".t3js-upgradeWizards-input-html",d.wizardsInputPerform=".t3js-upgradeWizards-input-perform",d.wizardsInputAbort=".t3js-upgradeWizards-input-abort"})(t||(t={}));class y extends T{constructor(){super(),this.securityUtility=new k}static removeLoadingMessage(s){s.querySelectorAll("typo3-backend-progress-bar").forEach(r=>r.remove())}initialize(s){super.initialize(s),Promise.all([this.loadModuleFrameAgnostic("@typo3/install/renderable/info-box.js"),this.loadModuleFrameAgnostic("@typo3/install/renderable/flash-message.js")]).then(async()=>{await this.getData(),this.doneUpgrades()}),new w("click",(r,a)=>{a.disabled=!0,this.markUndone(a.dataset.identifier)}).delegateTo(s,t.wizardsDoneRowMarkUndone),new w("click",()=>{this.blockingUpgradesDatabaseCharsetFix()}).delegateTo(s,t.wizardsBlockingCharsetFix),new w("click",()=>{this.blockingUpgradesDatabaseAddsExecute()}).delegateTo(s,t.wizardsBlockingAddsExecute),new w("click",(r,a)=>{this.wizardInput(a.dataset.identifier,a.dataset.title)}).delegateTo(s,t.wizardsListRowExecute),new w("click",(r,a)=>{this.wizardExecute(a.dataset.identifier,a.dataset.title)}).delegateTo(s,t.wizardsInputPerform),new w("click",()=>{this.findInModal(t.outputWizardsContainer).innerHTML="",this.wizardsList()}).delegateTo(s,t.wizardsInputAbort)}getData(){const s=this.getModalBody(),r=this.findInModal(t.outputWizardsContainer);return new g(u.getUrl("upgradeWizardsGetData")).get({cache:"no-cache"}).then(async a=>{const e=await a.resolve();e.success===!0?(s.innerHTML=e.html,this.blockingUpgradesDatabaseCharsetTest()):z.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},a=>{u.handleAjaxError(a,r)})}blockingUpgradesDatabaseCharsetTest(){const s=this.getModalBody(),r=this.findInModal(t.outputWizardsContainer);this.renderProgressBar(r,{label:"Checking database charset..."}),new g(u.getUrl("upgradeWizardsBlockingDatabaseCharsetTest")).get({cache:"no-cache"}).then(async a=>{const e=await a.resolve();e.success===!0&&(e.needsUpdate===!0?(y.removeLoadingMessage(r),s.querySelector(t.outputWizardsContainer).appendChild(s.querySelector(t.wizardsBlockingCharsetTemplate).content.cloneNode(!0))):this.blockingUpgradesDatabaseAdds())},a=>{u.handleAjaxError(a,r)})}blockingUpgradesDatabaseCharsetFix(){const s=this.findInModal(t.outputWizardsContainer);this.renderProgressBar(s,{label:"Setting database charset to UTF-8..."}),new g(u.getUrl("upgradeWizardsBlockingDatabaseCharsetFix")).get({cache:"no-cache"}).then(async r=>{const a=await r.resolve();a.success===!0?Array.isArray(a.status)&&a.status.length>0&&a.status.forEach(e=>{s.append(m.create(e.severity,e.title,e.message))}):(y.removeLoadingMessage(s),s.append(f.create(C.error,"Something went wrong")))},r=>{u.handleAjaxError(r,s)})}blockingUpgradesDatabaseAdds(){const s=this.getModalBody(),r=this.findInModal(t.outputWizardsContainer);this.renderProgressBar(r,{label:"Check for missing mandatory database tables and fields..."}),new g(u.getUrl("upgradeWizardsBlockingDatabaseAdds")).get({cache:"no-cache"}).then(async a=>{const e=await a.resolve();if(e.success===!0)if(e.needsUpdate===!0){const i=s.querySelector(t.wizardsBlockingAddsTemplate).content.cloneNode(!0);typeof e.adds.tables=="object"&&e.adds.tables.forEach(o=>{const n="Table: "+this.securityUtility.encodeHtml(o.table);i.querySelector(t.wizardsBlockingAddsRows).append(n,document.createElement("br"))}),typeof e.adds.columns=="object"&&e.adds.columns.forEach(o=>{const n="Table: "+this.securityUtility.encodeHtml(o.table)+", Field: "+this.securityUtility.encodeHtml(o.field);i.querySelector(t.wizardsBlockingAddsRows).append(n,document.createElement("br"))}),typeof e.adds.indexes=="object"&&e.adds.indexes.forEach(o=>{const n="Table: "+this.securityUtility.encodeHtml(o.table)+", Index: "+this.securityUtility.encodeHtml(o.index);i.querySelector(t.wizardsBlockingAddsRows).append(n,document.createElement("br"))}),s.querySelector(t.outputWizardsContainer).appendChild(i)}else this.wizardsList();else y.removeLoadingMessage(r),z.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},a=>{u.handleAjaxError(a,r)})}blockingUpgradesDatabaseAddsExecute(){const s=this.findInModal(t.outputWizardsContainer);this.renderProgressBar(s,{label:"Adding database tables and fields..."}),new g(u.getUrl("upgradeWizardsBlockingDatabaseExecute")).get({cache:"no-cache"}).then(async r=>{const a=await r.resolve();if(Array.isArray(a.status)&&a.status.length>0&&a.status.forEach(e=>{s.append(m.create(e.severity,e.title,e.message))}),a.success===!0)this.wizardsList();else if(!Array.isArray(a.status)||a.status.length===0)s.append(f.create(C.error,"Something went wrong"));else{const e=document.createElement("div");e.classList.add("btn-toolbar","mt-3","mb-4");const i=document.createElement("button");i.classList.add("btn","btn-default"),i.innerText="Retry database migration";const o=document.createElement("button");o.classList.add("btn","btn-danger"),o.innerText="Proceed despite of errors",new w("click",()=>{this.blockingUpgradesDatabaseAddsExecute()}).bindTo(i),new w("click",()=>{e.remove(),this.wizardsList()}).bindTo(o),e.appendChild(i),e.appendChild(o),s.appendChild(e)}},r=>{u.handleAjaxError(r,s)})}wizardsList(){const s=this.getModalBody(),r=this.findInModal(t.outputWizardsContainer);this.renderProgressBar(r,{label:"Loading upgrade wizards..."}),new g(u.getUrl("upgradeWizardsList")).get({cache:"no-cache"}).then(async a=>{const e=await a.resolve();y.removeLoadingMessage(r);const i=s.querySelector(t.wizardsListTemplate).content.cloneNode(!0);if(e.success===!0){let o=0,n=0;Array.isArray(e.wizards)&&e.wizards.length>0&&(n=e.wizards.length,e.wizards.forEach(p=>{if(p.shouldRenderWizard===!0){const h=s.querySelector(t.wizardsListRowTemplate).content.cloneNode(!0);o=o+1,h.querySelector(t.wizardsListRowTitle).innerText=p.title,h.querySelector(t.wizardsListRowExplanation).innerText=p.explanation,h.querySelector(t.wizardsListRowExecute).setAttribute("data-identifier",p.identifier),h.querySelector(t.wizardsListRowExecute).setAttribute("data-title",p.title),i.querySelector(t.wizardsListRows).append(h)}}));let l=100;const c=i.querySelector("typo3-backend-progress-bar");o>0?l=Math.round((n-o)/e.wizards.length*100):c.severity=C.ok,c.value=l,c.label=`${n-o} of ${n} upgrade wizards executed`,s.querySelector(t.outputWizardsContainer).appendChild(i)}else z.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},a=>{u.handleAjaxError(a,r)})}wizardInput(s,r){const a=this.getModuleContent().dataset.upgradeWizardsInputToken,e=this.getModalBody(),i=this.findInModal(t.outputWizardsContainer);this.renderProgressBar(i,{label:'Loading "'+r+'"...'}),e.animate({scrollTop:e.scrollTop-Math.abs(e.querySelector(".t3js-upgrade-status-section").getBoundingClientRect().top)},250),new g(u.getUrl("upgradeWizardsInput")).post({install:{action:"upgradeWizardsInput",token:a,identifier:s}}).then(async o=>{const n=await o.resolve();i.innerHTML="";const l=e.querySelector(t.wizardsInputTemplate).content.cloneNode(!0);if(n.success===!0){Array.isArray(n.status)&&n.status.forEach(p=>{i.append(f.create(p.severity,p.title,p.message))}),n.userInput.wizardHtml.length>0&&(l.querySelector(t.wizardsInputHtml).innerHTML=n.userInput.wizardHtml),l.querySelector(t.wizardsInputTitle).innerText=n.userInput.title,l.querySelector(t.wizardsInputDescription).innerHTML=this.securityUtility.stripHtml(n.userInput.description).replace(/\n/g,"<br>");const c=l.querySelector(t.wizardsInputPerform);c.setAttribute("data-identifier",n.userInput.identifier),c.setAttribute("data-title",n.userInput.title)}e.querySelector(t.outputWizardsContainer).appendChild(l)},o=>{u.handleAjaxError(o,i)})}wizardExecute(s,r){const a=this.getModuleContent().dataset.upgradeWizardsExecuteToken,e=this.getModalBody(),i={"install[action]":"upgradeWizardsExecute","install[token]":a,"install[identifier]":s},o=new FormData(this.findInModal(t.outputWizardsContainer+" form"));for(const[c,p]of o)i[c]=p.toString();const n=this.findInModal(t.outputWizardsContainer),l=this.findInModal(t.outputMessagesContainer);this.renderProgressBar(n,{label:'Executing "'+r+'"...'}),new g(u.getUrl()).post(i).then(async c=>{const p=await c.resolve();if(l.replaceChildren(),p.success===!0){if(Array.isArray(p.status)){const h=[];p.status.forEach(b=>{h.push(m.create(b.severity,b.title,b.message))}),l.append(...h)}this.wizardsList(),e.querySelector(t.outputDoneContainer).innerHTML="",this.doneUpgrades()}else z.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},c=>{u.handleAjaxError(c,n)})}doneUpgrades(){const s=this.getModalBody(),r=s.querySelector(t.outputDoneContainer);this.renderProgressBar(r,{label:"Loading executed upgrade wizards..."}),new g(u.getUrl("upgradeWizardsDoneUpgrades")).get({cache:"no-cache"}).then(async a=>{const e=await a.resolve();if(y.removeLoadingMessage(r),e.success===!0){Array.isArray(e.status)&&e.status.length>0&&e.status.forEach(l=>{r.append(m.create(l.severity,l.title,l.message))});const i=s.querySelector(t.wizardsDoneBodyTemplate).content.cloneNode(!0),o=i.querySelector(t.wizardsDoneRows);let n=!1;Array.isArray(e.wizardsDone)&&e.wizardsDone.length>0&&e.wizardsDone.forEach(l=>{n=!0;const c=s.querySelector(t.wizardsDoneRowTemplate).content.cloneNode(!0);c.querySelector(t.wizardsDoneRowMarkUndone).setAttribute("data-identifier",l.identifier),c.querySelector(t.wizardsDoneRowTitle).innerText=l.title,o.appendChild(c)}),Array.isArray(e.rowUpdatersDone)&&e.rowUpdatersDone.length>0&&e.rowUpdatersDone.forEach(l=>{n=!0;const c=s.querySelector(t.wizardsDoneRowTemplate).content.cloneNode(!0);c.querySelector(t.wizardsDoneRowMarkUndone).setAttribute("data-identifier",l.identifier),c.querySelector(t.wizardsDoneRowTitle).innerText=l.title,o.appendChild(c)}),n&&s.querySelector(t.outputDoneContainer).appendChild(i)}else z.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},a=>{u.handleAjaxError(a,r)})}markUndone(s){const r=this.getModuleContent().dataset.upgradeWizardsMarkUndoneToken,a=this.getModalBody(),e=this.findInModal(t.outputMessagesContainer),i=this.findInModal(t.outputDoneContainer);this.renderProgressBar(i,{label:"Marking upgrade wizard as undone..."}),new g(u.getUrl()).post({install:{action:"upgradeWizardsMarkUndone",token:r,identifier:s}}).then(async o=>{const n=await o.resolve();e.replaceChildren(),i.replaceChildren(),a.querySelector(t.outputDoneContainer).replaceChildren(),n.success===!0&&Array.isArray(n.status)?n.status.forEach(l=>{z.success(l.title,l.message),this.doneUpgrades(),this.blockingUpgradesDatabaseCharsetTest()}):z.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")},o=>{u.handleAjaxError(o,i)})}}var x=new y;export{x as default};
