<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class VideoContentSearchDolphinFeatures extends \Google\Model
{
  /**
   * @var string
   */
  public $altQuery;
  /**
   * @var string
   */
  public $answer;
  /**
   * @var string
   */
  public $query;
  /**
   * @var string
   */
  public $timeMs;
  /**
   * @var string
   */
  public $title;
  /**
   * @var string
   */
  public $url;

  /**
   * @param string
   */
  public function setAltQuery($altQuery)
  {
    $this->altQuery = $altQuery;
  }
  /**
   * @return string
   */
  public function getAltQuery()
  {
    return $this->altQuery;
  }
  /**
   * @param string
   */
  public function setAnswer($answer)
  {
    $this->answer = $answer;
  }
  /**
   * @return string
   */
  public function getAnswer()
  {
    return $this->answer;
  }
  /**
   * @param string
   */
  public function setQuery($query)
  {
    $this->query = $query;
  }
  /**
   * @return string
   */
  public function getQuery()
  {
    return $this->query;
  }
  /**
   * @param string
   */
  public function setTimeMs($timeMs)
  {
    $this->timeMs = $timeMs;
  }
  /**
   * @return string
   */
  public function getTimeMs()
  {
    return $this->timeMs;
  }
  /**
   * @param string
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
  /**
   * @param string
   */
  public function setUrl($url)
  {
    $this->url = $url;
  }
  /**
   * @return string
   */
  public function getUrl()
  {
    return $this->url;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VideoContentSearchDolphinFeatures::class, 'Google_Service_Contentwarehouse_VideoContentSearchDolphinFeatures');
