/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import com.fasterxml.jackson.core.type.TypeReference;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import org.apache.kafka.trogdor.rest.CreateTaskRequest;
import org.apache.kafka.trogdor.rest.CreateTaskResponse;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.apache.kafka.trogdor.rest.StopTaskRequest;
import org.apache.kafka.trogdor.rest.StopTaskResponse;
import org.apache.kafka.trogdor.rest.TasksResponse;

public class CoordinatorClient {
    private final int maxTries;
    private final String target;

    public CoordinatorClient(int maxTries, String host, int port) {
        this(maxTries, String.format("%s:%d", host, port));
    }

    public CoordinatorClient(int maxTries, String target) {
        this.maxTries = maxTries;
        this.target = target;
    }

    public int maxTries() {
        return this.maxTries;
    }

    private String url(String suffix) {
        return String.format("http://%s%s", this.target, suffix);
    }

    public CoordinatorStatusResponse status() throws Exception {
        JsonRestServer.HttpResponse<CoordinatorStatusResponse> resp = JsonRestServer.httpRequest(this.url("/coordinator/status"), "GET", null, new TypeReference<CoordinatorStatusResponse>(){}, this.maxTries);
        return resp.body();
    }

    public CreateTaskResponse createTask(CreateTaskRequest request) throws Exception {
        JsonRestServer.HttpResponse<CreateTaskResponse> resp = JsonRestServer.httpRequest(this.url("/coordinator/task/create"), "POST", request, new TypeReference<CreateTaskResponse>(){}, this.maxTries);
        return resp.body();
    }

    public StopTaskResponse stopTask(StopTaskRequest request) throws Exception {
        JsonRestServer.HttpResponse<StopTaskResponse> resp = JsonRestServer.httpRequest(this.url("/coordinator/task/stop"), "PUT", request, new TypeReference<StopTaskResponse>(){}, this.maxTries);
        return resp.body();
    }

    public TasksResponse tasks() throws Exception {
        JsonRestServer.HttpResponse<TasksResponse> resp = JsonRestServer.httpRequest(this.url("/coordinator/tasks"), "GET", null, new TypeReference<TasksResponse>(){}, this.maxTries);
        return resp.body();
    }

    public void shutdown() throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.url("/coordinator/shutdown"), "PUT", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-coordinator-client").defaultHelp(true).description("The Trogdor fault injection coordinator client.");
        parser.addArgument(new String[]{"target"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("target").metavar(new String[]{"TARGET"}).help("A colon-separated host and port pair.  For example, example.com:8889");
        MutuallyExclusiveGroup actions = parser.addMutuallyExclusiveGroup();
        actions.addArgument(new String[]{"--status"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("status").help("Get coordinator status.");
        actions.addArgument(new String[]{"--show-tasks"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("show_tasks").help("Show coordinator tasks.");
        actions.addArgument(new String[]{"--create-task"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("create_task").metavar(new String[]{"TASK_SPEC_JSON"}).help("Create a new task from a task spec.");
        actions.addArgument(new String[]{"--stop-task"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("stop_task").metavar(new String[]{"TASK_ID"}).help("Stop a task.");
        actions.addArgument(new String[]{"--shutdown"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("shutdown").help("Trigger coordinator shutdown");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
        String target = res.getString("target");
        CoordinatorClient client = new CoordinatorClient(3, target);
        if (res.getBoolean("status").booleanValue()) {
            System.out.println("Got coordinator status: " + JsonUtil.toPrettyJsonString(client.status()));
        } else if (res.getBoolean("show_tasks").booleanValue()) {
            System.out.println("Got coordinator tasks: " + JsonUtil.toPrettyJsonString(client.tasks()));
        } else if (res.getString("create_task") != null) {
            client.createTask((CreateTaskRequest)JsonUtil.JSON_SERDE.readValue(res.getString("create_task"), CreateTaskRequest.class));
            System.out.println("Created task.");
        } else if (res.getString("stop_task") != null) {
            client.stopTask(new StopTaskRequest(res.getString("stop_task")));
            System.out.println("Created task.");
        } else if (res.getBoolean("shutdown").booleanValue()) {
            client.shutdown();
            System.out.println("Sent shutdown request.");
        } else {
            System.out.println("You must choose an action. Type --help for help.");
            Exit.exit((int)1);
        }
    }
}

