/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbUtil;

public class Dbt {
    private long private_dbobj_ = 0L;
    private byte[] data = null;
    private int offset = 0;
    private int size = 0;
    private int ulen = 0;
    private int dlen = 0;
    private int doff = 0;
    private int flags = 0;
    private boolean must_create_data = false;
    private static boolean big_endian;

    public Dbt(byte[] byArray) {
        this.init();
        this.data = byArray;
        if (byArray != null) {
            this.size = byArray.length;
        }
    }

    public Dbt(byte[] byArray, int n, int n2) {
        this.init();
        this.data = byArray;
        this.offset = n;
        this.size = n2;
    }

    public Dbt() {
        this.init();
    }

    protected native void finalize() throws Throwable;

    public byte[] get_data() {
        if (this.must_create_data) {
            this.data = this.create_data();
            this.must_create_data = false;
        }
        return this.data;
    }

    public void set_data(byte[] byArray) {
        this.data = byArray;
        this.must_create_data = false;
    }

    public int get_offset() {
        return this.offset;
    }

    public void set_offset(int n) {
        this.offset = n;
    }

    public int get_size() {
        return this.size;
    }

    public void set_size(int n) {
        this.size = n;
    }

    public int get_ulen() {
        return this.ulen;
    }

    public void set_ulen(int n) {
        this.ulen = n;
    }

    public int get_dlen() {
        return this.dlen;
    }

    public void set_dlen(int n) {
        this.dlen = n;
    }

    public int get_doff() {
        return this.doff;
    }

    public void set_doff(int n) {
        this.doff = n;
    }

    public int get_flags() {
        return this.flags;
    }

    public void set_flags(int n) {
        this.flags = n;
    }

    public void set_recno_key_data(int n) {
        if (this.data == null) {
            this.data = new byte[4];
            this.size = 4;
            this.offset = 0;
        }
        DbUtil.int2array(n, this.data, this.offset);
    }

    public int get_recno_key_data() {
        return DbUtil.array2int(this.data, this.offset);
    }

    void set_recno_key_from_buffer(byte[] byArray, int n) {
        this.data = byArray;
        this.offset = n;
        this.size = 4;
    }

    private native void init();

    private native byte[] create_data();

    private static native boolean is_big_endian();

    static {
        Db.load_db();
        big_endian = Dbt.is_big_endian();
    }
}

