/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.balancer.rules;

import javax.servlet.http.HttpServletRequest;
import org.apache.webapp.balancer.rules.BaseRule;

public class RequestAttributeRule
extends BaseRule {
    private String attributeName;
    private Object attributeValue;

    public void setAttributeName(String theAttributeName) {
        if (theAttributeName == null) {
            throw new IllegalArgumentException("attributeName cannot be null.");
        }
        this.attributeName = theAttributeName;
    }

    protected String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeValue(Object theAttributeValue) {
        this.attributeValue = theAttributeValue;
    }

    protected Object getAttributeValue() {
        return this.attributeValue;
    }

    public boolean matches(HttpServletRequest request) {
        Object actualAttributeValue = request.getAttribute(this.getAttributeName());
        if (actualAttributeValue == null) {
            return this.getAttributeValue() == null;
        }
        return actualAttributeValue.equals(this.getAttributeValue());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        buffer.append("Target attribute name: ");
        buffer.append(this.getAttributeName());
        buffer.append(" / ");
        buffer.append("Target attribute value: ");
        buffer.append(this.getAttributeValue());
        buffer.append(" / ");
        buffer.append("Redirect URL: ");
        buffer.append(this.getRedirectUrl());
        buffer.append("]");
        return buffer.toString();
    }
}

