/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.tokenattributes;

import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.Token;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.analysis.ko.tokenattributes.PartOfSpeechAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class PartOfSpeechAttributeImpl
extends AttributeImpl
implements PartOfSpeechAttribute,
Cloneable {
    private Token token;

    @Override
    public POS.Type getPOSType() {
        return this.token == null ? null : this.token.getPOSType();
    }

    @Override
    public POS.Tag getLeftPOS() {
        return this.token == null ? null : this.token.getLeftPOS();
    }

    @Override
    public POS.Tag getRightPOS() {
        return this.token == null ? null : this.token.getRightPOS();
    }

    @Override
    public Dictionary.Morpheme[] getMorphemes() {
        return this.token == null ? null : this.token.getMorphemes();
    }

    @Override
    public void setToken(Token token) {
        this.token = token;
    }

    public void clear() {
        this.token = null;
    }

    public void reflectWith(AttributeReflector reflector) {
        String posName = this.getPOSType() == null ? null : this.getPOSType().name();
        String rightPOS = this.getRightPOS() == null ? null : this.getRightPOS().name() + "(" + this.getRightPOS().description() + ")";
        String leftPOS = this.getLeftPOS() == null ? null : this.getLeftPOS().name() + "(" + this.getLeftPOS().description() + ")";
        reflector.reflect(PartOfSpeechAttribute.class, "posType", (Object)posName);
        reflector.reflect(PartOfSpeechAttribute.class, "leftPOS", leftPOS);
        reflector.reflect(PartOfSpeechAttribute.class, "rightPOS", (Object)rightPOS);
        reflector.reflect(PartOfSpeechAttribute.class, "morphemes", (Object)this.displayMorphemes(this.getMorphemes()));
    }

    private String displayMorphemes(Dictionary.Morpheme[] morphemes) {
        if (morphemes == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Dictionary.Morpheme morpheme : morphemes) {
            if (builder.length() > 0) {
                builder.append("+");
            }
            builder.append(morpheme.surfaceForm).append('/').append(morpheme.posTag.name()).append('(').append(morpheme.posTag.description()).append(')');
        }
        return builder.toString();
    }

    public void copyTo(AttributeImpl target) {
        PartOfSpeechAttribute t = (PartOfSpeechAttribute)target;
        t.setToken(this.token);
    }
}

