/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.QueryConsistencyException;

public class WriteFailureException
extends QueryConsistencyException {
    private final WriteType writeType;
    private final int failed;

    public WriteFailureException(ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed) {
        super(String.format("Cassandra failure during write query at consistency %s (%d responses were required but only %d replica responded, %d failed)", new Object[]{consistency, required, received, failed}), consistency, received, required);
        this.writeType = writeType;
        this.failed = failed;
    }

    private WriteFailureException(String msg, Throwable cause, ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed) {
        super(msg, cause, consistency, received, required);
        this.writeType = writeType;
        this.failed = failed;
    }

    public WriteType getWriteType() {
        return this.writeType;
    }

    public int getFailures() {
        return this.failed;
    }

    @Override
    public DriverException copy() {
        return new WriteFailureException(this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.getFailures());
    }
}

