/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalParam
extends GeneralVariable {
    private int parameterId;
    private Expression conversion = null;
    private int conversionEvaluationMode = -1;

    public void setParameterId(int id) {
        this.parameterId = id;
    }

    public int getParameterId() {
        return this.parameterId;
    }

    public void setConversion(Expression convertor) {
        this.conversion = convertor;
        if (convertor != null) {
            this.conversionEvaluationMode = ExpressionTool.eagerEvaluationMode(this.conversion);
        }
    }

    public Expression getConversion() {
        return this.conversion;
    }

    public int getConversionEvaluationMode() {
        return this.conversionEvaluationMode;
    }

    @Override
    public int getInstructionNameCode() {
        return 188;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        if (this.select != null && this.conversion != null) {
            return new PairIterator<Expression>(this.select, this.conversion);
        }
        if (this.select != null) {
            return new MonoIterator<Expression>(this.select);
        }
        if (this.conversion != null) {
            return new MonoIterator<Expression>(this.conversion);
        }
        List list = Collections.emptyList();
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.conversion == original) {
            this.conversion = replacement;
            found = true;
        }
        return found;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        int wasSupplied = context.useLocalParameter(this.parameterId, this.slotNumber, this.isTunnelParam());
        switch (wasSupplied) {
            case 2: {
                break;
            }
            case 1: {
                if (this.conversion == null) break;
                context.setLocalVariable(this.slotNumber, ExpressionTool.evaluate(this.conversion, this.conversionEvaluationMode, context, 10));
                break;
            }
            case 0: {
                if (this.isImplicitlyRequiredParam()) {
                    String name = "$" + this.getVariableQName().getDisplayName();
                    XPathException e = new XPathException("A value must be supplied for parameter " + name + " because " + "the default value is not a valid instance of the required type");
                    e.setXPathContext(context);
                    e.setErrorCode("XTDE0610");
                    throw e;
                }
                if (this.isRequiredParam()) {
                    String name = "$" + this.getVariableQName().getDisplayName();
                    XPathException e = new XPathException("No value supplied for required parameter " + name);
                    e.setXPathContext(context);
                    e.setErrorCode("XTDE0700");
                    throw e;
                }
                context.setLocalVariable(this.slotNumber, this.getSelectValue(context));
            }
        }
        return null;
    }

    @Override
    public IntegerValue[] getIntegerBoundsForVariable() {
        return null;
    }

    @Override
    public Sequence evaluateVariable(XPathContext c) {
        return c.evaluateLocalVariable(this.slotNumber);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("param");
        out.emitAttribute("name", this.variableQName.getDisplayName());
        if (this.select != null) {
            this.select.explain(out);
        }
        if (this.conversion != null) {
            Expression exp = this.conversion;
            out.startElement("conversion");
            exp.explain(out);
            out.endElement();
        }
        out.endElement();
    }
}

