/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.core.command.CreateContainerCmdImpl;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.NotNullSetter;
import com.intellij.docker.agent.fix.FixedHostConfig;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CreateContainerCmdConfigJsonReader {
    public CreateContainerCmdConfig readFromFile(File jsonFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        final CreateContainerCmdConfig result = (CreateContainerCmdConfig)((Object)mapper.readValue(jsonFile, CreateContainerCmdConfig.class));
        FixedCreateContainerCmdConfig tweaks = (FixedCreateContainerCmdConfig)((Object)mapper.readValue(jsonFile, FixedCreateContainerCmdConfig.class));
        new NotNullSetter<Bind[]>(){

            @Override
            protected void doSet(Bind[] value) {
                result.withBinds(value);
            }
        }.set((T[])new Bind[][]{tweaks.getBinds()});
        new NotNullSetter<String>(){

            @Override
            protected void doSet(String value) {
                result.withContainerIDFile(value);
            }
        }.set(tweaks.getContainerIDFile());
        List<ContainerNetwork.Ipam> ipams = Optional.ofNullable(tweaks.getAccessibleNetworkingConfig()).map(CreateContainerCmdImpl.NetworkingConfig::getEndpointsConfig).orElse(Collections.emptyMap()).values().stream().filter(Objects::nonNull).map(ContainerNetwork::getIpamConfig).collect(Collectors.toList());
        String errorMessage = "Can't process json file at " + jsonFile + ", found multiple ";
        String ipv4 = CreateContainerCmdConfigJsonReader.requireOneValue(ipams, errorMessage + " Ipv4Address's", ContainerNetwork.Ipam::getIpv4Address);
        String ipv6 = CreateContainerCmdConfigJsonReader.requireOneValue(ipams, errorMessage + " Ipv6Address's", ContainerNetwork.Ipam::getIpv6Address);
        if (ipv4 != null && result.getIpv4Address() == null) {
            result.withIpv4Address(ipv4);
        }
        if (ipv6 != null && result.getIpv6Address() == null) {
            result.withIpv6Address(ipv6);
        }
        return result;
    }

    private static <T> T requireOneValue(List<ContainerNetwork.Ipam> ipams, String error, Function<ContainerNetwork.Ipam, T> getter) throws IOException {
        List all = ipams.stream().map(getter).filter(Objects::nonNull).collect(Collectors.toList());
        if (all.size() > 1) {
            throw new IOException(error + ": " + all);
        }
        return all.isEmpty() ? null : (T)all.get(0);
    }

    private static class FixedCreateContainerCmdConfig
    extends CreateContainerCmdConfig {
        @JsonProperty(value="NetworkingConfig")
        private CreateContainerCmdImpl.NetworkingConfig myAccessibleNetworkingConfig;
        @JsonProperty(value="HostConfig")
        private final FixedHostConfig myFixedHostConfig = new FixedHostConfig();

        private FixedCreateContainerCmdConfig() {
        }

        public Bind[] getBinds() {
            return this.myFixedHostConfig.getBinds();
        }

        public CreateContainerCmd withBinds(Bind ... binds) {
            super.withBinds(binds);
            this.myFixedHostConfig.setBinds(binds);
            return this;
        }

        @Override
        public String getContainerIDFile() {
            return this.myFixedHostConfig.getContainerIDFile();
        }

        public CreateContainerCmdImpl.NetworkingConfig getAccessibleNetworkingConfig() {
            return this.myAccessibleNetworkingConfig;
        }
    }
}

