/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.InternalPromiseUtil;

public interface Promise<T> {
    @NotNull
    public static <T> Promise<T> resolve(@Nullable T result2) {
        if (result2 == null) {
            Promise promise = (Promise)InternalPromiseUtil.FULFILLED_PROMISE.getValue();
            if (promise == null) {
                Promise.$$$reportNull$$$0(0);
            }
            return promise;
        }
        DonePromise<T> donePromise = new DonePromise<T>(InternalPromiseUtil.PromiseValue.createFulfilled(result2));
        if (donePromise == null) {
            Promise.$$$reportNull$$$0(1);
        }
        return donePromise;
    }

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> var1);

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> var1);

    @NotNull
    public Promise<T> onSuccess(@NotNull java.util.function.Consumer<? super T> var1);

    @Deprecated
    @NotNull
    default public Promise<T> done(@NotNull Consumer<? super T> done2) {
        if (done2 == null) {
            Promise.$$$reportNull$$$0(2);
        }
        Promise<Object> promise = this.onSuccess(it -> {
            if (done2 == null) {
                Promise.$$$reportNull$$$0(10);
            }
            done2.consume(it);
        });
        if (promise == null) {
            Promise.$$$reportNull$$$0(3);
        }
        return promise;
    }

    @NotNull
    public Promise<T> onError(@NotNull java.util.function.Consumer<Throwable> var1);

    @Deprecated
    @NotNull
    default public Promise<T> rejected(@NotNull Consumer<Throwable> rejected2) {
        if (rejected2 == null) {
            Promise.$$$reportNull$$$0(4);
        }
        Promise<T> promise = this.onError(it -> {
            if (rejected2 == null) {
                Promise.$$$reportNull$$$0(9);
            }
            rejected2.consume(it);
        });
        if (promise == null) {
            Promise.$$$reportNull$$$0(5);
        }
        return promise;
    }

    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> var1);

    @NotNull
    public Promise<T> onProcessed(@NotNull java.util.function.Consumer<? super T> var1);

    @Deprecated
    @NotNull
    default public Promise<T> processed(@NotNull Consumer<? super T> action) {
        if (action == null) {
            Promise.$$$reportNull$$$0(6);
        }
        Promise<Object> promise = this.onProcessed(it -> {
            if (action == null) {
                Promise.$$$reportNull$$$0(8);
            }
            action.consume(it);
        });
        if (promise == null) {
            Promise.$$$reportNull$$$0(7);
        }
        return promise;
    }

    @NotNull
    public State getState();

    @Nullable
    public T blockingGet(int var1, @NotNull TimeUnit var2) throws TimeoutException, ExecutionException;

    @Nullable
    default public T blockingGet(int timeout) throws TimeoutException, ExecutionException {
        return this.blockingGet(timeout, TimeUnit.MILLISECONDS);
    }

    default public boolean isSucceeded() {
        return this.getState() == State.SUCCEEDED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/concurrency/Promise";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "done";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rejected";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/concurrency/Promise";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "done";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rejected";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processed";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "done";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rejected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processed$2";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$rejected$1";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$done$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum State {
        PENDING,
        SUCCEEDED,
        REJECTED;

    }
}

