/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSDocReferenceSet
extends JSReferenceSet {
    private static final String GLOBAL_PREFIX = "global#";
    private final boolean myAddEventPrefix;
    private final boolean myAddModulePrefix;

    public JSDocReferenceSet(@NotNull PsiElement element, String text, int offset, boolean soft) {
        if (element == null) {
            JSDocReferenceSet.$$$reportNull$$$0(0);
        }
        this(element, text, offset, soft, false, false);
    }

    public JSDocReferenceSet(@NotNull PsiElement element, String text, int offset, boolean soft, boolean addEventPrefix, boolean addModulePrefix) {
        if (element == null) {
            JSDocReferenceSet.$$$reportNull$$$0(1);
        }
        super(element, soft);
        this.myAddEventPrefix = addEventPrefix;
        this.myAddModulePrefix = addModulePrefix;
        this.myReferenceText = text;
        this.myOffset = offset;
        this.myReferences = this.reparse(text, offset);
    }

    @Override
    protected PsiReference[] reparse(String value, int offset) {
        if (value.startsWith(GLOBAL_PREFIX)) {
            value = value.substring(GLOBAL_PREFIX.length());
            offset += GLOBAL_PREFIX.length();
            this.myOnlyDefaultPackage = true;
        }
        ArrayList<JSDocReference> refs = new ArrayList<JSDocReference>(1);
        int dotPos = -1;
        int lastPos = 0;
        int lastLength = -1;
        while (dotPos < value.length()) {
            int startOffset;
            int nextDotPos;
            if (dotPos == -1) {
                if (value.length() > 0 && StringUtil.containsChar((String)".#~", (char)value.charAt(0))) {
                    ++dotPos;
                }
            } else if (!StringUtil.containsChar((String)".#~", (char)value.charAt(dotPos))) {
                return PsiReference.EMPTY_ARRAY;
            }
            if ((nextDotPos = JSDocumentationUtils.findNextNamepathSeparator(value, startOffset = dotPos + 1)) == -1) break;
            if (lastLength > 0) {
                refs.add(new JSDocReference(this, value.substring(lastPos, lastPos + lastLength), TextRange.from((int)(offset + lastPos), (int)lastLength), false));
            }
            lastPos = startOffset;
            lastLength = nextDotPos - startOffset;
            dotPos = nextDotPos;
        }
        if (lastLength > 0) {
            String s = value.substring(lastPos, lastPos + lastLength);
            int index = 0;
            boolean isMethodRef = lastPos > 0 && value.charAt(lastPos - 1) == '#';
            TextRange range = TextRange.from((int)(offset + lastPos + index), (int)s.length());
            if (this.myAddEventPrefix && !s.startsWith("event:")) {
                s = "event:" + s;
            }
            if (this.myAddModulePrefix && !s.startsWith("module:")) {
                s = "module:" + s;
            }
            refs.add(new JSDocReference(this, s, range, isMethodRef));
        }
        return refs.size() > 0 ? refs.toArray(PsiReference.EMPTY_ARRAY) : PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReferenceSet", "<init>"));
    }
}

