/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLookupElementInsertHandler
extends JSInsertHandler {
    private final boolean myInsertAsIndexer;
    @Nullable
    private final Runnable myInsertHandlerAction;
    private boolean myForceQualify = false;

    public JSLookupElementInsertHandler(boolean insertAsIndexer, @Nullable Runnable insertHandlerAction) {
        this.myInsertAsIndexer = insertAsIndexer;
        this.myInsertHandlerAction = insertHandlerAction;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        IElementType elementType;
        Editor editor;
        int offset;
        PsiElement element;
        Object object;
        if (context == null) {
            JSLookupElementInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            JSLookupElementInsertHandler.$$$reportNull$$$0(1);
        }
        if (!((object = item.getObject()) instanceof PsiElement)) {
            super.handleInsert(context, item);
            return;
        }
        PsiFile file2 = context.getFile();
        boolean doQualify = false;
        String packageName = null;
        if (JSUtils.isPrivateSharpItem((PsiElement)object) && (element = file2.findElementAt(offset = (editor = context.getEditor()).getCaretModel().getOffset() - 1)) != null && (element = element.getPrevSibling()) != null && (elementType = element.getNode().getElementType()) == JSTokenTypes.DOT) {
            editor.getDocument().insertString(element.getTextOffset() + 1, (CharSequence)"#");
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        }
        if (this.myForceQualify) {
            String qName;
            PsiElement element2 = (PsiElement)object;
            PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)element2, (PsiFile)file2);
            if (originalElement != null) {
                element2 = originalElement;
            }
            String string = qName = element2 instanceof JSPsiElementBase ? ((JSPsiElementBase)element2).getQualifiedName() : null;
            if (qName != null) {
                packageName = StringUtil.getPackageName((String)qName);
                doQualify = !packageName.isEmpty();
            }
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        super.handleInsert(context, item);
        if (doQualify) {
            editor = context.getEditor();
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
            PsiReference ref = file2.findReferenceAt(editor.getCaretModel().getOffset() - 1);
            if (ref != null) {
                TextRange refRange = ref.getRangeInElement();
                TextRange elementRange = ref.getElement().getTextRange();
                editor.getDocument().insertString(elementRange.getStartOffset() + refRange.getStartOffset(), (CharSequence)(packageName + "."));
            }
        }
        if (this.myInsertAsIndexer) {
            editor = context.getEditor();
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
            PsiElement el = file2.findElementAt(editor.getCaretModel().getOffset() - 1);
            if (el != null) {
                ASTNode node = el.getNode();
                if (node.getElementType() == JSTokenTypes.RBRACKET) {
                    JSExpression index;
                    PsiElement parent = el.getParent();
                    if (parent instanceof JSIndexedPropertyAccessExpression && (index = ((JSIndexedPropertyAccessExpression)parent).getIndexExpression()) != null) {
                        editor.getDocument().deleteString(index.getTextOffset() - 2, index.getTextOffset() - 1);
                    }
                } else {
                    String text;
                    TextRange range = el.getTextRange();
                    int startDotOffset = range.getStartOffset() - 1;
                    int endDotOffset = range.getStartOffset();
                    String string = text = endDotOffset > startDotOffset ? editor.getDocument().getText(new TextRange(startDotOffset, endDotOffset)) : "";
                    if (!".".equals(text) && node.getElementType() == JSTokenTypes.NUMERIC_LITERAL && node.getText().startsWith(".")) {
                        startDotOffset = range.getStartOffset();
                        endDotOffset = range.getStartOffset() + 1;
                    }
                    editor.getDocument().replaceString(startDotOffset, endDotOffset, (CharSequence)"[");
                    int offset2 = range.getEndOffset();
                    editor.getDocument().insertString(offset2, (CharSequence)"]");
                    editor.getCaretModel().moveToOffset(offset2 + 1);
                }
            }
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
            super.handleInsert(context, item);
        }
        if (this.myInsertHandlerAction != null) {
            this.myInsertHandlerAction.run();
        }
    }

    public void setForceQualify(boolean forceQualify) {
        this.myForceQualify = forceQualify;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/completion/JSLookupElementInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

