/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.references;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.resolve.StylesheetFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.extensions.compass.ConfigureCompassQuickFix;
import org.jetbrains.plugins.sass.psi.SASSFile;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;

public class SassScssImportReference
extends StylesheetFileReference {
    @NonNls
    protected static final String SCSS_EXT = "scss";
    @NonNls
    protected static final String SASS_EXT = "sass";
    @NonNls
    protected static final String CSS_EXT = "css";
    private static final Joiner EXTENSIONS_JOINER = Joiner.on((String)".");
    @NonNls
    private static final String EMPTY_STRING = "";
    private static final String COMPASS_IMPORT = "compass";

    public LocalQuickFix[] getQuickFixes() {
        LocalQuickFix compassQuickFix;
        Object[] quickFixes = super.getQuickFixes();
        FileReference firstReference = this.getFileReferenceSet().getReference(0);
        if (COMPASS_IMPORT.equals(firstReference.getText()) && firstReference.resolve() == null && (compassQuickFix = this.getCompassQuickFix()) != null) {
            LocalQuickFix[] localQuickFixArray;
            if (quickFixes != null) {
                localQuickFixArray = (LocalQuickFix[])ArrayUtil.prepend((Object)compassQuickFix, (Object[])quickFixes);
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = compassQuickFix;
            }
            return localQuickFixArray;
        }
        return quickFixes;
    }

    @Nullable
    private LocalQuickFix getCompassQuickFix() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        return module != null ? new ConfigureCompassQuickFix(module, this.getElement()) : null;
    }

    public SassScssImportReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            SassScssImportReference.$$$reportNull$$$0(0);
        }
        super(fileReferenceSet, range, index, text);
    }

    @NotNull
    public String getFileNameToCreate() {
        String extension;
        LanguageFileType fileType;
        Language language;
        String result = super.getFileNameToCreate();
        if (!this.isLast()) {
            String string = result;
            if (string == null) {
                SassScssImportReference.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (!SassScssImportReference.endsWithExtensions(result, SCSS_EXT, new String[0]) && !SassScssImportReference.endsWithExtensions(result, SASS_EXT, new String[0]) && !SassScssImportReference.endsWithExtensions(result, CSS_EXT, new String[0]) && (language = CssPsiUtil.getStylesheetLanguage((PsiElement)this.getElement())) != null && (fileType = language.getAssociatedFileType()) != null && StringUtil.isNotEmpty((String)(extension = fileType.getDefaultExtension()))) {
            result = result + "." + extension;
        }
        if (this.partialSupported(result) && !result.startsWith("_")) {
            String string = "_" + result;
            if (string == null) {
                SassScssImportReference.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = result;
        if (string == null) {
            SassScssImportReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected Object createLookupItem(PsiElement candidate) {
        if (this.partialSupported(candidate)) {
            PsiFile psiFile = (PsiFile)candidate;
            LookupElementBuilder fileLookupItem = FileInfoManager.getFileLookupItem((PsiElement)psiFile, (String)this.createImportTextForFileName(psiFile.getName()), (Icon)psiFile.getIcon(0));
            return fileLookupItem.withTypeText(psiFile.getName(), true);
        }
        return super.createLookupItem(candidate);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            SassScssImportReference.$$$reportNull$$$0(4);
        }
        try {
            return super.handleElementRename(this.createImportTextForFileName(newElementName));
        }
        catch (StringIndexOutOfBoundsException e) {
            Logger.getInstance(SassScssImportReference.class).error("Cannot rebind Sass/SCSS import reference.\nnew element name: " + newElementName + ";\nelement text: " + this.getElement().getText() + ";\nreference range: " + this.getRangeInElement() + ";\nreference set start: " + this.getFileReferenceSet().getStartInElement() + ";\nreference path: " + this.getFileReferenceSet().getPathString());
            return this.getElement();
        }
    }

    protected PsiElement rename(@NotNull String newName) throws IncorrectOperationException {
        String elementText;
        if (newName == null) {
            SassScssImportReference.$$$reportNull$$$0(5);
        }
        newName = this.createImportTextForFileName(newName);
        PsiElement element = this.getElement();
        if (element instanceof CssString && element.getContainingFile() instanceof SASSFile && !StringUtil.isQuotedString((String)(elementText = element.getText())) && FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            TextRange range = new TextRange(this.getFileReferenceSet().getStartInElement(), this.getRangeInElement().getEndOffset());
            String newText = range.replace(element.getText(), newName);
            PsiElement newStringToken = SassScssImportReference.createUnquotedStringToken(element.getProject(), newText);
            if (newStringToken != null) {
                element.getFirstChild().replace(newStringToken);
                return element;
            }
        }
        return super.rename(newName);
    }

    @Nullable
    private static PsiElement createUnquotedStringToken(@NotNull Project project, @NotNull String value) {
        if (project == null) {
            SassScssImportReference.$$$reportNull$$$0(6);
        }
        if (value == null) {
            SassScssImportReference.$$$reportNull$$$0(7);
        }
        String importText = "@import " + value;
        CssStylesheet stylesheet = CssElementFactory.getInstance((Project)project).createStylesheet(importText, (Language)SASSLanguage.INSTANCE);
        CssImport imports = (CssImport)PsiTreeUtil.findChildOfType((PsiElement)stylesheet, CssImport.class);
        CssString string = (CssString)PsiTreeUtil.getChildOfType((PsiElement)imports, CssString.class);
        return string != null ? (PsiElement)ArrayUtil.getFirstElement((Object[])string.getChildren()) : null;
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        int resultCount;
        Collection resultWithoutDirectories;
        if (containingFile == null) {
            SassScssImportReference.$$$reportNull$$$0(8);
        }
        String referenceText = this.getText();
        Collection result = Sets.newHashSet((Object[])super.innerResolve(caseSensitive, containingFile));
        if (this.isLast() && !referenceText.isEmpty()) {
            result.addAll(this.innerResolveWithNameVariants(caseSensitive, referenceText));
            result.addAll(this.innerResolveWithNameVariants(caseSensitive, "_" + referenceText));
        }
        if (this.isLast() && !(resultWithoutDirectories = Collections2.filter((Collection)result, input -> input.getElement() instanceof PsiFile)).isEmpty()) {
            result = resultWithoutDirectories;
        }
        ResolveResult[] resolveResultArray = (resultCount = result.size()) > 0 ? result.toArray(new ResolveResult[resultCount]) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            SassScssImportReference.$$$reportNull$$$0(9);
        }
        return resolveResultArray;
    }

    protected Collection<ResolveResult> innerResolveWithNameVariants(boolean caseSensitive, @NotNull String referenceText) {
        if (referenceText == null) {
            SassScssImportReference.$$$reportNull$$$0(10);
        }
        Collection<ResolveResult> result = this.innerResolve(caseSensitive, referenceText);
        if (!(SassScssImportReference.endsWithExtensions(referenceText, SCSS_EXT, new String[0]) || SassScssImportReference.endsWithExtensions(referenceText, SASS_EXT, new String[0]) || SassScssImportReference.endsWithExtensions(referenceText, CSS_EXT, new String[0]))) {
            result.addAll(this.innerResolve(caseSensitive, SassScssImportReference.withExtensions(referenceText, SASS_EXT, new String[0])));
            result.addAll(this.innerResolve(caseSensitive, SassScssImportReference.withExtensions(referenceText, SCSS_EXT, new String[0])));
            result.addAll(this.innerResolve(caseSensitive, SassScssImportReference.withExtensions(referenceText, CSS_EXT, new String[0])));
        }
        return result;
    }

    @NotNull
    protected Collection<ResolveResult> innerResolve(boolean caseSensitive, @NotNull String referenceText) {
        if (referenceText == null) {
            SassScssImportReference.$$$reportNull$$$0(11);
        }
        Collection contexts = this.getContexts();
        THashSet result = new THashSet();
        for (PsiFileSystemItem context : contexts) {
            if (context == null) continue;
            this.innerResolveInContext(referenceText, context, (Collection<ResolveResult>)result, caseSensitive);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            SassScssImportReference.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, final @NotNull Collection<ResolveResult> result, boolean caseSensitive) {
        if (text == null) {
            SassScssImportReference.$$$reportNull$$$0(13);
        }
        if (context == null) {
            SassScssImportReference.$$$reportNull$$$0(14);
        }
        if (result == null) {
            SassScssImportReference.$$$reportNull$$$0(15);
        }
        super.innerResolveInContext(text, context, result, caseSensitive);
        if (!this.isLast() && "**".equals(text)) {
            context.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof PsiDirectory) {
                        result.add(new PsiElementResolveResult((PsiElement)element));
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/references/SassScssImportReference$1", "execute"));
                }
            });
        }
        if (this.isLast() && "*".equals(SassScssImportReference.withoutExtension(text))) {
            final String extension = FileUtilRt.getExtension((String)text);
            context.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (FileUtilRt.extensionEquals((String)element.getName(), (String)extension)) {
                        result.add(new PsiElementResolveResult((PsiElement)element));
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/references/SassScssImportReference$2", "execute"));
                }
            });
        }
    }

    @NotNull
    protected String createImportTextForFileName(@NotNull String path) {
        if (path == null) {
            SassScssImportReference.$$$reportNull$$$0(16);
        }
        if (this.partialSupported(path)) {
            String parentPath = PathUtil.getParentPath((String)path);
            String fileName = this.dismissExtensionIfNeeded(PathUtil.getFileName((String)path));
            if (!fileName.isEmpty()) {
                if (StringUtil.startsWithChar((CharSequence)fileName, (char)'_') && fileName.length() > 1) {
                    fileName = fileName.substring(1);
                }
                String string = parentPath.isEmpty() ? fileName : parentPath + "/" + fileName;
                if (string == null) {
                    SassScssImportReference.$$$reportNull$$$0(17);
                }
                return string;
            }
        }
        String string = path;
        if (string == null) {
            SassScssImportReference.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    protected String dismissExtensionIfNeeded(@NotNull String path) {
        if (path == null) {
            SassScssImportReference.$$$reportNull$$$0(19);
        }
        String string = !SassScssImportReference.endsWithExtensions(path, CSS_EXT, SCSS_EXT) && !SassScssImportReference.endsWithExtensions(path, CSS_EXT, SASS_EXT) ? SassScssImportReference.withoutExtension(path) : path;
        if (string == null) {
            SassScssImportReference.$$$reportNull$$$0(20);
        }
        return string;
    }

    protected boolean partialSupported(PsiElement psiElement) {
        return psiElement instanceof SassScssStylesheetFile;
    }

    protected boolean partialSupported(@NotNull String path) {
        if (path == null) {
            SassScssImportReference.$$$reportNull$$$0(21);
        }
        return SassScssImportReference.endsWithExtensions(path, SCSS_EXT, new String[0]) || SassScssImportReference.endsWithExtensions(path, SASS_EXT, new String[0]);
    }

    protected static boolean endsWithExtensions(@NotNull String text, String extension, String ... rest) {
        if (text == null) {
            SassScssImportReference.$$$reportNull$$$0(22);
        }
        return text.endsWith(SassScssImportReference.withExtensions(EMPTY_STRING, extension, rest));
    }

    @NotNull
    protected static String withoutExtension(@NotNull String fileName) {
        int index;
        if (fileName == null) {
            SassScssImportReference.$$$reportNull$$$0(23);
        }
        if ((index = fileName.lastIndexOf(46)) < 0) {
            String string = fileName;
            if (string == null) {
                SassScssImportReference.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = fileName.substring(0, index);
        if (string == null) {
            SassScssImportReference.$$$reportNull$$$0(25);
        }
        return string;
    }

    protected static String withExtensions(String text, String extension, String ... rest) {
        return EXTENSIONS_JOINER.join((Object)text, (Object)extension, (Object[])rest);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/references/SassScssImportReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/references/SassScssImportReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameToCreate";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportTextForFileName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "dismissExtensionIfNeeded";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createUnquotedStringToken";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveWithNameVariants";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createImportTextForFileName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "dismissExtensionIfNeeded";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "partialSupported";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "endsWithExtensions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withoutExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

