/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.GotoTargetRendererProvider;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.usages.UsageView;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoTargetHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GotoTargetHandler.class);
    private final PsiElementListCellRenderer myDefaultTargetElementRenderer = new DefaultPsiElementListCellRenderer();
    private final DefaultListCellRenderer myActionElementRenderer = new ActionCellRenderer();

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GotoTargetHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GotoTargetHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(2);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureUsedKey());
        try {
            GotoData gotoData = this.getSourceAndTargetElements(editor, file2);
            if (gotoData != null) {
                this.show(project, editor, file2, gotoData);
            } else {
                this.chooseFromAmbiguousSources(editor, file2, (Consumer<? super GotoData>)((Consumer)data -> {
                    if (project == null) {
                        GotoTargetHandler.$$$reportNull$$$0(24);
                    }
                    if (editor == null) {
                        GotoTargetHandler.$$$reportNull$$$0(25);
                    }
                    if (file2 == null) {
                        GotoTargetHandler.$$$reportNull$$$0(26);
                    }
                    this.show(project, editor, file2, (GotoData)data);
                }));
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Navigation is not available here during index update");
        }
    }

    protected void chooseFromAmbiguousSources(Editor editor, PsiFile file2, Consumer<? super GotoData> successCallback) {
    }

    @NonNls
    protected abstract String getFeatureUsedKey();

    @Nullable
    protected abstract GotoData getSourceAndTargetElements(Editor var1, PsiFile var2);

    private void show(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, final @NotNull GotoData gotoData) {
        JScrollPane pane;
        boolean finished2;
        if (project == null) {
            GotoTargetHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GotoTargetHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(5);
        }
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(6);
        }
        PsiElement[] targets = gotoData.targets;
        List<AdditionalAction> additionalActions = gotoData.additionalActions;
        if (targets.length == 0 && additionalActions.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, this.getNotFoundMessage(project, editor, file2));
            return;
        }
        boolean bl = finished2 = gotoData.listUpdaterTask == null || gotoData.listUpdaterTask.isFinished();
        if (targets.length == 1 && additionalActions.isEmpty() && finished2) {
            this.navigateToElement(targets[0]);
            return;
        }
        for (PsiElement eachTarget : targets) {
            gotoData.renderers.put(eachTarget, GotoTargetHandler.createRenderer(gotoData, eachTarget));
        }
        String name = ((NavigationItem)gotoData.source).getName();
        String title = this.getChooserTitle(gotoData.source, name, targets.length, finished2);
        if (this.shouldSortTargets()) {
            Arrays.sort(targets, this.createComparator(gotoData));
        }
        ArrayList<AdditionalAction> allElements = new ArrayList<AdditionalAction>(targets.length + additionalActions.size());
        Collections.addAll(allElements, targets);
        allElements.addAll(additionalActions);
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(allElements);
        Ref usageView = new Ref();
        JBPopup popup2 = builder2.setNamerForFiltering(o -> {
            if (gotoData == null) {
                GotoTargetHandler.$$$reportNull$$$0(23);
            }
            if (o instanceof AdditionalAction) {
                return ((AdditionalAction)o).getText();
            }
            return this.getRenderer(o, gotoData).getElementText((PsiElement)o);
        }).setTitle(title).setFont(EditorUtil.getEditorFont()).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                }
                if (value instanceof AdditionalAction) {
                    return GotoTargetHandler.this.myActionElementRenderer.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                }
                PsiElementListCellRenderer renderer = GotoTargetHandler.this.getRenderer(value, gotoData);
                return renderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            }
        }).setItemsChosenCallback(selectedElements -> {
            if (project == null) {
                GotoTargetHandler.$$$reportNull$$$0(22);
            }
            for (Object element : selectedElements) {
                if (element instanceof AdditionalAction) {
                    ((AdditionalAction)element).execute();
                    continue;
                }
                Navigatable nav = element instanceof Navigatable ? (Navigatable)element : EditSourceUtil.getDescriptor((PsiElement)((PsiElement)element));
                try {
                    if (nav == null || !nav.canNavigate()) continue;
                    this.navigateToElement(nav);
                }
                catch (IndexNotReadyException e) {
                    DumbService.getInstance((Project)project).showDumbModeNotification("Navigation is not available while indexing");
                }
            }
        }).withHintUpdateSupply().setMovable(true).setCancelCallback(() -> {
            BackgroundUpdaterTask task;
            if (gotoData == null) {
                GotoTargetHandler.$$$reportNull$$$0(21);
            }
            if ((task = gotoData.listUpdaterTask) != null) {
                task.cancelTask();
            }
            return true;
        }).setCouldPin(popup1 -> {
            if (gotoData == null) {
                GotoTargetHandler.$$$reportNull$$$0(20);
            }
            usageView.set((Object)FindUtil.showInUsageView(gotoData.source, gotoData.targets, this.getFindUsagesTitle(gotoData.source, name, gotoData.targets.length), gotoData.source.getProject()));
            popup1.cancel();
            return false;
        }).setAdText(this.getAdText(gotoData.source, targets.length)).createPopup();
        JScrollPane jScrollPane = pane = builder2 instanceof PopupChooserBuilder ? ((PopupChooserBuilder)builder2).getScrollPane() : null;
        if (pane != null) {
            pane.setBorder(null);
            pane.setViewportBorder(null);
        }
        if (gotoData.listUpdaterTask != null) {
            Alarm alarm = new Alarm((Disposable)popup2);
            alarm.addRequest(() -> {
                if (editor == null) {
                    GotoTargetHandler.$$$reportNull$$$0(19);
                }
                if (!editor.isDisposed()) {
                    popup2.showInBestPositionFor(editor);
                }
            }, 300);
            gotoData.listUpdaterTask.init(popup2, builder2.getBackgroundUpdater(), (Ref<? extends UsageView>)usageView);
            ProgressManager.getInstance().run((Task)gotoData.listUpdaterTask);
        } else {
            popup2.showInBestPositionFor(editor);
        }
    }

    @NotNull
    protected PsiElementListCellRenderer getRenderer(Object value, @NotNull GotoData gotoData) {
        PsiElementListCellRenderer renderer;
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(7);
        }
        PsiElementListCellRenderer psiElementListCellRenderer = (renderer = gotoData.getRenderer(value)) != null ? renderer : this.myDefaultTargetElementRenderer;
        if (psiElementListCellRenderer == null) {
            GotoTargetHandler.$$$reportNull$$$0(8);
        }
        return psiElementListCellRenderer;
    }

    @NotNull
    protected Comparator<PsiElement> createComparator(final @NotNull GotoData gotoData) {
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(9);
        }
        Comparator<PsiElement> comparator2 = new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                return this.getComparingObject(o1).compareTo(this.getComparingObject(o2));
            }

            private Comparable getComparingObject(PsiElement o1) {
                return GotoTargetHandler.this.getRenderer(o1, gotoData).getComparingObject(o1);
            }
        };
        if (comparator2 == null) {
            GotoTargetHandler.$$$reportNull$$$0(10);
        }
        return comparator2;
    }

    public static PsiElementListCellRenderer createRenderer(@NotNull GotoData gotoData, @NotNull PsiElement eachTarget) {
        if (gotoData == null) {
            GotoTargetHandler.$$$reportNull$$$0(11);
        }
        if (eachTarget == null) {
            GotoTargetHandler.$$$reportNull$$$0(12);
        }
        for (GotoTargetRendererProvider eachProvider : GotoTargetRendererProvider.EP_NAME.getExtensionList()) {
            PsiElementListCellRenderer renderer = eachProvider.getRenderer(eachTarget, gotoData);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    protected boolean navigateToElement(PsiElement target2) {
        Navigatable descriptor;
        Navigatable navigatable = descriptor = target2 instanceof Navigatable ? (Navigatable)target2 : EditSourceUtil.getDescriptor((PsiElement)target2);
        if (descriptor != null && descriptor.canNavigate()) {
            this.navigateToElement(descriptor);
            return true;
        }
        return false;
    }

    protected void navigateToElement(@NotNull Navigatable descriptor) {
        if (descriptor == null) {
            GotoTargetHandler.$$$reportNull$$$0(13);
        }
        descriptor.navigate(true);
    }

    protected boolean shouldSortTargets() {
        return true;
    }

    @Deprecated
    @NotNull
    protected String getChooserTitle(PsiElement sourceElement, String name, int length) {
        LOG.warn("Please override getChooserTitle(PsiElement, String, int, boolean) instead");
        if ("" == null) {
            GotoTargetHandler.$$$reportNull$$$0(14);
        }
        return "";
    }

    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished2) {
        if (sourceElement == null) {
            GotoTargetHandler.$$$reportNull$$$0(15);
        }
        String string = this.getChooserTitle(sourceElement, name, length);
        if (string == null) {
            GotoTargetHandler.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            GotoTargetHandler.$$$reportNull$$$0(17);
        }
        String string = this.getChooserTitle(sourceElement, name, length, true);
        if (string == null) {
            GotoTargetHandler.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    protected abstract String getNotFoundMessage(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @Nullable
    protected String getAdText(PsiElement source, int length) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoData";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/GotoTargetHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachTarget";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/GotoTargetHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparator";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createComparator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "navigateToElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$show$5";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$show$4";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$show$3";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$show$2";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$show$1";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionCellRenderer
    extends DefaultListCellRenderer {
        private ActionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result2 = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
            if (value != null) {
                AdditionalAction action = (AdditionalAction)value;
                this.setText(action.getText());
                this.setIcon(action.getIcon());
            }
            return result2;
        }
    }

    private static class DefaultPsiElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DefaultPsiElementListCellRenderer() {
        }

        public String getElementText(PsiElement element) {
            String name;
            if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
                return name;
            }
            return element.getContainingFile().getName();
        }

        protected String getContainerText(PsiElement element, String name) {
            if (element instanceof NavigationItem) {
                ItemPresentation presentation = ((NavigationItem)element).getPresentation();
                return presentation != null ? presentation.getLocationString() : null;
            }
            return null;
        }

        @Override
        protected int getIconFlags() {
            return 0;
        }
    }

    public static class GotoData {
        @NotNull
        public final PsiElement source;
        public PsiElement[] targets;
        public final List<AdditionalAction> additionalActions;
        private boolean hasDifferentNames;
        public BackgroundUpdaterTask listUpdaterTask;
        protected final Set<String> myNames;
        public Map<Object, PsiElementListCellRenderer> renderers;

        public GotoData(@NotNull PsiElement source, @NotNull PsiElement[] targets, @NotNull List<AdditionalAction> additionalActions) {
            if (source == null) {
                GotoData.$$$reportNull$$$0(0);
            }
            if (targets == null) {
                GotoData.$$$reportNull$$$0(1);
            }
            if (additionalActions == null) {
                GotoData.$$$reportNull$$$0(2);
            }
            this.renderers = new HashMap<Object, PsiElementListCellRenderer>();
            this.source = source;
            this.targets = targets;
            this.additionalActions = additionalActions;
            this.myNames = new HashSet<String>();
            for (PsiElement target2 : targets) {
                if (!(target2 instanceof PsiNamedElement)) continue;
                this.myNames.add(((PsiNamedElement)target2).getName());
                if (this.myNames.size() > 1) break;
            }
            this.hasDifferentNames = this.myNames.size() > 1;
        }

        public boolean hasDifferentNames() {
            return this.hasDifferentNames;
        }

        public boolean addTarget(PsiElement element) {
            if (ArrayUtil.find((Object[])this.targets, (Object)element) > -1) {
                return false;
            }
            this.targets = (PsiElement[])ArrayUtil.append((Object[])this.targets, (Object)element);
            this.renderers.put(element, GotoTargetHandler.createRenderer(this, element));
            if (!this.hasDifferentNames && element instanceof PsiNamedElement) {
                String name = (String)ReadAction.compute(() -> ((PsiNamedElement)element).getName());
                this.myNames.add(name);
                this.hasDifferentNames = this.myNames.size() > 1;
            }
            return true;
        }

        public PsiElementListCellRenderer getRenderer(Object value) {
            return this.renderers.get(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targets";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "additionalActions";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface AdditionalAction {
        @NotNull
        public String getText();

        public Icon getIcon();

        public void execute();
    }
}

