/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.idea.perforce.perforce.jobs.JobsSearchSpecificator;

public class JobViewSearchSpecificator
implements JobsSearchSpecificator {
    private final String myJobView;
    private final String myCustomFilter;

    public JobViewSearchSpecificator(String jobView, String customFilter) {
        this.myJobView = jobView;
        this.myCustomFilter = customFilter;
    }

    @Override
    public String[] addParams(String[] s) {
        boolean notEmptyCustomFilter;
        ArrayList<String> list = new ArrayList<String>(s.length + 2);
        ContainerUtil.addAll(list, (Object[])s);
        list.add("-m");
        list.add("501");
        boolean notEmptyJobView = !StringUtil.isEmptyOrSpaces((String)this.myJobView);
        boolean bl = notEmptyCustomFilter = !StringUtil.isEmptyOrSpaces((String)this.myCustomFilter);
        if (notEmptyJobView || notEmptyCustomFilter) {
            list.add("-e");
            StringBuilder sb = new StringBuilder();
            if (notEmptyJobView) {
                sb.append("(").append(this.myJobView).append(")");
            }
            if (notEmptyCustomFilter) {
                if (notEmptyJobView) {
                    sb.append(" & ");
                }
                sb.append("(").append(this.myCustomFilter).append(")");
            }
            list.add(sb.toString());
        }
        return ArrayUtil.toStringArray(list);
    }

    @Override
    public int getMaxCount() {
        return 50;
    }
}

