/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringOptions;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringUtil;
import org.intellij.lang.xpath.xslt.refactoring.XsltRefactoringActionBase;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;

public abstract class BaseIntroduceAction<Settings extends RefactoringOptions>
extends XsltRefactoringActionBase {
    protected abstract String getCommandName();

    protected abstract Settings getSettings(XPathExpression var1, Set<XPathExpression> var2);

    protected abstract boolean extractImpl(XPathExpression var1, Set<XPathExpression> var2, List<XmlTag> var3, Settings var4);

    @Override
    public String getErrorMessage(Editor editor, PsiFile file, XmlAttribute context) {
        if (context != null) {
            if (XsltSupport.isPatternAttribute(context)) {
                return "Match patterns may not contain variable references.";
            }
            if (XsltSupport.isXPathAttribute(context) && editor.getSelectionModel().hasSelection()) {
                return "Please select a complete XPath expression to extract.";
            }
        }
        return super.getErrorMessage(editor, file, context);
    }

    @Override
    protected boolean actionPerformedImpl(PsiFile file, Editor editor, XmlAttribute context, int offset) {
        if (!(file instanceof XPathFile)) {
            return false;
        }
        if (XsltSupport.isPatternAttribute(context)) {
            return false;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        boolean hasSelection = selectionModel.hasSelection();
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        if (hasSelection) {
            PsiElement xpathElement = file.findElementAt(start);
            if (xpathElement != null) {
                XPathExpression expression = (XPathExpression)PsiTreeUtil.getParentOfType((PsiElement)xpathElement, XPathExpression.class);
                while (expression != null) {
                    if (expression.getTextRange().getStartOffset() == start) {
                        int diff = expression.getTextRange().getEndOffset() - end;
                        if (diff == 0) {
                            this.extractFromExpression(editor, expression);
                            return true;
                        }
                        if (diff > 0) break;
                    }
                    expression = (XPathExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, XPathExpression.class);
                }
            }
        } else {
            XPathExpression expression = (XPathExpression)PsiTreeUtil.getChildOfType((PsiElement)file, XPathExpression.class);
            if (expression != null) {
                PsiFile containingFile = expression.getContainingFile();
                assert (containingFile != null);
                TextRange range = expression.getTextRange();
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                this.extractFromExpression(editor, expression);
                return true;
            }
        }
        return false;
    }

    private void extractFromExpression(Editor e, XPathExpression expression) {
        Settings dlg;
        Editor editor = e instanceof EditorWindow ? ((EditorWindow)e).getDelegate() : e;
        HighlightManager highlightManager = HighlightManager.getInstance((Project)expression.getProject());
        Set<XPathExpression> matchingExpressions = RefactoringUtil.collectMatchingExpressions(expression);
        ArrayList<XmlTag> otherMatches = new ArrayList<XmlTag>(matchingExpressions.size());
        ArrayList highlighters = new ArrayList(matchingExpressions.size() + 1);
        if (matchingExpressions.size() > 0) {
            SelectionModel selectionModel = editor.getSelectionModel();
            highlightManager.addRangeHighlight(editor, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), EditorColors.SEARCH_RESULT_ATTRIBUTES.getDefaultAttributes(), false, highlighters);
            for (XPathExpression expr : matchingExpressions) {
                TextRange range = XsltCodeInsightUtil.getRangeInsideHostingFile(expr);
                highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES.getDefaultAttributes(), false, highlighters);
                XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)expr, XmlTag.class, (boolean)true);
                assert (tag != null);
                otherMatches.add(tag);
            }
        }
        if ((dlg = this.getSettings(expression, matchingExpressions)) == null || dlg.isCanceled()) {
            return;
        }
        if (this.getCommandName() != null) {
            WriteCommandAction.writeCommandAction((Project)e.getProject()).withName(this.getCommandName()).run(() -> {
                if (this.extractImpl(expression, matchingExpressions, otherMatches, dlg)) {
                    for (RangeHighlighter highlighter : highlighters) {
                        highlighter.dispose();
                    }
                }
            });
        } else {
            this.extractImpl(expression, matchingExpressions, otherMatches, dlg);
        }
    }
}

