/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.models;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.models.SearchDetailsTreeModel;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedNodesListNode;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedRetainerNode;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.RightAlignedRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.SizeRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetainersTreeModel
implements TreeTableModelWithCustomRenderer {
    private final ColumnInfo[] myColumns;
    private final Object myRoot = new Object();
    public String myDescription = "Description: ";
    public List<String> myDescriptionDetails;
    public static final String ROOT_CHAIN = "Chain from root:";
    private static final String RETAINERS = "Retainers:";
    private final List<String> mySecondLevel;
    private final List<List<FixedRetainerNode>> myData;
    private final List<FixedNodesListNode> myFromRootChain;
    private final Project myProject;
    private final V8CachingReader myReader;
    private final V8HeapEntry myMain;
    private final V8HeapEdge myMainEdge;

    public RetainersTreeModel(Project project, V8CachingReader reader, V8HeapEntry main, V8HeapEdge mainEdge, List<Pair<V8HeapEntry, V8HeapEdge>> data, Object[] pathFromRoot) {
        this.myProject = project;
        this.myReader = reader;
        this.myMain = main;
        this.myMainEdge = mainEdge;
        this.myColumns = new ColumnInfo[4];
        RetainersTreeModel.fillColumns(this.myProject, this.myColumns, this.myReader, null);
        this.myData = new ArrayList<List<FixedRetainerNode>>();
        this.myFromRootChain = new ArrayList<FixedNodesListNode>();
        this.fillData(main, mainEdge, data, pathFromRoot);
        this.mySecondLevel = new ArrayList<String>();
        this.createDescription();
        this.mySecondLevel.add(this.myDescription);
        this.mySecondLevel.add(ROOT_CHAIN);
        this.mySecondLevel.add(RETAINERS);
    }

    private void createDescription() {
        this.myDescriptionDetails = new ArrayList<String>(2);
        if (this.myMainEdge != null) {
            this.myDescription = this.myDescription + " link: " + this.myMainEdge.getType().getName() + " /";
            this.myDescriptionDetails.add("Link: " + this.myMainEdge.getType().getDescription());
        }
        this.myDescription = this.myDescription + " object: " + this.myMain.getType().getName();
        this.myDescriptionDetails.add("Object: " + this.myMain.getType().getDescription());
    }

    public static void fillColumns(Project project, ColumnInfo[] columns, final V8CachingReader reader, ColoredTreeCellRenderer renderer) {
        final ColoredTreeCellRenderer firstCellRenderer = renderer == null ? new DirectTreeTableRenderer(project, reader) : renderer;
        columns[0] = new ColumnInfo<Object, Object>("Object"){

            @Nullable
            public Object valueOf(Object entry) {
                return entry;
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                if (renderer instanceof TreeTableCellRenderer) {
                    ((TreeTableCellRenderer)renderer).setCellRenderer((TreeCellRenderer)firstCellRenderer);
                }
                return super.getCustomizedRenderer(o, renderer);
            }
        };
        final RightAlignedRenderer alignedRenderer = new RightAlignedRenderer();
        columns[1] = new ColumnInfo<Object, String>("Distance"){

            @Nullable
            public String valueOf(Object entry) {
                if (entry instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                    int distance = reader.getDistance((int)((V8HeapContainmentTreeTableModel.NamedEntry)entry).getEntry().getId());
                    return distance >= 100000000 ? "-" : String.valueOf(distance);
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return alignedRenderer;
            }
        };
        final SizeRenderer sizeRenderer = new SizeRenderer(reader.getRetainedSize(0));
        columns[2] = new ColumnInfo<Object, Object>("Shallow size"){

            @Nullable
            public Object valueOf(Object entry) {
                if (entry instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                    return ((V8HeapContainmentTreeTableModel.NamedEntry)entry).getEntry().getSize();
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return sizeRenderer;
            }
        };
        columns[3] = new ColumnInfo<Object, Object>("Retained size"){

            @Nullable
            public Object valueOf(Object entry) {
                if (entry instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                    return reader.getRetainedSize((int)((V8HeapContainmentTreeTableModel.NamedEntry)entry).getEntry().getId());
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return sizeRenderer;
            }
        };
    }

    private void fillData(V8HeapEntry main, V8HeapEdge mainEdge, List<Pair<V8HeapEntry, V8HeapEdge>> data, Object[] pathFromRoot) {
        int i;
        if (pathFromRoot != null) {
            for (i = 1; i < pathFromRoot.length; ++i) {
                Object node = pathFromRoot[i];
                if (!(node instanceof V8HeapContainmentTreeTableModel.NamedEntry)) continue;
                V8HeapContainmentTreeTableModel.NamedEntry namedEntry = (V8HeapContainmentTreeTableModel.NamedEntry)node;
                this.myFromRootChain.add(new FixedNodesListNode(namedEntry, -100, i - 1));
            }
        } else {
            List<FixedRetainerNode> chain = SearchDetailsTreeModel.getChainToRoot(-100, main, mainEdge, this.myReader);
            for (int i2 = 0; i2 < chain.size(); ++i2) {
                FixedNodesListNode node = chain.get(i2);
                this.myFromRootChain.add(new FixedNodesListNode(node, node.getVariantId(), i2));
            }
        }
        for (i = 0; i < data.size(); ++i) {
            Pair<V8HeapEntry, V8HeapEdge> pair = data.get(i);
            List<FixedRetainerNode> chain = SearchDetailsTreeModel.getChainToRoot(i, (V8HeapEntry)pair.getFirst(), (V8HeapEdge)pair.getSecond(), this.myReader);
            Collections.reverse(chain);
            for (int j = 0; j < chain.size(); ++j) {
                FixedNodesListNode node = chain.get(j);
                node.setLevelNum(j);
            }
            this.myData.add(chain);
        }
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(o, renderer);
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.myRoot) {
            return this.mySecondLevel.get(index);
        }
        if (parent == ROOT_CHAIN) {
            return this.myFromRootChain.get(0);
        }
        if (parent == RETAINERS) {
            return this.myData.get(index).get(0);
        }
        if (parent == this.myDescription) {
            return this.myDescriptionDetails.get(index);
        }
        if (parent instanceof FixedNodesListNode) {
            FixedNodesListNode node = (FixedNodesListNode)parent;
            if (((FixedNodesListNode)parent).getVariantId() == -100) {
                return this.myFromRootChain.size() <= node.getLevelNum() + 1 ? null : this.myFromRootChain.get(node.getLevelNum() + 1);
            }
            List<FixedRetainerNode> list = this.myData.get(node.getVariantId());
            return list.size() <= node.getLevelNum() + 1 ? null : list.get(node.getLevelNum() + 1);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent == this.myRoot) {
            return this.mySecondLevel.size();
        }
        if (parent == ROOT_CHAIN) {
            return 1;
        }
        if (parent == RETAINERS) {
            return this.myData.size();
        }
        if (parent == this.myDescription) {
            return this.myDescriptionDetails.size();
        }
        if (parent instanceof FixedNodesListNode) {
            FixedNodesListNode node = (FixedNodesListNode)parent;
            if (((FixedNodesListNode)parent).getVariantId() == -100) {
                return this.myFromRootChain.size() <= node.getLevelNum() + 1 ? 0 : 1;
            }
            List<FixedRetainerNode> list = this.myData.get(node.getVariantId());
            return list.size() <= node.getLevelNum() + 1 ? 0 : 1;
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.myRoot) {
            return this.mySecondLevel.get(0).equals(child) ? 0 : 1;
        }
        if (parent == ROOT_CHAIN) {
            return 0;
        }
        if (parent == RETAINERS) {
            for (int i = 0; i < this.myData.size(); ++i) {
                List<FixedRetainerNode> nodes = this.myData.get(i);
                if (!nodes.get(0).equals(child)) continue;
                return i;
            }
        } else if (parent == this.myDescription) {
            for (int i = 0; i < this.myDescriptionDetails.size(); ++i) {
                String s = this.myDescriptionDetails.get(i);
                if (!s.equals(child)) continue;
                return i;
            }
        } else if (parent instanceof FixedNodesListNode) {
            return 0;
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public V8HeapEntry getMain() {
        return this.myMain;
    }

    public V8HeapEdge getMainEdge() {
        return this.myMainEdge;
    }

    public void expandByDefault(V8HeapTreeTable retainersTable) {
        ArrayList<Object> fromRoot = new ArrayList<Object>(this.myFromRootChain.size() + 2);
        fromRoot.add(this.myRoot);
        fromRoot.add(ROOT_CHAIN);
        fromRoot.addAll(this.myFromRootChain.subList(0, this.myFromRootChain.size() - 1));
        retainersTable.getTree().expandPath(new TreePath(ArrayUtil.toObjectArray(fromRoot)));
        retainersTable.getTree().expandPath(new TreePath(new Object[]{this.myRoot, RETAINERS}));
    }

    public boolean navigatableSelected(Object currentlySelected) {
        if (currentlySelected == null) {
            return false;
        }
        if (currentlySelected == ROOT_CHAIN) {
            return true;
        }
        if (currentlySelected == RETAINERS) {
            return false;
        }
        if (currentlySelected instanceof FixedRetainerNode) {
            return true;
        }
        return currentlySelected instanceof FixedNodesListNode;
    }

    public List<V8HeapContainmentTreeTableModel.NamedEntry> getPathForSelectionInMainTree(Object currentlySelected) {
        if (currentlySelected == null) {
            return null;
        }
        if (currentlySelected == ROOT_CHAIN) {
            return this.getFromRootFragment(null);
        }
        if (currentlySelected == RETAINERS) {
            return null;
        }
        if (currentlySelected instanceof FixedRetainerNode) {
            return this.getFromRetainersFragment((FixedRetainerNode)currentlySelected);
        }
        if (currentlySelected instanceof FixedNodesListNode) {
            return this.getFromRootFragment((FixedNodesListNode)currentlySelected);
        }
        return null;
    }

    private List<V8HeapContainmentTreeTableModel.NamedEntry> getFromRetainersFragment(@NotNull FixedRetainerNode selected) {
        if (selected == null) {
            RetainersTreeModel.$$$reportNull$$$0(0);
        }
        ArrayList<V8HeapContainmentTreeTableModel.NamedEntry> list = new ArrayList<V8HeapContainmentTreeTableModel.NamedEntry>();
        list.add(new V8HeapContainmentTreeTableModel.NamedEntry(this.myReader.getNode(0L), "", "", -1L));
        int variantId = selected.getVariantId();
        List<FixedRetainerNode> nodes = this.myData.get(variantId);
        for (int i = nodes.size() - 1; i >= 0; --i) {
            FixedRetainerNode node = nodes.get(i);
            list.add(node);
            if (node.equals(selected)) break;
        }
        return list;
    }

    private List<V8HeapContainmentTreeTableModel.NamedEntry> getFromRootFragment(@Nullable FixedNodesListNode lastNode) {
        ArrayList<V8HeapContainmentTreeTableModel.NamedEntry> list = new ArrayList<V8HeapContainmentTreeTableModel.NamedEntry>();
        list.add(new V8HeapContainmentTreeTableModel.NamedEntry(this.myReader.getNode(0L), "", "", -1L));
        for (FixedNodesListNode node : this.myFromRootChain) {
            list.add(node);
            if (!node.equals(lastNode)) continue;
            break;
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/jetbrains/nodejs/run/profile/heap/view/models/RetainersTreeModel", "getFromRetainersFragment"));
    }
}

